/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.Remove;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.id.CompositeNestedGeneratedValueGenerator;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MappingHelper;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.UserComponentType;
import org.hibernate.usertype.CompositeUserType;

public class Component
extends SimpleValue
implements MetaAttributable,
SortableValue {
    private String componentClassName;
    private boolean embedded;
    private String parentProperty;
    private PersistentClass owner;
    private boolean dynamic;
    private boolean isKey;
    private Boolean isGeneric;
    private String roleName;
    private final ArrayList<Property> properties = new ArrayList();
    private int[] originalPropertyOrder = ArrayHelper.EMPTY_INT_ARRAY;
    private Map<String, MetaAttribute> metaAttributes;
    private Class<? extends EmbeddableInstantiator> customInstantiator;
    private Constructor<?> instantiator;
    private String[] instantiatorPropertyNames;
    private volatile CompositeType type;
    private AggregateColumn aggregateColumn;
    private AggregateColumn parentAggregateColumn;
    private String structName;
    private String[] structColumnNames;
    private transient List<Selectable> cachedSelectables;
    private transient List<Column> cachedColumns;
    private transient Generator builtIdentifierGenerator;

    public Component(MetadataBuildingContext metadata, PersistentClass owner) throws MappingException {
        this(metadata, owner.getTable(), owner);
    }

    public Component(MetadataBuildingContext metadata, Component component) throws MappingException {
        this(metadata, component.getTable(), component.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Join join) throws MappingException {
        this(metadata, join.getTable(), join.getPersistentClass());
    }

    public Component(MetadataBuildingContext metadata, Collection collection) throws MappingException {
        this(metadata, collection.getCollectionTable(), collection.getOwner());
    }

    public Component(MetadataBuildingContext metadata, Table table, PersistentClass owner) throws MappingException {
        super(metadata, table);
        this.owner = owner;
        metadata.getMetadataCollector().registerComponent(this);
    }

    private Component(Component original) {
        super(original);
        this.properties.addAll(original.properties);
        this.originalPropertyOrder = original.originalPropertyOrder == null ? null : (int[])original.originalPropertyOrder.clone();
        this.componentClassName = original.componentClassName;
        this.embedded = original.embedded;
        this.parentProperty = original.parentProperty;
        this.owner = original.owner;
        this.dynamic = original.dynamic;
        this.isGeneric = original.isGeneric;
        this.metaAttributes = original.metaAttributes == null ? null : new HashMap<String, MetaAttribute>(original.metaAttributes);
        this.isKey = original.isKey;
        this.roleName = original.roleName;
        this.customInstantiator = original.customInstantiator;
        this.type = original.type;
    }

    @Override
    public Component copy() {
        return new Component(this);
    }

    public int getPropertySpan() {
        return this.properties.size();
    }

    @Deprecated
    @Remove
    public Iterator<Property> getPropertyIterator() {
        return this.properties.iterator();
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void addProperty(Property p) {
        this.properties.add(p);
        this.propertiesListModified();
    }

    private void propertiesListModified() {
        this.cachedSelectables = null;
        this.cachedColumns = null;
    }

    @Override
    public void addColumn(Column column) {
        throw new UnsupportedOperationException("Cant add a column to a component");
    }

    @Override
    public List<Selectable> getSelectables() {
        if (this.cachedSelectables == null) {
            this.cachedSelectables = this.properties.stream().flatMap(p -> p.getSelectables().stream()).collect(Collectors.toList());
        }
        return this.cachedSelectables;
    }

    @Override
    public List<Column> getColumns() {
        if (this.cachedColumns != null) {
            return this.cachedColumns;
        }
        this.cachedColumns = this.properties.stream().flatMap(p -> p.getValue().getColumns().stream()).collect(Collectors.toList());
        return this.cachedColumns;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public AggregateColumn getAggregateColumn() {
        return this.aggregateColumn;
    }

    public void setAggregateColumn(AggregateColumn aggregateColumn) {
        this.aggregateColumn = aggregateColumn;
        this.notifyPropertiesAboutAggregateColumn(aggregateColumn, this);
    }

    @Override
    public int getColumnSpan() {
        return this.getSelectables().size();
    }

    public List<Column> getAggregatedColumns() {
        ArrayList<Column> aggregatedColumns = new ArrayList<Column>(this.getPropertySpan());
        this.collectAggregatedColumns(aggregatedColumns, this);
        return aggregatedColumns;
    }

    private void collectAggregatedColumns(List<Column> aggregatedColumns, Component component) {
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof Component) {
                Component subComponent = (Component)value;
                AggregateColumn subAggregate = subComponent.getAggregateColumn();
                if (subAggregate != null) {
                    aggregatedColumns.add(subAggregate);
                    continue;
                }
                this.collectAggregatedColumns(aggregatedColumns, subComponent);
                continue;
            }
            aggregatedColumns.addAll(value.getColumns());
        }
    }

    private void notifyPropertiesAboutAggregateColumn(AggregateColumn aggregateColumn, Component component) {
        for (Property property : component.getProperties()) {
            Value value = property.getValue();
            if (value instanceof BasicValue) {
                assert (((BasicValue)value).getResolution() == null);
                ((BasicValue)value).setAggregateColumn(aggregateColumn);
                continue;
            }
            if (!(value instanceof Component)) continue;
            Component subComponent = (Component)value;
            if (subComponent.getAggregateColumn() == null) {
                subComponent.notifyPropertiesAboutAggregateColumn(aggregateColumn, subComponent);
                continue;
            }
            ((Component)value).setParentAggregateColumn(aggregateColumn);
        }
    }

    public AggregateColumn getParentAggregateColumn() {
        return this.parentAggregateColumn;
    }

    public void setParentAggregateColumn(AggregateColumn parentAggregateColumn) {
        this.parentAggregateColumn = parentAggregateColumn;
    }

    public String getStructName() {
        return this.structName;
    }

    public void setStructName(String structName) {
        this.structName = structName;
    }

    @Override
    public void checkColumnDuplication(Set<String> distinctColumns, String owner) {
        if (this.aggregateColumn == null) {
            MappingHelper.checkPropertyColumnDuplication(distinctColumns, this.getProperties(), owner);
        } else {
            MappingHelper.checkPropertyColumnDuplication(new HashSet<String>(), this.getProperties(), "component '" + this.getRoleName() + "'");
            this.aggregateColumn.getValue().checkColumnDuplication(distinctColumns, owner);
        }
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public Class<?> getComponentClass() throws MappingException {
        if (this.componentClassName == null) {
            return null;
        }
        ClassLoaderService classLoaderService = this.getMetadata().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
        try {
            return classLoaderService.classForName(this.componentClassName);
        }
        catch (ClassLoadingException e) {
            throw new MappingException("component class not found: " + this.componentClassName, (Throwable)((Object)e));
        }
    }

    public PersistentClass getOwner() {
        return this.owner;
    }

    public String getParentProperty() {
        return this.parentProperty;
    }

    public void setComponentClassName(String componentClass) {
        this.componentClassName = componentClass;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setOwner(PersistentClass owner) {
        this.owner = owner;
    }

    public void setParentProperty(String parentProperty) {
        this.parentProperty = parentProperty;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    private CompositeUserType<?> createCompositeUserType(Component component) {
        BootstrapContext bootstrapContext = this.getBuildingContext().getBootstrapContext();
        Class customTypeClass = bootstrapContext.getClassLoaderAccess().classForName(component.getTypeName());
        return this.getBuildingContext().getBuildingOptions().disallowExtensionsInCdi() ? (CompositeUserType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(customTypeClass) : (CompositeUserType)bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(customTypeClass).getBeanInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType getType() throws MappingException {
        UserComponentType localType = this.type;
        if (localType == null) {
            Component component = this;
            synchronized (component) {
                localType = this.type;
                if (localType == null) {
                    this.sortProperties(true);
                    String typeName = this.getTypeName();
                    if (typeName == null) {
                        localType = this.isEmbedded() ? new EmbeddedComponentType(this, this.originalPropertyOrder) : new ComponentType(this, this.originalPropertyOrder);
                    } else {
                        CompositeUserType<?> compositeUserType = this.createCompositeUserType(this);
                        localType = new UserComponentType(this, this.originalPropertyOrder, compositeUserType);
                    }
                    this.type = localType;
                }
            }
        }
        return localType;
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
    }

    @Override
    public Map<String, MetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    @Override
    public MetaAttribute getMetaAttribute(String attributeName) {
        return this.metaAttributes == null ? null : this.metaAttributes.get(attributeName);
    }

    @Override
    public void setMetaAttributes(Map<String, MetaAttribute> metas) {
        this.metaAttributes = metas;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isSame(SimpleValue other) {
        return other instanceof Component && this.isSame((Component)other);
    }

    public boolean isSame(Component other) {
        return super.isSame(other) && Objects.equals(this.properties, other.properties) && Objects.equals(this.componentClassName, other.componentClassName) && this.embedded == other.embedded && Objects.equals(this.aggregateColumn, other.aggregateColumn) && Objects.equals(this.parentAggregateColumn, other.parentAggregateColumn) && Objects.equals(this.structName, other.structName) && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.metaAttributes, other.metaAttributes);
    }

    @Override
    public boolean[] getColumnInsertability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            boolean[] chunk = prop.getValue().getColumnInsertability();
            if (prop.isInsertable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public boolean hasAnyInsertableColumns() {
        for (Property property : this.properties) {
            if (!property.getValue().hasAnyInsertableColumns()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] getColumnUpdateability() {
        boolean[] result = new boolean[this.getColumnSpan()];
        int i = 0;
        for (Property prop : this.getProperties()) {
            boolean[] chunk = prop.getValue().getColumnUpdateability();
            if (prop.isUpdateable()) {
                System.arraycopy(chunk, 0, result, i, chunk.length);
            }
            i += chunk.length;
        }
        return result;
    }

    @Override
    public boolean hasAnyUpdatableColumns() {
        for (Property property : this.properties) {
            if (!property.getValue().hasAnyUpdatableColumns()) continue;
            return true;
        }
        return false;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean isKey) {
        this.isKey = isKey;
    }

    public boolean hasPojoRepresentation() {
        return this.componentClassName != null;
    }

    public Property getProperty(int index) {
        return this.properties.get(index);
    }

    public Property getProperty(String propertyName) throws MappingException {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        throw new MappingException("component: " + this.componentClassName + " property not found: " + propertyName);
    }

    public boolean matchesAllProperties(String ... propertyNames) {
        return this.properties.size() == propertyNames.length && new HashSet(this.properties.stream().map(Property::getName).collect(Collectors.toList())).containsAll(List.of(propertyNames));
    }

    public boolean hasProperty(String propertyName) {
        for (Property prop : this.properties) {
            if (!prop.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.componentClassName + ")";
    }

    @Override
    public Generator createGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, RootClass rootClass) throws MappingException {
        if (this.builtIdentifierGenerator == null) {
            this.builtIdentifierGenerator = this.buildIdentifierGenerator(identifierGeneratorFactory, dialect, rootClass);
        }
        return this.builtIdentifierGenerator;
    }

    private Generator buildIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, RootClass rootClass) throws MappingException {
        boolean hasCustomGenerator;
        boolean bl = hasCustomGenerator = !"assigned".equals(this.getIdentifierGeneratorStrategy());
        if (hasCustomGenerator) {
            return super.createGenerator(identifierGeneratorFactory, dialect, rootClass);
        }
        Class<?> entityClass = rootClass.getMappedClass();
        Class<?> attributeDeclarer = rootClass.getIdentifierMapper() != null ? this.resolveComponentClass() : (rootClass.getIdentifierProperty() != null ? this.resolveComponentClass() : entityClass);
        StandardGenerationContextLocator locator = new StandardGenerationContextLocator(rootClass.getEntityName());
        CompositeNestedGeneratedValueGenerator generator = new CompositeNestedGeneratedValueGenerator(locator);
        for (Property property : this.getProperties()) {
            SimpleValue value;
            if (!property.getValue().isSimpleValue() || "assigned".equals((value = (SimpleValue)property.getValue()).getIdentifierGeneratorStrategy())) continue;
            Generator subgenerator = value.createGenerator(identifierGeneratorFactory, dialect, rootClass);
            generator.addGeneratedValuePlan(new ValueGenerationPlan(subgenerator, this.injector(property, attributeDeclarer)));
        }
        return generator;
    }

    private Setter injector(Property property, Class<?> attributeDeclarer) {
        return property.getPropertyAccessStrategy(attributeDeclarer).buildPropertyAccess(attributeDeclarer, property.getName(), true).getSetter();
    }

    private Class<?> resolveComponentClass() {
        try {
            return this.getComponentClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Internal
    public String[] getPropertyNames() {
        String[] propertyNames = new String[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            propertyNames[i] = this.properties.get(i).getName();
        }
        return propertyNames;
    }

    public void prepareForMappingModel() {
        this.getType();
    }

    @Override
    public boolean isValid(Mapping mapping) throws MappingException {
        if (!super.isValid(mapping)) {
            return false;
        }
        if (this.instantiatorPropertyNames != null) {
            if (this.instantiatorPropertyNames.length < this.properties.size()) {
                throw new MappingException("component type [" + this.componentClassName + "] specifies " + this.instantiatorPropertyNames.length + " properties for the instantiator but has " + this.properties.size() + " properties");
            }
            HashSet assignedPropertyNames = CollectionHelper.setOfSize(this.properties.size());
            for (String instantiatorPropertyName : this.instantiatorPropertyNames) {
                if (this.getProperty(instantiatorPropertyName) == null) {
                    throw new MappingException("could not find property [" + instantiatorPropertyName + "] defined in the @Instantiator withing component [" + this.componentClassName + "]");
                }
                assignedPropertyNames.add(instantiatorPropertyName);
            }
            if (assignedPropertyNames.size() != this.properties.size()) {
                ArrayList<String> missingProperties = new ArrayList<String>();
                for (Property property : this.properties) {
                    if (assignedPropertyNames.contains(property.getName())) continue;
                    missingProperties.add(property.getName());
                }
                throw new MappingException("component type [" + this.componentClassName + "] has " + this.properties.size() + " properties but the instantiator only assigns " + assignedPropertyNames.size() + " properties. missing properties: " + missingProperties);
            }
        }
        return true;
    }

    @Override
    public boolean isSorted() {
        return this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] sortProperties() {
        return this.sortProperties(false);
    }

    private int[] sortProperties(boolean forceRetainOriginalOrder) {
        PrimaryKey primaryKey;
        int[] originalPropertyOrder;
        if (this.originalPropertyOrder != ArrayHelper.EMPTY_INT_ARRAY) {
            return this.originalPropertyOrder;
        }
        if (this.isSimpleRecord()) {
            this.originalPropertyOrder = null;
            return null;
        }
        if (forceRetainOriginalOrder || this.isAlternateUniqueKey() || this.isEmbedded() || this.getBuildingContext() instanceof MappingDocument) {
            Property[] originalProperties = this.properties.toArray(new Property[0]);
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = new int[originalProperties.length];
            for (int j = 0; j < originalPropertyOrder.length; ++j) {
                originalPropertyOrder[j] = this.properties.indexOf(originalProperties[j]);
            }
        } else {
            this.properties.sort(Comparator.comparing(Property::getName));
            originalPropertyOrder = null;
        }
        if (this.isKey && (primaryKey = this.getOwner().getTable().getPrimaryKey()) != null) {
            List<Column> columns = primaryKey.getColumns();
            columns.clear();
            for (Property property : this.properties) {
                for (Selectable selectable : property.getSelectables()) {
                    if (!(selectable instanceof Column)) continue;
                    columns.add((Column)selectable);
                }
            }
        }
        this.propertiesListModified();
        this.originalPropertyOrder = originalPropertyOrder;
        return originalPropertyOrder;
    }

    private boolean isSimpleRecord() {
        Class<?> componentClass = this.resolveComponentClass();
        if (this.customInstantiator != null) {
            return false;
        }
        if (componentClass == null || !ReflectHelper.isRecord(componentClass)) {
            return false;
        }
        String[] recordComponentNames = ReflectHelper.getRecordComponentNames(componentClass);
        if (recordComponentNames.length != this.properties.size()) {
            return false;
        }
        for (int i = 0; i < recordComponentNames.length; ++i) {
            if (recordComponentNames[i].equals(this.properties.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    public Class<? extends EmbeddableInstantiator> getCustomInstantiator() {
        return this.customInstantiator;
    }

    public void setCustomInstantiator(Class<? extends EmbeddableInstantiator> customInstantiator) {
        this.customInstantiator = customInstantiator;
    }

    public Constructor<?> getInstantiator() {
        return this.instantiator;
    }

    public String[] getInstantiatorPropertyNames() {
        return this.instantiatorPropertyNames;
    }

    public void setInstantiator(Constructor<?> instantiator, String[] instantiatorPropertyNames) {
        this.instantiator = instantiator;
        this.instantiatorPropertyNames = instantiatorPropertyNames;
    }

    public String[] getStructColumnNames() {
        return this.structColumnNames;
    }

    public void setStructColumnNames(String[] structColumnNames) {
        this.structColumnNames = structColumnNames;
    }

    public boolean isGeneric() {
        if (this.isGeneric == null) {
            this.isGeneric = this.getComponentClassName() != null && this.getComponentClass().getTypeParameters().length != 0;
        }
        return this.isGeneric;
    }

    public void setGeneric(boolean generic) {
        this.isGeneric = generic;
    }

    public static class ValueGenerationPlan
    implements CompositeNestedGeneratedValueGenerator.GenerationPlan {
        private final Generator subgenerator;
        private final Setter injector;

        public ValueGenerationPlan(Generator subgenerator, Setter injector) {
            this.subgenerator = subgenerator;
            this.injector = injector;
        }

        @Override
        public void execute(SharedSessionContractImplementor session, Object incomingObject, Object injectionContext) {
            if (this.subgenerator.generatedOnExecution()) {
                throw new IdentifierGenerationException("Identity generation isn't supported for composite ids");
            }
            Object generatedId = ((BeforeExecutionGenerator)this.subgenerator).generate(session, incomingObject, null, EventType.INSERT);
            this.injector.set(injectionContext, generatedId);
        }

        @Override
        public void registerExportables(Database database) {
            if (this.subgenerator instanceof ExportableProducer) {
                ((ExportableProducer)((Object)this.subgenerator)).registerExportables(database);
            }
        }

        @Override
        public void initialize(SqlStringGenerationContext context) {
            if (this.subgenerator instanceof IdentifierGenerator) {
                ((IdentifierGenerator)this.subgenerator).initialize(context);
            }
        }
    }

    public static class StandardGenerationContextLocator
    implements CompositeNestedGeneratedValueGenerator.GenerationContextLocator {
        private final String entityName;

        public StandardGenerationContextLocator(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public Object locateGenerationContext(SharedSessionContractImplementor session, Object incomingObject) {
            return session.getEntityPersister(this.entityName, incomingObject).getIdentifier(incomingObject, session);
        }
    }
}

