/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.Filter;
import org.hibernate.Internal;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoader;
import org.hibernate.loader.ast.spi.NaturalIdLoader;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.AttributeMappingsMap;
import org.hibernate.metamodel.mapping.Discriminable;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.metamodel.mapping.Restrictable;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityNameUse;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public interface EntityMappingType
extends ManagedMappingType,
EntityValuedModelPart,
Loadable,
Restrictable,
Discriminable {
    public String getEntityName();

    default public EntityRepresentationStrategy getRepresentationStrategy() {
        return this.getEntityPersister().getRepresentationStrategy();
    }

    public TableDetails getMappedTableDetails();

    public TableDetails getIdentifierTableDetails();

    @Override
    default public EntityMappingType findContainingEntityMapping() {
        return this;
    }

    @Override
    default public JavaType<?> getJavaType() {
        return this.getMappedJavaType();
    }

    @Override
    default public EntityMappingType asEntityMappingType() {
        return this;
    }

    @Override
    default public MappingType getPartMappingType() {
        return this;
    }

    public void visitQuerySpaces(Consumer<String> var1);

    @Override
    default public ModelPart findSubPart(String name) {
        return this.findSubPart(name, null);
    }

    default public ModelPart findSubTypesSubPart(String name, EntityMappingType treatTargetType) {
        return this.findSubPart(name, treatTargetType);
    }

    @Override
    default public int getJdbcTypeCount() {
        return this.forEachJdbcType((index, jdbcMapping) -> {});
    }

    default public boolean isAbstract() {
        return this.getEntityPersister().getEntityMetamodel().isAbstract();
    }

    default public boolean hasSubclasses() {
        return this.getEntityPersister().getEntityMetamodel().hasSubclasses();
    }

    default public EntityMappingType getSuperMappingType() {
        return null;
    }

    default public String getMappedSuperclass() {
        return this.getSuperMappingType().getEntityName();
    }

    default public Collection<EntityMappingType> getSubMappingTypes() {
        MappingMetamodelImplementor mappingMetamodel = this.getEntityPersister().getFactory().getMappingMetamodel();
        Set<String> subclassEntityNames = this.getSubclassEntityNames();
        ArrayList<EntityMappingType> mappingTypes = new ArrayList<EntityMappingType>(subclassEntityNames.size());
        for (String subclassEntityName : subclassEntityNames) {
            mappingTypes.add(mappingMetamodel.getEntityDescriptor(subclassEntityName));
        }
        return mappingTypes;
    }

    default public boolean isTypeOrSuperType(EntityMappingType targetType) {
        return targetType == this;
    }

    default public boolean isTypeOrSuperType(ManagedMappingType targetType) {
        if (targetType instanceof EntityMappingType) {
            return this.isTypeOrSuperType((EntityMappingType)targetType);
        }
        return false;
    }

    default public int getSubclassId() {
        return this.getEntityPersister().getEntityMetamodel().getSubclassId();
    }

    default public Set<String> getSubclassEntityNames() {
        return this.getEntityPersister().getEntityMetamodel().getSubclassEntityNames();
    }

    public boolean isExplicitPolymorphism();

    public Object getDiscriminatorValue();

    default public String getDiscriminatorSQLValue() {
        return this.getDiscriminatorValue().toString();
    }

    default public EntityMappingType getRootEntityDescriptor() {
        EntityMappingType superMappingType = this.getSuperMappingType();
        if (superMappingType == null) {
            return this;
        }
        return superMappingType.getRootEntityDescriptor();
    }

    default public void pruneForSubclasses(TableGroup tableGroup, Map<String, EntityNameUse> entityNameUses) {
    }

    @Deprecated(forRemoval=true)
    default public void pruneForSubclasses(TableGroup tableGroup, Set<String> treatedEntityNames) {
    }

    public EntityIdentifierMapping getIdentifierMapping();

    @Override
    public EntityDiscriminatorMapping getDiscriminatorMapping();

    public EntityVersionMapping getVersionMapping();

    default public OptimisticLockStyle optimisticLockStyle() {
        return OptimisticLockStyle.NONE;
    }

    public NaturalIdMapping getNaturalIdMapping();

    public EntityRowIdMapping getRowIdMapping();

    @Override
    default public int getNumberOfAttributeMappings() {
        return this.getEntityPersister().getNumberOfAttributeMappings();
    }

    @Override
    default public AttributeMappingsList getAttributeMappings() {
        return this.getEntityPersister().getAttributeMappings();
    }

    @Override
    default public void forEachAttributeMapping(Consumer<? super AttributeMapping> action) {
        this.getAttributeMappings().forEach(action);
    }

    @Override
    default public AttributeMapping getAttributeMapping(int position) {
        return this.getEntityPersister().getAttributeMapping(position);
    }

    public AttributeMapping findDeclaredAttributeMapping(String var1);

    default public int getNumberOfDeclaredAttributeMappings() {
        return this.getDeclaredAttributeMappings().size();
    }

    public AttributeMappingsMap getDeclaredAttributeMappings();

    public void visitDeclaredAttributeMappings(Consumer<? super AttributeMapping> var1);

    default public void visitAttributeMappings(Consumer<? super AttributeMapping> action, EntityMappingType targetType) {
        this.getAttributeMappings().forEach(action);
    }

    default public void visitSubTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
    }

    default public void visitSuperTypeAttributeMappings(Consumer<? super AttributeMapping> action) {
    }

    public void visitConstraintOrderedTables(ConstraintOrderedTableConsumer var1);

    @Deprecated(forRemoval=true)
    default public Object[] extractConcreteTypeStateValues(Map<AttributeMapping, DomainResultAssembler> assemblerMapping, RowProcessingState rowProcessingState) {
        Object[] values = new Object[this.getNumberOfAttributeMappings()];
        this.forEachAttributeMapping((? super AttributeMapping attribute) -> {
            DomainResultAssembler assembler = (DomainResultAssembler)assemblerMapping.get(attribute);
            Serializable value = assembler == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : assembler.assemble(rowProcessingState);
            values[attribute.getStateArrayPosition()] = value;
        });
        return values;
    }

    public NaturalIdLoader<?> getNaturalIdLoader();

    public MultiNaturalIdLoader<?> getMultiNaturalIdLoader();

    public Object loadByUniqueKey(String var1, Object var2, SharedSessionContractImplementor var3);

    @Override
    default public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFilters(influencers);
    }

    @Override
    default public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEntityGraph(influencers);
    }

    @Override
    default public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getEntityPersister().isAffectedByEnabledFetchProfiles(influencers);
    }

    default public SqmMultiTableMutationStrategy getSqmMultiTableMutationStrategy() {
        return this.getEntityPersister().getSqmMultiTableMutationStrategy();
    }

    default public SqmMultiTableInsertStrategy getSqmMultiTableInsertStrategy() {
        return this.getEntityPersister().getSqmMultiTableInsertStrategy();
    }

    @Override
    default public String getSqlAliasStem() {
        return this.getEntityPersister().getSqlAliasStem();
    }

    @Override
    default public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState) {
        return this.getEntityPersister().createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, explicitSqlAliasBase, additionalPredicateCollectorAccess, creationState);
    }

    default public TableReference createPrimaryTableReference(SqlAliasBase sqlAliasBase, SqlAstCreationState creationState) {
        throw new UnsupportedMappingException("Entity mapping does not support primary TableReference creation [" + this.getClass().getName() + " : " + this.getEntityName() + "]");
    }

    default public TableReferenceJoin createTableReferenceJoin(String joinTableExpression, SqlAliasBase sqlAliasBase, TableReference lhs, SqlAstCreationState creationState) {
        throw new UnsupportedMappingException("Entity mapping does not support primary TableReference join creation [" + this.getClass().getName() + " : " + this.getEntityName() + "]");
    }

    @Override
    default public JavaType<?> getMappedJavaType() {
        return this.getEntityPersister().getMappedJavaType();
    }

    @Override
    default public int getNumberOfFetchables() {
        return this.getEntityPersister().getNumberOfFetchables();
    }

    @Override
    default public Fetchable getFetchable(int position) {
        return this.getEntityPersister().getFetchable(position);
    }

    @Override
    default public void applyDiscriminator(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        this.getEntityPersister().applyDiscriminator(predicateConsumer, alias, tableGroup, creationState);
    }

    @Override
    default public void applyFilterRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, SqlAstCreationState creationState) {
        this.getEntityPersister().applyFilterRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, creationState);
    }

    @Override
    default public void applyBaseRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, Map<String, Filter> enabledFilters, Set<String> treatAsDeclarations, SqlAstCreationState creationState) {
        this.getEntityPersister().applyBaseRestrictions(predicateConsumer, tableGroup, useQualifier, enabledFilters, treatAsDeclarations, creationState);
    }

    @Override
    default public boolean hasWhereRestrictions() {
        return this.getEntityPersister().hasWhereRestrictions();
    }

    @Override
    default public void applyWhereRestrictions(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, boolean useQualifier, SqlAstCreationState creationState) {
        this.getEntityPersister().applyWhereRestrictions(predicateConsumer, tableGroup, useQualifier, creationState);
    }

    @Internal
    public EntityPersister getEntityPersister();

    @Deprecated
    default public String getContributor() {
        return "orm";
    }

    @Override
    default public String getPartName() {
        return this.getEntityName();
    }

    @Override
    default public String getRootPathName() {
        return this.getEntityName();
    }

    public static interface ConstraintOrderedTableConsumer {
        public void consume(String var1, Supplier<Consumer<SelectableConsumer>> var2);
    }
}

