/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.io.Serializable;
import org.hibernate.Incubating;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public interface DdlType
extends Serializable {
    public int getSqlTypeCode();

    default public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        return this.getTypeName(columnSize);
    }

    @Deprecated(since="6.3")
    public String getRawTypeName();

    @Incubating
    @Deprecated(since="6.3")
    default public String[] getRawTypeNames() {
        return new String[]{this.getRawTypeName()};
    }

    @Deprecated(since="6.3")
    default public String getTypeName(Size size) {
        return this.getTypeName(size.getLength(), size.getPrecision(), size.getScale());
    }

    @Deprecated(since="6.3")
    public String getTypeName(Long var1, Integer var2, Integer var3);

    default public boolean isLob(Size size) {
        return JdbcType.isLobOrLong(this.getSqlTypeCode());
    }

    public String getCastTypeName(JdbcType var1, JavaType<?> var2);

    default public String getCastTypeName(SqlExpressible type, Long length, Integer precision, Integer scale) {
        return this.getCastTypeName(type.getJdbcMapping().getJdbcType(), type.getJdbcMapping().getJavaTypeDescriptor(), length, precision, scale);
    }

    public String getCastTypeName(JdbcType var1, JavaType<?> var2, Long var3, Integer var4, Integer var5);
}

