/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.function.array.ArrayViaElementArgumentReturnTypeResolver;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class ArrayAggFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public static final String FUNCTION_NAME = "array_agg";
    private final String functionName;
    private final boolean withinGroupClause;
    private final boolean supportsFilter;

    public ArrayAggFunction(String functionName, boolean withinGroupClause, boolean supportsFilter) {
        super(FUNCTION_NAME, FunctionKind.ORDERED_SET_AGGREGATE, StandardArgumentsValidators.exactly(1), ArrayViaElementArgumentReturnTypeResolver.INSTANCE, StandardFunctionArgumentTypeResolvers.NULL);
        this.functionName = functionName;
        this.withinGroupClause = withinGroupClause;
        this.supportsFilter = supportsFilter;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, SqlAstTranslator<?> translator) {
        Expression arg;
        boolean caseWrapper = filter != null && (!this.supportsFilter || !translator.supportsFilterClause());
        sqlAppender.appendSql(this.functionName);
        sqlAppender.appendSql('(');
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            sqlAppender.appendSql("distinct ");
            arg = ((Distinct)firstArg).getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        if (caseWrapper) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql("case when ");
            filter.accept(translator);
            sqlAppender.appendSql(" then ");
            arg.accept(translator);
            sqlAppender.appendSql(" else null end");
            translator.getCurrentClauseStack().pop();
        } else {
            arg.accept(translator);
        }
        if (withinGroup != null && !withinGroup.isEmpty()) {
            if (this.withinGroupClause) {
                sqlAppender.appendSql(')');
                sqlAppender.appendSql(" within group (");
            }
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            translator.getCurrentClauseStack().pop();
        }
        sqlAppender.appendSql(')');
        if (!caseWrapper && filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }
}

