/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.FunctionArgumentTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.type.BasicPluralType;

public class ArrayAndElementArgumentTypeResolver
implements FunctionArgumentTypeResolver {
    public static final FunctionArgumentTypeResolver DEFAULT_INSTANCE = new ArrayAndElementArgumentTypeResolver(0, 1);
    private final int arrayIndex;
    private final int[] elementIndexes;

    public ArrayAndElementArgumentTypeResolver(int arrayIndex, int ... elementIndexes) {
        this.arrayIndex = arrayIndex;
        this.elementIndexes = elementIndexes;
    }

    @Override
    public MappingModelExpressible<?> resolveFunctionArgumentType(SqmFunction<?> function, int argumentIndex, SqmToSqlAstConverter converter) {
        SqmTypedNode<?> argument;
        SqmExpressible<?> sqmType;
        if (argumentIndex == this.arrayIndex) {
            for (int elementIndex : this.elementIndexes) {
                SqmTypedNode<?> argument2 = function.getArguments().get(elementIndex);
                DomainType<?> sqmType2 = argument2.getExpressible().getSqmType();
                if (!(sqmType2 instanceof ReturnableType)) continue;
                return DdlTypeHelper.resolveArrayType(sqmType2, converter.getCreationContext().getSessionFactory().getTypeConfiguration());
            }
        } else if (ArrayHelper.contains(this.elementIndexes, argumentIndex) && (sqmType = (argument = function.getArguments().get(this.arrayIndex)).getNodeType()) instanceof BasicPluralType) {
            return ((BasicPluralType)sqmType).getElementType();
        }
        return null;
    }
}

