/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator DEFAULT_INSTANCE = new ArrayArgumentValidator(0);
    private final int arrayIndex;

    public ArrayArgumentValidator(int arrayIndex) {
        this.arrayIndex = arrayIndex;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        this.getElementType(arguments, functionName, typeConfiguration);
    }

    protected BasicType<?> getElementType(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        return this.getElementType(this.arrayIndex, arguments, functionName, typeConfiguration);
    }

    protected BasicType<?> getElementType(int arrayIndex, List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        SqmTypedNode<?> arrayArgument = arguments.get(arrayIndex);
        DomainType<?> arrayType = arrayArgument.getExpressible().getSqmType();
        if (arrayType == null) {
            return null;
        }
        if (!(arrayType instanceof BasicPluralType)) {
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type, but argument is of type '%s'", arrayIndex, functionName, arrayType.getTypeName()));
        }
        return ((BasicPluralType)arrayType).getElementType();
    }
}

