/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentTypeResolver;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentValidator;
import org.hibernate.dialect.function.array.ArrayViaArgumentReturnTypeResolver;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;

public class ArrayConcatElementFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final String prefix;
    private final String separator;
    private final String suffix;
    protected final boolean prepend;

    public ArrayConcatElementFunction(String prefix, String separator, String suffix, boolean prepend) {
        super("array_" + (prepend ? "prepend" : "append"), StandardArgumentsValidators.composite(StandardArgumentsValidators.exactly(2), prepend ? new ArrayAndElementArgumentValidator(1, 0) : ArrayAndElementArgumentValidator.DEFAULT_INSTANCE), prepend ? new ArrayViaArgumentReturnTypeResolver(1) : ArrayViaArgumentReturnTypeResolver.DEFAULT_INSTANCE, prepend ? new ArrayAndElementArgumentTypeResolver(1, 0) : ArrayAndElementArgumentTypeResolver.DEFAULT_INSTANCE);
        this.prefix = prefix;
        this.separator = separator;
        this.suffix = suffix;
        this.prepend = prepend;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        SqlAstNode firstArgument = sqlAstArguments.get(0);
        SqlAstNode secondArgument = sqlAstArguments.get(1);
        sqlAppender.append(this.prefix);
        if (this.prepend) {
            sqlAppender.append("array[");
            firstArgument.accept(walker);
            sqlAppender.append(']');
        } else {
            firstArgument.accept(walker);
        }
        sqlAppender.append(this.separator);
        if (this.prepend) {
            secondArgument.accept(walker);
        } else {
            sqlAppender.append("array[");
            secondArgument.accept(walker);
            sqlAppender.append(']');
        }
        sqlAppender.append(this.suffix);
    }
}

