/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentTypeResolver;
import org.hibernate.dialect.function.array.ArrayAndElementArgumentValidator;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class ArrayContainsOperatorFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public ArrayContainsOperatorFunction(TypeConfiguration typeConfiguration) {
        super("array_contains", StandardArgumentsValidators.composite(StandardArgumentsValidators.exactly(2), ArrayAndElementArgumentValidator.DEFAULT_INSTANCE), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.standardBasicTypeForJavaType(Boolean.class)), ArrayAndElementArgumentTypeResolver.DEFAULT_INSTANCE);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression elementExpression = (Expression)sqlAstArguments.get(1);
        arrayExpression.accept(walker);
        sqlAppender.append("@>");
        if (ArrayContainsOperatorFunction.needsArrayCasting(elementExpression)) {
            sqlAppender.append("cast(array[");
            elementExpression.accept(walker);
            sqlAppender.append("] as ");
            sqlAppender.append(DdlTypeHelper.getCastTypeName(arrayExpression.getExpressionType(), walker));
            sqlAppender.append(')');
        } else {
            sqlAppender.append("array[");
            elementExpression.accept(walker);
            sqlAppender.append(']');
        }
    }

    private static boolean needsArrayCasting(Expression elementExpression) {
        return elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString();
    }

    @Override
    public String getArgumentListSignature() {
        return "(ARRAY array, OBJECT element)";
    }
}

