/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.dialect.function.array.ArrayViaArgumentReturnTypeResolver;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class ArraySliceUnnestFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final boolean castEmptyArrayLiteral;

    public ArraySliceUnnestFunction(boolean castEmptyArrayLiteral) {
        super("array_slice", StandardArgumentsValidators.composite(new ArgumentTypesValidator(null, FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER), ArrayArgumentValidator.DEFAULT_INSTANCE), ArrayViaArgumentReturnTypeResolver.DEFAULT_INSTANCE, StandardFunctionArgumentTypeResolvers.composite(StandardFunctionArgumentTypeResolvers.invariant(FunctionParameterType.ANY, FunctionParameterType.INTEGER, FunctionParameterType.INTEGER), StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE));
        this.castEmptyArrayLiteral = castEmptyArrayLiteral;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression startIndexExpression = (Expression)sqlAstArguments.get(1);
        Expression endIndexExpression = (Expression)sqlAstArguments.get(2);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is null or ");
        startIndexExpression.accept(walker);
        sqlAppender.append(" is null or ");
        endIndexExpression.accept(walker);
        sqlAppender.append(" is null then null else coalesce((select array_agg(t.val) from unnest(");
        arrayExpression.accept(walker);
        sqlAppender.append(") with ordinality t(val,idx) where t.idx between ");
        startIndexExpression.accept(walker);
        sqlAppender.append(" and ");
        endIndexExpression.accept(walker);
        sqlAppender.append("),");
        if (this.castEmptyArrayLiteral) {
            sqlAppender.append("cast(array[] as ");
            sqlAppender.append(DdlTypeHelper.getCastTypeName(arrayExpression.getExpressionType(), walker));
            sqlAppender.append(')');
        } else {
            sqlAppender.append("array[]");
        }
        sqlAppender.append(") end");
    }
}

