/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArraysOfSameTypeArgumentValidator
implements ArgumentsValidator {
    public static final ArgumentsValidator INSTANCE = new ArraysOfSameTypeArgumentValidator();

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        Object arrayType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            DomainType<?> sqmType;
            SqmExpressible<?> expressible = arguments.get(i).getExpressible();
            if (expressible == null || (sqmType = expressible.getSqmType()) == null) continue;
            if (arrayType == null) {
                if (!(sqmType instanceof BasicPluralType)) {
                    throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type, but argument is of type '%s'", i, functionName, sqmType.getTypeName()));
                }
                arrayType = (BasicPluralType)sqmType;
                continue;
            }
            if (arrayType.equals(sqmType)) continue;
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' requires an array type %s, but argument is of type '%s'", i, functionName, arrayType.getTypeName(), sqmType.getTypeName()));
        }
    }

    @Override
    public String getSignature() {
        return "(ARRAY array0, ARRAY array1[, ARRAY array2, ...])";
    }
}

