/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConstructorFunction;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class CastingArrayConstructorFunction
extends ArrayConstructorFunction {
    public CastingArrayConstructorFunction() {
        super(true);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new ArrayConstructorSqmFunction<T>(this, (FunctionRenderingSupport)this, arguments, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    protected static class ArrayConstructorSqmFunction<T>
    extends SelfRenderingSqmFunction<T> {
        public ArrayConstructorSqmFunction(CastingArrayConstructorFunction descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
            super(descriptor, renderingSupport, arguments, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        }

        @Override
        public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
            final ReturnableType<?> resultType = this.resolveResultType(walker);
            List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
            if (this.getArgumentsValidator() != null) {
                this.getArgumentsValidator().validateSqlTypes(arguments, this.getFunctionName());
            }
            return new SelfRenderingFunctionSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, resultType, resultType == null ? null : this.getMappingModelExpressible(walker, resultType, arguments)){

                @Override
                public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                    DomainType type;
                    String arrayTypeName = null;
                    if (resultType != null && (type = resultType.getSqmType()) instanceof BasicPluralType) {
                        BasicPluralType pluralType = (BasicPluralType)type;
                        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
                        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
                        DdlType ddlType = ddlTypeRegistry.getDescriptor(pluralType.getJdbcType().getDdlTypeCode());
                        arrayTypeName = ddlType.getCastTypeName(Size.nil(), pluralType, ddlTypeRegistry);
                        sqlAppender.append("cast(");
                    }
                    super.renderToSql(sqlAppender, walker, sessionFactory);
                    if (arrayTypeName != null) {
                        sqlAppender.appendSql(" as ");
                        sqlAppender.appendSql(arrayTypeName);
                        sqlAppender.appendSql(')');
                    }
                }
            };
        }
    }
}

