/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.lang.reflect.Array;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class DdlTypeHelper {
    public static BasicType<?> resolveArrayType(DomainType<?> elementType, TypeConfiguration typeConfiguration) {
        BasicPluralJavaType arrayJavaType = (BasicPluralJavaType)((Object)typeConfiguration.getJavaTypeRegistry().getDescriptor(Array.newInstance(elementType.getBindableJavaType(), 0).getClass()));
        Dialect dialect = typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        return arrayJavaType.resolveType(typeConfiguration, dialect, (BasicType)elementType, null, typeConfiguration.getCurrentBaseSqlTypeIndicators());
    }

    public static String getTypeName(JdbcMappingContainer type, SqlAstTranslator<?> walker) {
        if (type instanceof SqlTypedMapping) {
            return AbstractSqlAstTranslator.getSqlTypeName((SqlTypedMapping)((Object)type), walker.getSessionFactory());
        }
        BasicType jdbcMapping = (BasicType)type.getSingleJdbcMapping();
        TypeConfiguration typeConfiguration = walker.getSessionFactory().getTypeConfiguration();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(jdbcMapping.getJdbcType().getDdlTypeCode());
        return ddlType.getTypeName(Size.nil(), jdbcMapping, ddlTypeRegistry);
    }

    public static String getCastTypeName(JdbcMappingContainer type, SqlAstTranslator<?> walker) {
        if (type instanceof SqlTypedMapping) {
            return AbstractSqlAstTranslator.getCastTypeName((SqlTypedMapping)((Object)type), walker.getSessionFactory());
        }
        BasicType jdbcMapping = (BasicType)type.getSingleJdbcMapping();
        TypeConfiguration typeConfiguration = walker.getSessionFactory().getTypeConfiguration();
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor(jdbcMapping.getJdbcType().getDdlTypeCode());
        return ddlType.getCastTypeName(Size.nil(), jdbcMapping, ddlTypeRegistry);
    }
}

