/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayContainsQuantifiedFunction;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class H2ArrayContainsQuantifiedEmulation
extends AbstractArrayContainsQuantifiedFunction {
    private final boolean all;
    private final boolean nullable;

    public H2ArrayContainsQuantifiedEmulation(TypeConfiguration typeConfiguration, boolean all, boolean nullable) {
        super("array_contains_" + (all ? "all" : "any"), typeConfiguration);
        this.all = all;
        this.nullable = nullable;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        Expression needleExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append('(');
        haystackExpression.accept(walker);
        sqlAppender.append(" is not null and ");
        needleExpression.accept(walker);
        sqlAppender.append(" is not null and ");
        if (!this.nullable) {
            sqlAppender.append("not array_contains(");
            needleExpression.accept(walker);
            sqlAppender.append(",null) and ");
        }
        if (this.all) {
            sqlAppender.append("not ");
        }
        sqlAppender.append("exists(select array_get(");
        needleExpression.accept(walker);
        sqlAppender.append(",t.i) from system_range(1,");
        sqlAppender.append(Integer.toString(this.getMaximumArraySize()));
        sqlAppender.append(") t(i) where array_length(");
        needleExpression.accept(walker);
        sqlAppender.append(")>=t.i");
        if (this.all) {
            sqlAppender.append(" except ");
        } else {
            sqlAppender.append(" intersect ");
        }
        sqlAppender.append("select array_get(");
        haystackExpression.accept(walker);
        sqlAppender.append(",t.i) from system_range(1,");
        sqlAppender.append(Integer.toString(this.getMaximumArraySize()));
        sqlAppender.append(") t(i) where array_length(");
        haystackExpression.accept(walker);
        sqlAppender.append(")>=t.i))");
    }

    protected int getMaximumArraySize() {
        return 1000;
    }
}

