/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.AbstractArrayRemoveFunction;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class H2ArrayRemoveFunction
extends AbstractArrayRemoveFunction {
    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression elementExpression = (Expression)sqlAstArguments.get(1);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is null then null else coalesce((select array_agg(array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx)) from system_range(1,");
        sqlAppender.append(Integer.toString(this.getMaximumArraySize()));
        sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append("),0) and array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx) is distinct from ");
        elementExpression.accept(walker);
        sqlAppender.append("),array[]) end");
    }

    protected int getMaximumArraySize() {
        return 1000;
    }
}

