/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayReplaceUnnestFunction;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class H2ArrayReplaceFunction
extends ArrayReplaceUnnestFunction {
    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression oldExpression = (Expression)sqlAstArguments.get(1);
        Expression newExpression = (Expression)sqlAstArguments.get(2);
        sqlAppender.append("case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is null then null else coalesce((select array_agg(case when array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx) is not distinct from ");
        oldExpression.accept(walker);
        sqlAppender.append(" then ");
        newExpression.accept(walker);
        sqlAppender.append(" else array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx) end) from system_range(1,");
        sqlAppender.append(Integer.toString(this.getMaximumArraySize()));
        sqlAppender.append(") i(idx) where i.idx<=coalesce(cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append("),0)),array[]) end");
    }

    protected int getMaximumArraySize() {
        return 1000;
    }
}

