/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArraySetUnnestFunction;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class H2ArraySetFunction
extends ArraySetUnnestFunction {
    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        Expression indexExpression = (Expression)sqlAstArguments.get(1);
        Expression elementExpression = (Expression)sqlAstArguments.get(2);
        sqlAppender.append("(select array_agg(case when i.idx=");
        indexExpression.accept(walker);
        sqlAppender.append(" then ");
        elementExpression.accept(walker);
        sqlAppender.append(" when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null and i.idx<=cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append(") then array_get(");
        arrayExpression.accept(walker);
        sqlAppender.append(",i.idx) end) from system_range(1,");
        sqlAppender.append(Integer.toString(this.getMaximumArraySize()));
        sqlAppender.append(") i(idx) where i.idx<=greatest(case when ");
        arrayExpression.accept(walker);
        sqlAppender.append(" is not null then cardinality(");
        arrayExpression.accept(walker);
        sqlAppender.append(") else 0 end,");
        indexExpression.accept(walker);
        sqlAppender.append("))");
    }

    protected int getMaximumArraySize() {
        return 1000;
    }
}

