/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.function.array.JsonArrayViaElementArgumentReturnTypeResolver;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.function.FunctionRenderingSupport;
import org.hibernate.query.sqm.function.SelfRenderingOrderedSetAggregateFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SelfRenderingSqmOrderedSetAggregateFunction;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.SelfRenderingCteObject;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryTransformer;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayAggEmulation
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public static final String FUNCTION_NAME = "array_agg";

    public OracleArrayAggEmulation() {
        super(FUNCTION_NAME, FunctionKind.ORDERED_SET_AGGREGATE, StandardArgumentsValidators.exactly(1), JsonArrayViaElementArgumentReturnTypeResolver.INSTANCE, StandardFunctionArgumentTypeResolvers.NULL);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, null, Collections.emptyList(), walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, SqlAstTranslator<?> walker) {
        this.render(sqlAppender, sqlAstArguments, filter, Collections.emptyList(), walker);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, SqlAstTranslator<?> translator) {
        Expression arg;
        sqlAppender.appendSql("json_arrayagg");
        sqlAppender.appendSql('(');
        SqlAstNode firstArg = sqlAstArguments.get(0);
        if (firstArg instanceof Distinct) {
            sqlAppender.appendSql("distinct ");
            arg = ((Distinct)firstArg).getExpression();
        } else {
            arg = (Expression)firstArg;
        }
        arg.accept(translator);
        if (withinGroup != null && !withinGroup.isEmpty()) {
            translator.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
            sqlAppender.appendSql(" order by ");
            withinGroup.get(0).accept(translator);
            for (int i = 1; i < withinGroup.size(); ++i) {
                sqlAppender.appendSql(',');
                withinGroup.get(i).accept(translator);
            }
            translator.getCurrentClauseStack().pop();
        }
        sqlAppender.appendSql(" null on null returning ");
        sqlAppender.appendSql(translator.getSessionFactory().getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, translator.getSessionFactory().getJdbcServices().getDialect()));
        sqlAppender.appendSql(')');
        if (filter != null) {
            translator.getCurrentClauseStack().push(Clause.WHERE);
            sqlAppender.appendSql(" filter (where ");
            filter.accept(translator);
            sqlAppender.appendSql(')');
            translator.getCurrentClauseStack().pop();
        }
    }

    @Override
    public <T> SelfRenderingSqmOrderedSetAggregateFunction<T> generateSqmOrderedSetAggregateFunctionExpression(List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        return new OracleArrayAggSqmFunction<T>(this, (FunctionRenderingSupport)this, arguments, filter, withinGroupClause, impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    protected static class OracleArrayAggSqmFunction<T>
    extends SelfRenderingSqmOrderedSetAggregateFunction<T> {
        public OracleArrayAggSqmFunction(OracleArrayAggEmulation descriptor, FunctionRenderingSupport renderingSupport, List<? extends SqmTypedNode<?>> arguments, SqmPredicate filter, SqmOrderByClause withinGroupClause, ReturnableType<T> impliedResultType, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, NodeBuilder nodeBuilder, String name) {
            super(descriptor, renderingSupport, arguments, filter, withinGroupClause, impliedResultType, argumentsValidator, returnTypeResolver, nodeBuilder, name);
        }

        @Override
        protected ReturnableType<?> resolveResultType(TypeConfiguration typeConfiguration) {
            return this.getReturnTypeResolver().resolveFunctionReturnType(this.getImpliedResultType(), () -> null, this.getArguments(), this.nodeBuilder().getTypeConfiguration());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Expression convertToSqlAst(SqmToSqlAstConverter walker) {
            List<SortSpecification> withinGroup;
            ReturnableType<?> resultType = this.resolveResultType(walker);
            if (resultType == null) {
                throw new SemanticException("Oracle array_agg emulation requires knowledge about the return type, but resolved return type could not be determined");
            }
            DomainType type = resultType.getSqmType();
            if (!(type instanceof BasicPluralType)) {
                throw new SemanticException("Oracle array_agg emulation requires a basic plural return type, but resolved return type was: " + type);
            }
            BasicPluralType pluralType = (BasicPluralType)type;
            if (pluralType.getJdbcType().getDefaultSqlTypeCode() == 3001) {
                return super.convertToSqlAst(walker);
            }
            TypeConfiguration typeConfiguration = walker.getCreationContext().getSessionFactory().getTypeConfiguration();
            DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
            DdlType ddlType = ddlTypeRegistry.getDescriptor(pluralType.getJdbcType().getDdlTypeCode());
            String arrayTypeName = ddlType.getCastTypeName(Size.nil(), pluralType, ddlTypeRegistry);
            List<SqlAstNode> arguments = this.resolveSqlAstArguments(this.getArguments(), walker);
            if (this.getArgumentsValidator() != null) {
                this.getArgumentsValidator().validateSqlTypes(arguments, this.getFunctionName());
            }
            if (this.getWithinGroup() == null) {
                withinGroup = Collections.emptyList();
            } else {
                walker.getCurrentClauseStack().push(Clause.WITHIN_GROUP);
                try {
                    List<SqmSortSpecification> sortSpecifications = this.getWithinGroup().getSortSpecifications();
                    withinGroup = new ArrayList(sortSpecifications.size());
                    for (SqmSortSpecification sortSpecification : sortSpecifications) {
                        SortSpecification specification = (SortSpecification)walker.visitSortSpecification(sortSpecification);
                        if (specification == null) continue;
                        withinGroup.add(specification);
                    }
                }
                finally {
                    walker.getCurrentClauseStack().pop();
                }
            }
            OracleArrayAggEmulationSqlAstExpression expression = new OracleArrayAggEmulationSqlAstExpression(this.getFunctionName(), this.getRenderingSupport(), arguments, this.getFilter() == null ? null : walker.visitNestedTopLevelPredicate(this.getFilter()), withinGroup, resultType, this.getMappingModelExpressible(walker, resultType, arguments), arrayTypeName);
            walker.registerQueryTransformer(expression);
            return expression;
        }

        private static class OracleArrayAggEmulationSqlAstExpression
        extends SelfRenderingOrderedSetAggregateFunctionSqlAstExpression
        implements QueryTransformer {
            private final String arrayTypeName;
            private final String functionName;

            public OracleArrayAggEmulationSqlAstExpression(String functionName, FunctionRenderingSupport renderer, List<? extends SqlAstNode> sqlAstArguments, Predicate filter, List<SortSpecification> withinGroup, ReturnableType<?> type, JdbcMappingContainer expressible, String arrayTypeName) {
                super(functionName, renderer, sqlAstArguments, filter, withinGroup, type, expressible);
                this.arrayTypeName = arrayTypeName;
                this.functionName = "json_to_" + arrayTypeName;
            }

            @Override
            public QuerySpec transform(CteContainer cteContainer, QuerySpec querySpec, SqmToSqlAstConverter converter) {
                if (cteContainer.getCteStatement(this.functionName) == null) {
                    cteContainer.addCteObject(new SelfRenderingCteObject(){

                        @Override
                        public String getName() {
                            return functionName;
                        }

                        @Override
                        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                            sqlAppender.appendSql("function ");
                            sqlAppender.appendSql(functionName);
                            sqlAppender.appendSql("(p_json_array in ");
                            sqlAppender.appendSql(sessionFactory.getTypeConfiguration().getDdlTypeRegistry().getTypeName(3001, sessionFactory.getJdbcServices().getDialect()));
                            sqlAppender.appendSql(") return ");
                            sqlAppender.appendSql(arrayTypeName);
                            sqlAppender.appendSql(" is v_result ");
                            sqlAppender.appendSql(arrayTypeName);
                            sqlAppender.appendSql("; begin select t.value bulk collect into v_result ");
                            sqlAppender.appendSql("from json_table(p_json_array,'$[*]' columns (value path '$')) t;");
                            sqlAppender.appendSql("return v_result; end; ");
                        }
                    });
                }
                return querySpec;
            }

            @Override
            public void renderToSql(SqlAppender sqlAppender, SqlAstTranslator<?> walker, SessionFactoryImplementor sessionFactory) {
                sqlAppender.append(this.functionName);
                sqlAppender.append('(');
                super.renderToSql(sqlAppender, walker, sessionFactory);
                sqlAppender.appendSql(')');
            }
        }
    }
}

