/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConcatElementFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class OracleArrayConcatElementFunction
extends ArrayConcatElementFunction {
    public OracleArrayConcatElementFunction(boolean prepend) {
        super("(", ",", ")", prepend);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression firstArgument = (Expression)sqlAstArguments.get(0);
        Expression secondArgument = (Expression)sqlAstArguments.get(1);
        String arrayTypeName = DdlTypeHelper.getTypeName(this.prepend ? secondArgument.getExpressionType() : firstArgument.getExpressionType(), walker);
        sqlAppender.append(arrayTypeName);
        sqlAppender.append("_concat(");
        if (this.prepend) {
            sqlAppender.append(arrayTypeName);
            sqlAppender.append('(');
            firstArgument.accept(walker);
            sqlAppender.append(')');
        } else {
            firstArgument.accept(walker);
        }
        sqlAppender.append(',');
        if (this.prepend) {
            secondArgument.accept(walker);
        } else {
            sqlAppender.append(arrayTypeName);
            sqlAppender.append('(');
            secondArgument.accept(walker);
            sqlAppender.append(')');
        }
        sqlAppender.append(')');
    }
}

