/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayArgumentValidator;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class OracleArrayContainsNullFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public OracleArrayContainsNullFunction(TypeConfiguration typeConfiguration) {
        super("array_contains_null", StandardArgumentsValidators.composite(StandardArgumentsValidators.exactly(1), ArrayArgumentValidator.DEFAULT_INSTANCE), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.standardBasicTypeForJavaType(Boolean.class)), null);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        Expression arrayExpression = (Expression)sqlAstArguments.get(0);
        String arrayTypeName = DdlTypeHelper.getTypeName(arrayExpression.getExpressionType(), walker);
        sqlAppender.appendSql(arrayTypeName);
        sqlAppender.append("_position(");
        arrayExpression.accept(walker);
        sqlAppender.append(",null)>0");
    }

    @Override
    public String getArgumentListSignature() {
        return "(ARRAY array)";
    }
}

