/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConcatElementFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BottomType;

public class PostgreSQLArrayConcatElementFunction
extends ArrayConcatElementFunction {
    public PostgreSQLArrayConcatElementFunction(boolean prepend) {
        super("", "||", "", prepend);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, SqlAstTranslator<?> walker) {
        JdbcMapping elementType;
        Expression arrayArgument;
        Expression elementArgument;
        Expression firstArgument = (Expression)sqlAstArguments.get(0);
        Expression secondArgument = (Expression)sqlAstArguments.get(1);
        if (this.prepend) {
            elementArgument = firstArgument;
            arrayArgument = secondArgument;
        } else {
            arrayArgument = firstArgument;
            elementArgument = secondArgument;
        }
        String elementCastType = PostgreSQLArrayConcatElementFunction.needsElementCasting(elementArgument) ? ((elementType = elementArgument.getExpressionType().getSingleJdbcMapping()) instanceof BottomType ? DdlTypeHelper.getCastTypeName(((BasicPluralType)arrayArgument.getExpressionType().getSingleJdbcMapping()).getElementType(), walker) : DdlTypeHelper.getCastTypeName(elementType, walker)) : null;
        sqlAppender.append("case when ");
        arrayArgument.accept(walker);
        sqlAppender.append(" is not null then ");
        if (this.prepend && elementCastType != null) {
            sqlAppender.append("cast(");
            firstArgument.accept(walker);
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        } else {
            firstArgument.accept(walker);
        }
        sqlAppender.append("||");
        if (!this.prepend && elementCastType != null) {
            sqlAppender.append("cast(");
            secondArgument.accept(walker);
            sqlAppender.append(" as ");
            sqlAppender.append(elementCastType);
            sqlAppender.append(')');
        } else {
            secondArgument.accept(walker);
        }
        sqlAppender.append(" end");
    }

    private static boolean needsElementCasting(Expression elementExpression) {
        return elementExpression instanceof Literal && (elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString() || ((Literal)elementExpression).getLiteralValue() == null);
    }
}

