/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.jfr.CacheGetEvent;
import org.hibernate.event.jfr.internal.JfrEventManager;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;

public final class CacheHelper {
    private CacheHelper() {
    }

    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, EntityPersister persister, CachedDomainDataAccess cacheAccess) {
        return CacheHelper.fromSharedCache(session, cacheKey, persister, false, cacheAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, EntityPersister persister, boolean isNaturalKey, CachedDomainDataAccess cacheAccess) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Object cachedValue = null;
        eventListenerManager.cacheGetStart();
        CacheGetEvent cacheGetEvent = JfrEventManager.beginCacheGetEvent();
        try {
            cachedValue = cacheAccess.get(session, cacheKey);
            JfrEventManager.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, isNaturalKey, cachedValue != null);
        }
        catch (Throwable throwable) {
            JfrEventManager.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, isNaturalKey, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        eventListenerManager.cacheGetEnd(cachedValue != null);
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromSharedCache(SharedSessionContractImplementor session, Object cacheKey, CollectionPersister persister, CachedDomainDataAccess cacheAccess) {
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        Object cachedValue = null;
        eventListenerManager.cacheGetStart();
        CacheGetEvent cacheGetEvent = JfrEventManager.beginCacheGetEvent();
        try {
            cachedValue = cacheAccess.get(session, cacheKey);
            JfrEventManager.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, cachedValue != null);
        }
        catch (Throwable throwable) {
            JfrEventManager.completeCacheGetEvent(cacheGetEvent, session, cacheAccess.getRegion(), persister, cachedValue != null);
            eventListenerManager.cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        eventListenerManager.cacheGetEnd(cachedValue != null);
        return cachedValue;
    }

    public static void addBasicValueToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, JdbcMapping jdbcMapping, SharedSessionContractImplementor session) {
        int hashCode;
        Serializable disassemble;
        if (value == null) {
            cacheKey.addValue(null);
            cacheKey.addHashCode(0);
            return;
        }
        BasicValueConverter converter = jdbcMapping.getValueConverter();
        if (converter == null) {
            disassemble = jdbcMapping.getJavaTypeDescriptor().getMutabilityPlan().disassemble(value, session);
            hashCode = jdbcMapping.getMappedJavaType().extractHashCode(value);
        } else {
            Object relationalValue = converter.toRelationalValue(value);
            JavaType relationalJavaType = converter.getRelationalJavaType();
            disassemble = relationalJavaType.getMutabilityPlan().disassemble(relationalValue, session);
            hashCode = relationalJavaType.extractHashCode(relationalValue);
        }
        cacheKey.addValue(disassemble);
        cacheKey.addHashCode(hashCode);
    }
}

