/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.SessionEventListener;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.jfr.JdbcConnectionAcquisitionEvent;
import org.hibernate.event.jfr.JdbcConnectionReleaseEvent;
import org.hibernate.event.jfr.internal.JfrEventManager;

public class NonContextualJdbcConnectionAccess
implements JdbcConnectionAccess,
Serializable {
    private final SessionEventListener listener;
    private final ConnectionProvider connectionProvider;
    private final SharedSessionContractImplementor session;

    public NonContextualJdbcConnectionAccess(SessionEventListener listener, ConnectionProvider connectionProvider, SharedSessionContractImplementor session) {
        Objects.requireNonNull(listener);
        Objects.requireNonNull(connectionProvider);
        this.listener = listener;
        this.connectionProvider = connectionProvider;
        this.session = session;
    }

    @Override
    public Connection obtainConnection() throws SQLException {
        JdbcConnectionAcquisitionEvent jdbcConnectionAcquisitionEvent = JfrEventManager.beginJdbcConnectionAcquisitionEvent();
        try {
            this.listener.jdbcConnectionAcquisitionStart();
            Connection connection = this.connectionProvider.getConnection();
            return connection;
        }
        finally {
            JfrEventManager.completeJdbcConnectionAcquisitionEvent(jdbcConnectionAcquisitionEvent, this.session, null);
            this.listener.jdbcConnectionAcquisitionEnd();
        }
    }

    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        JdbcConnectionReleaseEvent jdbcConnectionReleaseEvent = JfrEventManager.beginJdbcConnectionReleaseEvent();
        try {
            this.listener.jdbcConnectionReleaseStart();
            this.connectionProvider.closeConnection(connection);
        }
        finally {
            JfrEventManager.completeJdbcConnectionReleaseEvent(jdbcConnectionReleaseEvent, this.session, null);
            this.listener.jdbcConnectionReleaseEnd();
        }
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return this.connectionProvider.supportsAggressiveRelease();
    }
}

