/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMappingsList;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptorSide;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddedForeignKeyDescriptor
implements ForeignKeyDescriptor {
    private final EmbeddedForeignKeyDescriptorSide keySide;
    private final EmbeddedForeignKeyDescriptorSide targetSide;
    private final String keyTable;
    private final SelectableMappings keySelectableMappings;
    private final String targetTable;
    private final SelectableMappings targetSelectableMappings;
    private final AssociationKey associationKey;
    private final boolean hasConstraint;

    public EmbeddedForeignKeyDescriptor(String keyTable, SelectableMappings keySelectableMappings, EmbeddableValuedModelPart keyMappingType, String targetTable, SelectableMappings targetSelectableMappings, EmbeddableValuedModelPart targetMappingType, boolean hasConstraint, MappingModelCreationProcess creationProcess) {
        this(keyMappingType, targetMappingType, keyTable, keySelectableMappings, targetTable, targetSelectableMappings, hasConstraint, creationProcess);
    }

    public EmbeddedForeignKeyDescriptor(EmbeddableValuedModelPart keyMappingType, EmbeddableValuedModelPart targetMappingType, String keyTable, SelectableMappings keySelectableMappings, String targetTable, SelectableMappings targetSelectableMappings, boolean hasConstraint, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = targetTable;
        this.targetSelectableMappings = targetSelectableMappings;
        this.targetSide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetMappingType);
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, keyMappingType);
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = hasConstraint;
        creationProcess.registerInitializationCallback("Embedded (composite) FK descriptor " + targetMappingType.getNavigableRole(), () -> targetMappingType.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings() != 0);
    }

    private EmbeddedForeignKeyDescriptor(EmbeddedForeignKeyDescriptor original, String keyTable, ManagedMappingType keyDeclaringType, TableGroupProducer keyDeclaringTableGroupProducer, SelectableMappings keySelectableMappings, MappingModelCreationProcess creationProcess) {
        this.keyTable = keyTable;
        this.keySelectableMappings = keySelectableMappings;
        this.targetTable = original.targetTable;
        this.targetSelectableMappings = original.targetSelectableMappings;
        this.targetSide = original.targetSide;
        this.keySide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.KEY, MappingModelCreationHelper.createInverseModelPart(original.targetSide.getModelPart(), keyDeclaringType, keyDeclaringTableGroupProducer, keySelectableMappings, creationProcess));
        ArrayList<String> columns = new ArrayList<String>(keySelectableMappings.getJdbcTypeCount());
        keySelectableMappings.forEachSelectable((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
        this.associationKey = new AssociationKey(keyTable, columns);
        this.hasConstraint = original.hasConstraint;
    }

    private EmbeddedForeignKeyDescriptor(EmbeddedForeignKeyDescriptor original, EmbeddableValuedModelPart targetPart) {
        this.keyTable = original.keyTable;
        this.keySelectableMappings = original.keySelectableMappings;
        this.keySide = original.keySide;
        this.targetTable = targetPart.getContainingTableExpression();
        this.targetSelectableMappings = targetPart;
        this.targetSide = new EmbeddedForeignKeyDescriptorSide(ForeignKeyDescriptor.Nature.TARGET, targetPart);
        this.associationKey = original.associationKey;
        this.hasConstraint = original.hasConstraint;
    }

    @Override
    public String getKeyTable() {
        return this.keyTable;
    }

    @Override
    public String getTargetTable() {
        return this.targetTable;
    }

    @Override
    public EmbeddableValuedModelPart getKeyPart() {
        return this.keySide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public EmbeddableValuedModelPart getTargetPart() {
        return this.targetSide.getModelPart().getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
    }

    @Override
    public boolean isKeyPart(ValuedModelPart modelPart) {
        EmbeddableValuedModelPart keyPart = this.getKeyPart();
        if (this == modelPart || keyPart == modelPart) {
            return true;
        }
        if (keyPart instanceof NonAggregatedIdentifierMapping) {
            AttributeMappingsList attributeMappings = ((NonAggregatedIdentifierMapping)keyPart).getVirtualIdEmbeddable().getAttributeMappings();
            for (int i = 0; i < attributeMappings.size(); ++i) {
                if (modelPart != attributeMappings.get(i)) continue;
                return true;
            }
        } else if (keyPart.isVirtual() && keyPart.getNumberOfFetchables() == 1) {
            return keyPart.getFetchable(0) == modelPart;
        }
        return false;
    }

    @Override
    public ForeignKeyDescriptor.Side getKeySide() {
        return this.keySide;
    }

    @Override
    public ForeignKeyDescriptor.Side getTargetSide() {
        return this.targetSide;
    }

    @Override
    public int compare(Object key1, Object key2) {
        return this.getKeyPart().getEmbeddableTypeDescriptor().compare(key1, key2);
    }

    @Override
    public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
        SelectableMapping[] selectionMappings = new SelectableMapping[this.keySelectableMappings.getJdbcTypeCount()];
        for (int i = 0; i < selectionMappings.length; ++i) {
            selectionMappings[i] = selectableMappingAccess.apply(i);
        }
        return new EmbeddedForeignKeyDescriptor(this, selectionMappings[0].getContainingTableExpression(), declaringType, declaringTableGroupProducer, new SelectableMappingsImpl(selectionMappings), creationProcess);
    }

    @Override
    public ForeignKeyDescriptor withTargetPart(ValuedModelPart targetPart) {
        return new EmbeddedForeignKeyDescriptor(this, (EmbeddableValuedModelPart)targetPart);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath, targetTableGroup, null, ForeignKeyDescriptor.Nature.KEY, fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, ForeignKeyDescriptor.Nature fromSide, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (fromSide != ForeignKeyDescriptor.Nature.TARGET ? this.isTargetTableGroup(targetTableGroup) : targetTableGroup.getTableReference(navigablePath, this.associationKey.getTable(), false) != null);
        return this.createDomainResult(navigablePath.append("{fk}"), targetTableGroup, null, ForeignKeyDescriptor.Nature.KEY, fetchParent, creationState);
    }

    @Override
    public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath, targetTableGroup, null, ForeignKeyDescriptor.Nature.TARGET, fetchParent, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, String resultVariable, DomainResultCreationState creationState) {
        assert (this.isTargetTableGroup(targetTableGroup));
        return this.createDomainResult(navigablePath, targetTableGroup, resultVariable, ForeignKeyDescriptor.Nature.KEY, null, creationState);
    }

    private boolean isTargetTableGroup(TableGroup tableGroup) {
        TableGroupProducer tableGroupProducer = (tableGroup = EmbeddedForeignKeyDescriptor.getUnderlyingTableGroup(tableGroup)) instanceof OneToManyTableGroup ? (TableGroupProducer)((OneToManyTableGroup)tableGroup).getElementTableGroup().getModelPart() : (TableGroupProducer)tableGroup.getModelPart();
        return tableGroupProducer.containsTableReference(this.targetSide.getModelPart().getContainingTableExpression());
    }

    private static TableGroup getUnderlyingTableGroup(TableGroup tableGroup) {
        if (tableGroup.isVirtual()) {
            tableGroup = EmbeddedForeignKeyDescriptor.getUnderlyingTableGroup(((VirtualTableGroup)tableGroup).getUnderlyingTableGroup());
        }
        return tableGroup;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, ForeignKeyDescriptor.Nature nature, FetchParent fetchParent, DomainResultCreationState creationState) {
        NavigablePath resultNavigablePath;
        EmbeddableValuedModelPart modelPart;
        if (nature == ForeignKeyDescriptor.Nature.KEY) {
            modelPart = this.keySide.getModelPart();
            resultNavigablePath = navigablePath.append("{fk}");
        } else {
            modelPart = this.targetSide.getModelPart();
            resultNavigablePath = navigablePath.append("{fk-target}");
        }
        creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(resultNavigablePath, np -> {
            TableGroupJoin tableGroupJoin = modelPart.createTableGroupJoin(resultNavigablePath, tableGroup, null, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        ForeignKeyDescriptor.Nature currentForeignKeyResolvingKey = creationState.getCurrentlyResolvingForeignKeyPart();
        try {
            creationState.setCurrentlyResolvingForeignKeyPart(nature);
            EmbeddableForeignKeyResultImpl embeddableForeignKeyResultImpl = new EmbeddableForeignKeyResultImpl(resultNavigablePath, modelPart, resultVariable, fetchParent, creationState);
            return embeddableForeignKeyResultImpl;
        }
        finally {
            creationState.setCurrentlyResolvingForeignKeyPart(currentForeignKeyResolvingKey);
        }
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlAstCreationState creationState) {
        TableReference lhsTableReference = targetSideTableGroup.resolveTableReference(targetSideTableGroup.getNavigablePath(), this.targetTable);
        TableReference rhsTableKeyReference = keySideTableGroup.resolveTableReference(null, this.keyTable);
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, creationState);
    }

    @Override
    public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlAstCreationState creationState) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        this.targetSelectableMappings.forEachSelectable((i, selection) -> {
            ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference(targetSideReference, selection), ComparisonOperator.EQUAL, new ColumnReference(keySideReference, this.keySelectableMappings.getSelectable(i)));
            predicate.add(comparisonPredicate);
        });
        return predicate;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        if (!(predicate instanceof Junction)) {
            return false;
        }
        Junction junction = (Junction)predicate;
        if (junction.getNature() != Junction.Nature.CONJUNCTION) {
            return false;
        }
        List<Predicate> predicates = junction.getPredicates();
        if (predicates.size() != this.keySelectableMappings.getJdbcTypeCount()) {
            return false;
        }
        Boolean lhsIsKey = null;
        for (int i = 0; i < predicates.size(); ++i) {
            String rhsSelectionExpression;
            String lhsSelectionExpression;
            Predicate p = predicates.get(i);
            if (!(p instanceof ComparisonPredicate)) {
                return false;
            }
            ComparisonPredicate comparisonPredicate = (ComparisonPredicate)p;
            if (comparisonPredicate.getOperator() != ComparisonOperator.EQUAL) {
                return false;
            }
            Expression lhsExpr = comparisonPredicate.getLeftHandExpression();
            Expression rhsExpr = comparisonPredicate.getRightHandExpression();
            if (!(lhsExpr instanceof ColumnReference) || !(rhsExpr instanceof ColumnReference)) {
                return false;
            }
            ColumnReference lhs = (ColumnReference)lhsExpr;
            ColumnReference rhs = (ColumnReference)rhsExpr;
            if (lhsIsKey == null) {
                String targetExpression;
                String keyExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
                if (keyExpression.equals(targetExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression())) {
                    if (lhs.getColumnExpression().equals(keyExpression) && rhs.getColumnExpression().equals(keyExpression)) continue;
                    return false;
                }
                if (keyExpression.equals(lhs.getColumnExpression())) {
                    if (!targetExpression.equals(rhs.getColumnExpression())) {
                        return false;
                    }
                    lhsIsKey = true;
                    continue;
                }
                if (keyExpression.equals(rhs.getColumnExpression())) {
                    if (!targetExpression.equals(lhs.getColumnExpression())) {
                        return false;
                    }
                    lhsIsKey = false;
                    continue;
                }
                return false;
            }
            if (lhsIsKey.booleanValue()) {
                lhsSelectionExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
                rhsSelectionExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression();
            } else {
                lhsSelectionExpression = this.targetSelectableMappings.getSelectable(i).getSelectionExpression();
                rhsSelectionExpression = this.keySelectableMappings.getSelectable(i).getSelectionExpression();
            }
            if (lhs.getColumnExpression().equals(lhsSelectionExpression) && rhs.getColumnExpression().equals(rhsSelectionExpression)) continue;
            return false;
        }
        return true;
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.keySelectableMappings.getSelectable(columnIndex);
    }

    @Override
    public int visitKeySelectables(int offset, SelectableConsumer consumer) {
        return this.keySelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
        return this.targetSelectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public boolean hasConstraint() {
        return this.hasConstraint;
    }

    @Override
    public AssociationKey getAssociationKey() {
        return this.associationKey;
    }

    @Override
    public MappingType getMappedType() {
        return this.getPartMappingType();
    }

    @Override
    public MappingType getPartMappingType() {
        return this.targetSide.getModelPart().getPartMappingType();
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.targetSide.getModelPart().getJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.targetSide.getModelPart().getNavigableRole();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue == null) {
            int jdbcTypeCount = this.keySelectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                valueConsumer.consume(offset + i, x, y, null, this.keySelectableMappings.getSelectable(i));
            }
            return jdbcTypeCount;
        }
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            int jdbcTypeCount = this.keySelectableMappings.getJdbcTypeCount();
            for (int i = 0; i < jdbcTypeCount; ++i) {
                valueConsumer.consume(offset + i, x, y, values[i], this.keySelectableMappings.getSelectable(i));
            }
            return jdbcTypeCount;
        }
        MutableInteger columnPosition = new MutableInteger();
        return this.keySide.getModelPart().breakDownJdbcValues(domainValue, offset, x, y, (valueIndex, arg1, arg2, jdbcValue, jdbcValueMapping) -> valueConsumer.consume(offset, arg1, arg2, jdbcValue, this.keySelectableMappings.getSelectable(columnPosition.getAndIncrement())), session);
    }

    @Override
    public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Side side, SharedSessionContractImplementor session) {
        ValuedModelPart modelPart = side.getModelPart();
        if (modelPart instanceof SingleAttributeIdentifierMapping) {
            return ((SingleAttributeIdentifierMapping)modelPart).getIdentifierIfNotUnsaved(targetObject, session);
        }
        if (modelPart instanceof CompositeIdentifierMapping) {
            return ((CompositeIdentifierMapping)modelPart).getIdentifierIfNotUnsaved(targetObject, session);
        }
        return targetObject;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.targetSide.getModelPart().findContainingEntityMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        return this.targetSide.getModelPart().getJdbcMapping(index);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.targetSide.getModelPart().forEachJdbcType(offset, action);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.targetSide.getModelPart().disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.targetSide.getModelPart().addToCacheKey(cacheKey, value, session);
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.keySide.getModelPart().hasPartitionedSelectionMapping();
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }
}

