/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.SelectStatement;

public class ModifiedSubQueryExpression
implements Expression {
    private final SelectStatement subQuery;
    private final Modifier modifier;

    public ModifiedSubQueryExpression(SelectStatement subQuery, Modifier modifier) {
        this.subQuery = subQuery;
        this.modifier = modifier;
    }

    public SelectStatement getSubQuery() {
        return this.subQuery;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitModifiedSubQueryExpression(this);
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.subQuery.getExpressionType();
    }

    public static enum Modifier {
        ALL("all"),
        ANY("any"),
        SOME("some");

        private final String sqlName;

        private Modifier(String sqlName) {
            this.sqlName = sqlName;
        }

        public String getSqlName() {
            return this.sqlName;
        }
    }
}

