
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.hibernate.boot.jaxb.mapping.DiscriminatedAssociation.Discriminator;


/**
 * 
 *                 Describes the discriminator of a discriminated association (any, many-to-any),
 *                 including the mapping of discriminator values to matching entity name
 *             
 * 
 * <p>Java class for hbm-any-discriminator complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="hbm-any-discriminator">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="type" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="column" type="{http://www.hibernate.org/xsd/orm/mapping}column" minOccurs="0"/>
 *         <element name="mapping" type="{http://www.hibernate.org/xsd/orm/mapping}hbm-any-discriminator-value-mapping" maxOccurs="unbounded"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "hbm-any-discriminator", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "type",
    "column",
    "valueMappings"
})
public class JaxbHbmAnyDiscriminator
    implements Serializable, Discriminator
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String type;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbColumn column;
    @XmlElement(name = "mapping", namespace = "http://www.hibernate.org/xsd/orm/mapping", required = true)
    protected List<JaxbHbmAnyDiscriminatorValueMapping> valueMappings;

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the column property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbColumn }
     *     
     */
    public JaxbColumn getColumn() {
        return column;
    }

    /**
     * Sets the value of the column property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbColumn }
     *     
     */
    public void setColumn(JaxbColumn value) {
        this.column = value;
    }

    /**
     * Gets the value of the valueMappings property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the valueMappings property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValueMappings().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JaxbHbmAnyDiscriminatorValueMapping }
     * 
     * 
     * @return
     *     The value of the valueMappings property.
     */
    public List<JaxbHbmAnyDiscriminatorValueMapping> getValueMappings() {
        if (valueMappings == null) {
            valueMappings = new ArrayList<>();
        }
        return this.valueMappings;
    }

}
