
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.persistence.AccessType;
import jakarta.persistence.EnumType;
import jakarta.persistence.FetchType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.tuple.GenerationTiming;


/**
 * 
 *                 See `@jakarta.persistence.Basic`
 *                 See `@jakarta.persistence.Lob`
 *                 See `@jakarta.persistence.Temporal`
 *                 See `@jakarta.persistence.Enumerated`
 *                 See `@jakarta.persistence.Convert`
 *                 See `@org.hibernate.annotations.Nationalized`
 *                 See `@org.hibernate.annotations.OptimisticLock`
 *                 See `@org.hibernate.annotations.AttributeAccessor`
 *                 See `@org.hibernate.annotations.Type`
 *                 See `@org.hibernate.annotations.JdbcTypeCode`
 *             
 * 
 * <p>Java class for basic complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="basic">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <choice minOccurs="0">
 *           <element name="column" type="{http://www.hibernate.org/xsd/orm/mapping}column"/>
 *           <element name="formula" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         </choice>
 *         <choice>
 *           <element name="lob" type="{http://www.hibernate.org/xsd/orm/mapping}lob" minOccurs="0"/>
 *           <element name="temporal" type="{http://www.hibernate.org/xsd/orm/mapping}temporal" minOccurs="0"/>
 *           <element name="enumerated" type="{http://www.hibernate.org/xsd/orm/mapping}enumerated" minOccurs="0"/>
 *           <element name="convert" type="{http://www.hibernate.org/xsd/orm/mapping}convert" minOccurs="0"/>
 *           <element name="nationalized" type="{http://www.hibernate.org/xsd/orm/mapping}nationalized" minOccurs="0"/>
 *         </choice>
 *         <element name="generated" type="{http://www.hibernate.org/xsd/orm/mapping}basic-generation-timing-type" minOccurs="0"/>
 *         <element name="type" type="{http://www.hibernate.org/xsd/orm/mapping}column-type" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="fetch" type="{http://www.hibernate.org/xsd/orm/mapping}fetch-type" />
 *       <attribute name="optional" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       <attribute name="access" type="{http://www.hibernate.org/xsd/orm/mapping}access-type" />
 *       <attribute name="attribute-accessor" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="optimistic-lock" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="jdbc-type-code" type="{http://www.w3.org/2001/XMLSchema}int" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "basic", namespace = "http://www.hibernate.org/xsd/orm/mapping", propOrder = {
    "column",
    "formula",
    "lob",
    "temporal",
    "enumerated",
    "convert",
    "nationalized",
    "generated",
    "type"
})
@XmlSeeAlso({
    JaxbTenantId.class
})
public class JaxbBasic
    implements Serializable, PersistentAttribute
{

    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbColumn column;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected String formula;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbLob lob;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter14 .class)
    @XmlSchemaType(name = "token")
    protected TemporalType temporal;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter8 .class)
    @XmlSchemaType(name = "token")
    protected EnumType enumerated;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbConvert convert;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbNationalized nationalized;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping", type = String.class)
    @XmlJavaTypeAdapter(Adapter5 .class)
    @XmlSchemaType(name = "token")
    protected GenerationTiming generated;
    @XmlElement(namespace = "http://www.hibernate.org/xsd/orm/mapping")
    protected JaxbColumnType type;
    @XmlAttribute(name = "name", required = true)
    protected String name;
    @XmlAttribute(name = "fetch")
    @XmlJavaTypeAdapter(Adapter9 .class)
    protected FetchType fetch;
    @XmlAttribute(name = "optional")
    protected Boolean optional;
    @XmlAttribute(name = "access")
    @XmlJavaTypeAdapter(Adapter1 .class)
    protected AccessType access;
    @XmlAttribute(name = "attribute-accessor")
    protected String attributeAccessor;
    @XmlAttribute(name = "optimistic-lock")
    protected Boolean optimisticLock;
    @XmlAttribute(name = "jdbc-type-code")
    protected Integer jdbcTypeCode;

    /**
     * Gets the value of the column property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbColumn }
     *     
     */
    public JaxbColumn getColumn() {
        return column;
    }

    /**
     * Sets the value of the column property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbColumn }
     *     
     */
    public void setColumn(JaxbColumn value) {
        this.column = value;
    }

    /**
     * Gets the value of the formula property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFormula() {
        return formula;
    }

    /**
     * Sets the value of the formula property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormula(String value) {
        this.formula = value;
    }

    /**
     * Gets the value of the lob property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbLob }
     *     
     */
    public JaxbLob getLob() {
        return lob;
    }

    /**
     * Sets the value of the lob property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbLob }
     *     
     */
    public void setLob(JaxbLob value) {
        this.lob = value;
    }

    /**
     * Gets the value of the temporal property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public TemporalType getTemporal() {
        return temporal;
    }

    /**
     * Sets the value of the temporal property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTemporal(TemporalType value) {
        this.temporal = value;
    }

    /**
     * Gets the value of the enumerated property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public EnumType getEnumerated() {
        return enumerated;
    }

    /**
     * Sets the value of the enumerated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEnumerated(EnumType value) {
        this.enumerated = value;
    }

    /**
     * Gets the value of the convert property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbConvert }
     *     
     */
    public JaxbConvert getConvert() {
        return convert;
    }

    /**
     * Sets the value of the convert property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbConvert }
     *     
     */
    public void setConvert(JaxbConvert value) {
        this.convert = value;
    }

    /**
     * Gets the value of the nationalized property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbNationalized }
     *     
     */
    public JaxbNationalized getNationalized() {
        return nationalized;
    }

    /**
     * Sets the value of the nationalized property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbNationalized }
     *     
     */
    public void setNationalized(JaxbNationalized value) {
        this.nationalized = value;
    }

    /**
     * Gets the value of the generated property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public GenerationTiming getGenerated() {
        return generated;
    }

    /**
     * Sets the value of the generated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setGenerated(GenerationTiming value) {
        this.generated = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link JaxbColumnType }
     *     
     */
    public JaxbColumnType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link JaxbColumnType }
     *     
     */
    public void setType(JaxbColumnType value) {
        this.type = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the fetch property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public FetchType getFetch() {
        return fetch;
    }

    /**
     * Sets the value of the fetch property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFetch(FetchType value) {
        this.fetch = value;
    }

    /**
     * Gets the value of the optional property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isOptional() {
        return optional;
    }

    /**
     * Sets the value of the optional property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptional(Boolean value) {
        this.optional = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public AccessType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccess(AccessType value) {
        this.access = value;
    }

    /**
     * Gets the value of the attributeAccessor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAttributeAccessor() {
        return attributeAccessor;
    }

    /**
     * Sets the value of the attributeAccessor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAttributeAccessor(String value) {
        this.attributeAccessor = value;
    }

    /**
     * Gets the value of the optimisticLock property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isOptimisticLock() {
        if (optimisticLock == null) {
            return true;
        } else {
            return optimisticLock;
        }
    }

    /**
     * Sets the value of the optimisticLock property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setOptimisticLock(Boolean value) {
        this.optimisticLock = value;
    }

    /**
     * Gets the value of the jdbcTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getJdbcTypeCode() {
        return jdbcTypeCode;
    }

    /**
     * Sets the value of the jdbcTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setJdbcTypeCode(Integer value) {
        this.jdbcTypeCode = value;
    }

}
