
package org.hibernate.boot.jaxb.mapping;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.UuidGenerator.Style;


/**
 * 
 *                 See `@org.hibernate.annotations.UuidGenerator`
 *             
 * 
 * <p>Java class for uuid-generator complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="uuid-generator">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="style" use="required" type="{http://www.hibernate.org/xsd/orm/mapping}uuid-generator-style" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "uuid-generator", namespace = "http://www.hibernate.org/xsd/orm/mapping")
public class JaxbUuidGenerator
    implements Serializable
{

    @XmlAttribute(name = "style", required = true)
    @XmlJavaTypeAdapter(Adapter20 .class)
    protected Style style;

    /**
     * Gets the value of the style property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public Style getStyle() {
        return style;
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStyle(Style value) {
        this.style = value;
    }

}
