/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or http://www.gnu.org/licenses/lgpl-2.1.html.
 */
package org.hibernate.query.sqm.mutation.internal;

import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;

import org.jboss.logging.Logger;

/**
 * @author Steve Ebersole
 */
@SubSystemLogging(
		name = "MutationQueryLogging.MUTATION_QUERY_LOGGER_NAME",
		description = "Logging for multi-table mutation queries"
)
@Internal
public interface MutationQueryLogging {
	String MUTATION_QUERY_LOGGER_NAME = SubSystemLogging.BASE + ".query.mutation";

	Logger MUTATION_QUERY_LOGGER = Logger.getLogger( MUTATION_QUERY_LOGGER_NAME );
}
