/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import jakarta.persistence.Enumerated;
import jakarta.persistence.MapKeyEnumerated;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Nationalized;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.jboss.logging.Logger;

@Deprecated(since="6.2", forRemoval=true)
public class EnumType<T extends Enum<T>>
implements EnhancedUserType<T>,
DynamicParameterizedType,
LoggableUserType,
TypeConfigurationAware,
Serializable {
    private static final Logger LOG = CoreLogging.logger(EnumType.class);
    public static final String ENUM = "enumClass";
    public static final String NAMED = "useNamed";
    public static final String TYPE = "type";
    private Class<T> enumClass;
    private JdbcType jdbcType;
    private EnumJavaType<T> enumJavaType;
    private TypeConfiguration typeConfiguration;

    public Class<T> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public JdbcType getJdbcType(TypeConfiguration typeConfiguration) {
        return this.jdbcType;
    }

    @Override
    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (parameters.containsKey(ENUM)) {
            String enumClassName = (String)parameters.get(ENUM);
            try {
                this.enumClass = ReflectHelper.classForName(enumClassName, this.getClass()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException exception) {
                throw new HibernateException("Enum class not found: " + enumClassName, exception);
            }
        } else if (reader != null) {
            this.enumClass = reader.getReturnedClass().asSubclass(Enum.class);
        }
        JavaType descriptor = this.typeConfiguration.getJavaTypeRegistry().getDescriptor(this.enumClass);
        this.enumJavaType = (EnumJavaType)descriptor;
        if (parameters.containsKey(TYPE)) {
            int jdbcTypeCode = Integer.parseInt((String)parameters.get(TYPE));
            this.jdbcType = this.typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCode);
        } else {
            Long columnLength;
            Long l = columnLength = reader == null ? null : reader.getColumnLengths()[0];
            LocalJdbcTypeIndicators indicators = parameters.containsKey(NAMED) ? new LocalJdbcTypeIndicators(ConfigurationHelper.getBoolean(NAMED, parameters) ? jakarta.persistence.EnumType.STRING : jakarta.persistence.EnumType.ORDINAL, false, columnLength) : new LocalJdbcTypeIndicators(this.getEnumType(reader), this.isNationalized(reader), columnLength);
            this.jdbcType = descriptor.getRecommendedJdbcType(indicators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Using %s-based conversion for Enum %s", (Object)(this.isOrdinal() ? "ORDINAL" : "NAMED"), (Object)this.enumClass.getName());
        }
    }

    private jakarta.persistence.EnumType getEnumType(DynamicParameterizedType.ParameterType reader) {
        if (reader != null) {
            MapKeyEnumerated enumAnn;
            if (reader.isPrimaryKey() && (enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), MapKeyEnumerated.class)) != null) {
                return enumAnn.value();
            }
            enumAnn = this.getAnnotation(reader.getAnnotationsMethod(), Enumerated.class);
            if (enumAnn != null) {
                return enumAnn.value();
            }
        }
        return jakarta.persistence.EnumType.ORDINAL;
    }

    private boolean isNationalized(DynamicParameterizedType.ParameterType reader) {
        return this.typeConfiguration.getCurrentBaseSqlTypeIndicators().isNationalized() || reader != null && this.getAnnotation(reader.getAnnotationsMethod(), Nationalized.class) != null;
    }

    private <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> annotationType) {
        for (Annotation annotation : annotations) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public int getSqlType() {
        this.verifyConfigured();
        return this.jdbcType.getJdbcTypeCode();
    }

    @Override
    public Class<T> returnedClass() {
        return this.enumClass;
    }

    @Override
    public boolean equals(T x, T y) throws HibernateException {
        return x == y;
    }

    @Override
    public int hashCode(T x) throws HibernateException {
        return x == null ? 0 : ((Enum)x).hashCode();
    }

    @Override
    public T nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        this.verifyConfigured();
        return (T)((Enum)this.jdbcType.getExtractor(this.enumJavaType).extract(rs, position, (WrapperOptions)session));
    }

    private void verifyConfigured() {
        if (this.enumJavaType == null) {
            throw new AssertionFailure("EnumType (" + this.enumClass.getName() + ") not properly, fully configured");
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, T value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.verifyConfigured();
        this.jdbcType.getBinder(this.enumJavaType).bind(st, value, index, (WrapperOptions)session);
    }

    @Override
    public T deepCopy(T value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(T value) throws HibernateException {
        return value;
    }

    @Override
    public T assemble(Serializable cached, Object owner) throws HibernateException {
        return (T)((Enum)((Object)cached));
    }

    @Override
    public T replace(T original, T target, Object owner) throws HibernateException {
        return original;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    @Override
    public void setTypeConfiguration(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public String toSqlLiteral(T value) {
        this.verifyConfigured();
        return this.isOrdinal() ? Integer.toString(((Enum)value).ordinal()) : "'" + ((Enum)value).name() + "'";
    }

    @Override
    public String toString(T value) {
        this.verifyConfigured();
        return this.enumJavaType.toName(value);
    }

    @Override
    public T fromStringValue(CharSequence sequence) {
        this.verifyConfigured();
        return this.enumJavaType.fromName(sequence.toString());
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) {
        this.verifyConfigured();
        return this.enumJavaType.extractLoggableRepresentation((Enum)value);
    }

    public boolean isOrdinal() {
        this.verifyConfigured();
        return this.jdbcType.isInteger();
    }

    private class LocalJdbcTypeIndicators
    implements JdbcTypeIndicators {
        private final jakarta.persistence.EnumType enumType;
        private final boolean nationalized;
        private final Long columnLength;

        private LocalJdbcTypeIndicators(jakarta.persistence.EnumType enumType2, boolean nationalized, Long columnLength) {
            this.enumType = enumType2;
            this.nationalized = nationalized;
            this.columnLength = columnLength;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return EnumType.this.typeConfiguration;
        }

        @Override
        public jakarta.persistence.EnumType getEnumeratedType() {
            return this.enumType != null ? this.enumType : EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getEnumeratedType();
        }

        @Override
        public boolean isNationalized() {
            return this.nationalized;
        }

        @Override
        public long getColumnLength() {
            return this.columnLength == null ? -1L : this.columnLength;
        }

        @Override
        public Dialect getDialect() {
            return EnumType.this.typeConfiguration.getCurrentBaseSqlTypeIndicators().getDialect();
        }
    }
}

