/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.SharedSessionContract;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.tool.schema.extract.spi.ColumnTypeInformation;
import org.hibernate.type.BasicCollectionType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.ConvertedBasicCollectionType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.internal.CollectionConverter;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.AbstractJavaType;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

@Incubating
public class BasicCollectionJavaType<C extends Collection<E>, E>
extends AbstractJavaType<C>
implements BasicPluralJavaType<E> {
    private final CollectionSemantics<C, E> semantics;
    private final JavaType<E> componentJavaType;

    public BasicCollectionJavaType(ParameterizedType type, JavaType<E> componentJavaType, CollectionSemantics<C, E> semantics) {
        super(type, new CollectionMutabilityPlan<C, E>(componentJavaType, semantics));
        this.semantics = semantics;
        this.componentJavaType = componentJavaType;
    }

    @Override
    public JavaType<E> getElementJavaType() {
        return this.componentJavaType;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        return indicators.getTypeConfiguration().getJdbcTypeRegistry().resolveTypeConstructorDescriptor(indicators.getPreferredSqlTypeCodeForArray(), new BasicTypeImpl<E>(this.componentJavaType, this.componentJavaType.getRecommendedJdbcType(indicators)), ColumnTypeInformation.EMPTY);
    }

    public CollectionSemantics<C, E> getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean isWider(JavaType<?> javaType) {
        return this == javaType || this.componentJavaType == javaType;
    }

    @Override
    public BasicType<?> resolveType(TypeConfiguration typeConfiguration, Dialect dialect, BasicType<E> elementType, ColumnTypeInformation columnTypeInformation, JdbcTypeIndicators stdIndicators) {
        BasicCollectionJavaType collectionJavaType;
        Class<E> elementJavaTypeClass = elementType.getJavaTypeDescriptor().getJavaTypeClass();
        if (elementType instanceof BasicPluralType || elementJavaTypeClass != null && elementJavaTypeClass.isArray()) {
            return null;
        }
        if (this.componentJavaType == elementType.getJavaTypeDescriptor()) {
            collectionJavaType = this;
        } else {
            collectionJavaType = new BasicCollectionJavaType((ParameterizedType)this.getJavaType(), elementType.getJavaTypeDescriptor(), this.semantics);
            typeConfiguration.getJavaTypeRegistry().addDescriptor(collectionJavaType);
        }
        BasicValueConverter<Object, Object> valueConverter = elementType.getValueConverter();
        if (valueConverter == null) {
            JdbcType arrayJdbcType = typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor(stdIndicators.getPreferredSqlTypeCodeForArray(), elementType, columnTypeInformation);
            return typeConfiguration.getBasicTypeRegistry().resolve(collectionJavaType, arrayJdbcType, () -> new BasicCollectionType(elementType, arrayJdbcType, collectionJavaType));
        }
        JavaType relationalJavaType = typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(valueConverter.getRelationalJavaType().getJavaTypeClass(), 0).getClass());
        return new ConvertedBasicCollectionType<C, E>(elementType, typeConfiguration.getJdbcTypeRegistry().resolveTypeConstructorDescriptor(stdIndicators.getPreferredSqlTypeCodeForArray(), elementType, columnTypeInformation), collectionJavaType, new CollectionConverter(valueConverter, collectionJavaType, relationalJavaType));
    }

    @Override
    public String extractLoggableRepresentation(C value) {
        if (value == null) {
            return "null";
        }
        Iterator iterator = value.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            Object element = iterator.next();
            sb.append(this.componentJavaType.extractLoggableRepresentation(element));
            if (!iterator.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public boolean areEqual(C one, C another) {
        if (one == null && another == null) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        if (one.size() != another.size()) {
            return false;
        }
        switch (this.semantics.getCollectionClassification()) {
            case ARRAY: 
            case LIST: 
            case ORDERED_SET: 
            case SORTED_SET: {
                Iterator iterator1 = one.iterator();
                Iterator iterator2 = another.iterator();
                while (iterator1.hasNext()) {
                    if (this.componentJavaType.areEqual(iterator1.next(), iterator2.next())) continue;
                    return false;
                }
                break;
            }
        }
        block4: for (Object e1 : one) {
            for (Object e2 : another) {
                if (!this.componentJavaType.areEqual(e1, e2)) continue;
                continue block4;
            }
            return false;
        }
        return true;
    }

    @Override
    public int extractHashCode(C value) {
        int result = 0;
        if (value != null && !value.isEmpty()) {
            for (Object element : value) {
                if (element == null) continue;
                result += this.componentJavaType.extractHashCode(element);
            }
        }
        return result;
    }

    @Override
    public String toString(C value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        String glue = "";
        for (Object v : value) {
            sb.append(glue);
            if (v == null) {
                sb.append("null");
                glue = ",";
                continue;
            }
            sb.append('\"');
            String valstr = this.componentJavaType.toString(v);
            int len = valstr.length();
            for (int i = 0; i < len; ++i) {
                char c = valstr.charAt(i);
                if (c == '\\' || c == '\"') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            sb.append('\"');
            glue = ",";
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public C fromString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = null;
        char lastChar = charSequence.charAt(charSequence.length() - 1);
        char firstChar = charSequence.charAt(0);
        if (firstChar != '{' || lastChar != '}') {
            throw new IllegalArgumentException("Cannot parse given string into array of strings. First and last character must be { and }");
        }
        int len = charSequence.length();
        boolean inquote = false;
        for (int i = 1; i < len; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\"') {
                if (inquote) {
                    list.add(sb.toString());
                } else {
                    sb = new StringBuilder();
                }
                inquote = !inquote;
                continue;
            }
            if (!inquote) {
                if (Character.isWhitespace(c)) continue;
                if (c == ',') {
                    if (sb == null) {
                        list.add(null);
                        continue;
                    }
                    sb = null;
                    continue;
                }
                if (i + 4 < len && charSequence.charAt(i) == 'n' && charSequence.charAt(i + 1) == 'u' && charSequence.charAt(i + 2) == 'l' && charSequence.charAt(i + 3) == 'l') {
                    list.add(null);
                    i += 4;
                    continue;
                }
                if (i + 1 == len) break;
                throw new IllegalArgumentException("Cannot parse given string into array of strings. Outside of quote, but neither whitespace, comma, array end, nor null found.");
            }
            if (c == '\\' && i + 2 < len && (charSequence.charAt(i + 1) == '\\' || charSequence.charAt(i + 1) == '\"')) {
                c = charSequence.charAt(++i);
            }
            sb.append(c);
        }
        Collection result = (Collection)this.semantics.instantiateRaw(list.size(), null);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == null) continue;
            result.add(this.componentJavaType.fromString((CharSequence)list.get(i)));
        }
        return (C)result;
    }

    @Override
    public <X> X unwrap(C value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (type == byte[].class) {
            return (X)SerializationHelper.serialize(this.asArrayList(value));
        }
        if (type == BinaryStream.class) {
            return (X)new BinaryStreamImpl(SerializationHelper.serialize(this.asArrayList(value)));
        }
        if (Object[].class.isAssignableFrom(type)) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object[] unwrapped = (Object[])Array.newInstance(preferredJavaTypeClass, value.size());
            int i = 0;
            for (Object element : value) {
                unwrapped[i] = this.componentJavaType.unwrap(element, preferredJavaTypeClass, options);
                ++i;
            }
            return (X)unwrapped;
        }
        if (type.isArray()) {
            Class<?> preferredJavaTypeClass = type.getComponentType();
            Object unwrapped = Array.newInstance(preferredJavaTypeClass, value.size());
            int i = 0;
            for (Object element : value) {
                Array.set(unwrapped, i, this.componentJavaType.unwrap(element, preferredJavaTypeClass, options));
                ++i;
            }
            return (X)unwrapped;
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> C wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Array) {
            try {
                value = ((java.sql.Array)value).getArray();
            }
            catch (SQLException ex) {
                throw new HibernateException(ex);
            }
        }
        if (value instanceof Object[]) {
            Object[] raw = (Object[])value;
            Collection wrapped = (Collection)this.semantics.instantiateRaw(raw.length, null);
            if (this.componentJavaType.getJavaTypeClass().isAssignableFrom(value.getClass().getComponentType())) {
                for (Object o : raw) {
                    wrapped.add(o);
                }
            } else {
                for (Object o : raw) {
                    wrapped.add(this.componentJavaType.wrap(o, options));
                }
            }
            return (C)wrapped;
        }
        if (value instanceof byte[]) {
            return this.fromCollection((ArrayList)SerializationHelper.deserialize((byte[])value));
        }
        if (value instanceof BinaryStream) {
            return this.fromCollection((ArrayList)SerializationHelper.deserialize(((BinaryStream)value).getBytes()));
        }
        if (value instanceof Collection) {
            return this.fromCollection((Collection)value);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Collection wrapped = (Collection)this.semantics.instantiateRaw(length, null);
            for (int i = 0; i < length; ++i) {
                wrapped.add(this.componentJavaType.wrap(Array.get(value, i), options));
            }
            return (C)wrapped;
        }
        if (this.getElementJavaType().isInstance(value)) {
            Collection wrapped = (Collection)this.semantics.instantiateRaw(1, null);
            wrapped.add(value);
            return (C)wrapped;
        }
        throw this.unknownWrap(value.getClass());
    }

    private ArrayList<E> asArrayList(C value) {
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return new ArrayList(value);
    }

    private C fromCollection(Collection<E> value) {
        switch (this.semantics.getCollectionClassification()) {
            case LIST: 
            case BAG: {
                if (!(value instanceof ArrayList)) break;
                return (C)value;
            }
        }
        Collection collection = (Collection)this.semantics.instantiateRaw(value.size(), null);
        collection.addAll(value);
        return (C)collection;
    }

    private static class CollectionMutabilityPlan<C extends Collection<E>, E>
    implements MutabilityPlan<C> {
        private final CollectionSemantics<C, E> semantics;
        private final MutabilityPlan<E> componentPlan;

        public CollectionMutabilityPlan(JavaType<E> baseDescriptor, CollectionSemantics<C, E> semantics) {
            this.semantics = semantics;
            this.componentPlan = baseDescriptor.getMutabilityPlan();
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public C deepCopy(C value) {
            if (value == null) {
                return null;
            }
            Collection<Object> copy = this.semantics.getCollectionClassification() == CollectionClassification.SET ? CollectionHelper.linkedSetOfSize(value.size()) : (Collection)this.semantics.instantiateRaw(value.size(), null);
            for (Object element : value) {
                copy.add(this.componentPlan.deepCopy(element));
            }
            return (C)copy;
        }

        @Override
        public Serializable disassemble(C value, SharedSessionContract session) {
            return (Serializable)this.deepCopy(value);
        }

        @Override
        public C assemble(Serializable cached, SharedSessionContract session) {
            return (C)this.deepCopy((C)((Collection)((Object)cached)));
        }
    }
}

