/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.Incubating;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.TreatedNavigablePath;

@Incubating
public class NavigablePath
implements DotIdentifierSequence,
Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final @Nullable @UnknownKeyFor @Initialized NavigablePath parent;
    private final @UnknownKeyFor @NonNull @Initialized String localName;
    private final @Nullable @UnknownKeyFor @Initialized String alias;
    private final @UnknownKeyFor @NonNull @Initialized String identifierForTableGroup;
    private final @UnknownKeyFor @NonNull @Initialized FullPathCalculator fullPathCalculator;
    private final @UnknownKeyFor @NonNull @Initialized int hashCode;

    public NavigablePath(@UnknownKeyFor @NonNull @Initialized String localName) {
        this(localName, null);
    }

    public NavigablePath(@UnknownKeyFor @NonNull @Initialized String rootName, @Nullable @UnknownKeyFor @Initialized String alias) {
        this.parent = null;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        this.localName = rootName;
        this.identifierForTableGroup = rootName;
        this.fullPathCalculator = NavigablePath::calculateRootFullPath;
        this.hashCode = this.localName.hashCode() + (alias == null ? 0 : alias.hashCode());
    }

    public NavigablePath(@UnknownKeyFor @NonNull @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String navigableName) {
        this(parent, navigableName, null);
    }

    public NavigablePath(@UnknownKeyFor @NonNull @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String localName, @Nullable @UnknownKeyFor @Initialized String alias) {
        assert (parent != null);
        this.parent = parent;
        this.alias = alias = StringHelper.nullIfEmpty(alias);
        String aliasedLocalName = alias == null ? localName : localName + "(" + alias + ")";
        this.hashCode = parent.hashCode() + aliasedLocalName.hashCode();
        if (IDENTIFIER_MAPPER_PROPERTY.equals(localName)) {
            this.localName = "";
            this.identifierForTableGroup = parent.getFullPath();
            this.fullPathCalculator = NavigablePath::calculateIdMapperFullPath;
        } else {
            this.localName = localName;
            this.identifierForTableGroup = StringHelper.isEmpty(parent.getIdentifierForTableGroup()) ? aliasedLocalName : parent.getIdentifierForTableGroup() + "." + localName;
            this.fullPathCalculator = NavigablePath::calculateNormalFullPath;
        }
    }

    public NavigablePath(@Nullable @UnknownKeyFor @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String localName, @Nullable @UnknownKeyFor @Initialized String alias, @UnknownKeyFor @NonNull @Initialized String identifierForTableGroup, @UnknownKeyFor @NonNull @Initialized FullPathCalculator fullPathCalculator, @UnknownKeyFor @NonNull @Initialized int hashCode) {
        this.parent = parent;
        this.localName = localName;
        this.hashCode = hashCode;
        this.alias = StringHelper.nullIfEmpty(alias);
        this.identifierForTableGroup = identifierForTableGroup;
        this.fullPathCalculator = fullPathCalculator;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized NavigablePath getParent() {
        return this.parent instanceof TreatedNavigablePath ? this.parent.getParent() : this.parent;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getLocalName() {
        return this.localName;
    }

    public @Nullable @UnknownKeyFor @Initialized String getAlias() {
        return this.alias;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAliased() {
        return this.alias != null;
    }

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierForTableGroup() {
        return this.identifierForTableGroup;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        DotIdentifierSequence otherPath = (DotIdentifierSequence)other;
        if (!this.localNamesMatch(otherPath)) {
            return false;
        }
        if (otherPath instanceof NavigablePath) {
            NavigablePath otherNavigablePath = (NavigablePath)otherPath;
            if (!Objects.equals(this.getAlias(), otherNavigablePath.getAlias())) {
                return false;
            }
            return Objects.equals(this.getRealParent(), otherNavigablePath.getRealParent());
        }
        return Objects.equals(this.getParent(), otherPath.getParent());
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean localNamesMatch(@UnknownKeyFor @NonNull @Initialized DotIdentifierSequence other) {
        if (other instanceof EntityIdentifierNavigablePath) {
            return this.localNamesMatch((EntityIdentifierNavigablePath)other);
        }
        return Objects.equals(this.getLocalName(), other.getLocalName());
    }

    protected @UnknownKeyFor @NonNull @Initialized boolean localNamesMatch(@UnknownKeyFor @NonNull @Initialized EntityIdentifierNavigablePath other) {
        return Objects.equals(this.getLocalName(), other.getLocalName()) || Objects.equals(this.getLocalName(), other.getIdentifierAttributeName());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NavigablePath append(@UnknownKeyFor @NonNull @Initialized String property) {
        return new NavigablePath(this, property);
    }

    public @UnknownKeyFor @NonNull @Initialized NavigablePath append(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized String alias) {
        return new NavigablePath(this, property, alias);
    }

    public @UnknownKeyFor @NonNull @Initialized NavigablePath treatAs(@UnknownKeyFor @NonNull @Initialized String entityName) {
        return new TreatedNavigablePath(this, entityName);
    }

    public @UnknownKeyFor @NonNull @Initialized NavigablePath treatAs(@UnknownKeyFor @NonNull @Initialized String entityName, @UnknownKeyFor @NonNull @Initialized String alias) {
        return new TreatedNavigablePath(this, entityName, alias);
    }

    public @Nullable @UnknownKeyFor @Initialized NavigablePath getRealParent() {
        return this.parent;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isParent(@Nullable @UnknownKeyFor @Initialized NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath.getParent())) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSuffix(@Nullable @UnknownKeyFor @Initialized DotIdentifierSequence dotIdentifierSequence) {
        if (dotIdentifierSequence == null) {
            return true;
        }
        if (!this.localNamesMatch(dotIdentifierSequence)) {
            return false;
        }
        NavigablePath parent = this.getParent();
        return parent != null && parent.isSuffix(dotIdentifierSequence.getParent());
    }

    public @Nullable @UnknownKeyFor @Initialized NavigablePath trimSuffix(@Nullable @UnknownKeyFor @Initialized DotIdentifierSequence suffix) {
        if (suffix == null) {
            return this;
        }
        if (!this.getLocalName().equals(suffix.getLocalName())) {
            return null;
        }
        NavigablePath parent = this.getParent();
        if (parent != null) {
            return parent.trimSuffix(suffix.getParent());
        }
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isParentOrEqual(@Nullable @UnknownKeyFor @Initialized NavigablePath navigablePath) {
        while (navigablePath != null) {
            if (this.equals(navigablePath)) {
                return true;
            }
            navigablePath = navigablePath.getParent();
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean pathsMatch(@Nullable @UnknownKeyFor @Initialized NavigablePath p) {
        return this == p || p != null && this.localName.equals(p.localName) && (this.parent == null ? p.parent == null && Objects.equals(this.alias, p.alias) : this.parent.pathsMatch(p.parent));
    }

    public @Nullable @UnknownKeyFor @Initialized String relativize(@UnknownKeyFor @NonNull @Initialized NavigablePath base) {
        RelativePathCollector pathCollector = new RelativePathCollector();
        this.relativize(base, pathCollector);
        return pathCollector.resolve();
    }

    protected void relativize(@UnknownKeyFor @NonNull @Initialized NavigablePath base, @UnknownKeyFor @NonNull @Initialized RelativePathCollector collector) {
        if (this.equals(base)) {
            collector.matchedBase = true;
            return;
        }
        if (!collector.matchedBase && this.parent != null) {
            this.parent.relativize(base, collector);
        }
        collector.collectPath(this.getLocalName());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getFullPath() {
        return this.fullPathCalculator.calculateFullPath(this.parent, this.localName, this.alias);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.getFullPath();
    }

    protected static @UnknownKeyFor @NonNull @Initialized String calculateRootFullPath(@Nullable @UnknownKeyFor @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String rootName, @Nullable @UnknownKeyFor @Initialized String alias) {
        assert (parent == null);
        return alias == null ? rootName : rootName + "(" + alias + ")";
    }

    private static @UnknownKeyFor @NonNull @Initialized String calculateNormalFullPath(@Nullable @UnknownKeyFor @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String localName, @Nullable @UnknownKeyFor @Initialized String alias) {
        assert (parent != null);
        String parentFullPath = NullnessUtil.castNonNull(parent).getFullPath();
        String baseFullPath = StringHelper.isEmpty(parentFullPath) ? localName : parentFullPath + "." + localName;
        return alias == null ? baseFullPath : baseFullPath + "(" + alias + ")";
    }

    protected static @UnknownKeyFor @NonNull @Initialized String calculateIdMapperFullPath(@Nullable @UnknownKeyFor @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String localName, @Nullable @UnknownKeyFor @Initialized String alias) {
        return parent != null ? parent.getFullPath() : "";
    }

    @FunctionalInterface
    protected static interface FullPathCalculator
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized String calculateFullPath(@Nullable @UnknownKeyFor @Initialized NavigablePath var1, @UnknownKeyFor @NonNull @Initialized String var2, @Nullable @UnknownKeyFor @Initialized String var3);
    }

    protected static class RelativePathCollector {
        private @UnknownKeyFor @NonNull @Initialized boolean matchedBase;
        private @UnknownKeyFor @NonNull @Initialized StringBuilder buffer;

        protected RelativePathCollector() {
        }

        public void collectPath(@UnknownKeyFor @NonNull @Initialized String path) {
            if (!this.matchedBase) {
                return;
            }
            if (this.buffer == null) {
                this.buffer = new StringBuilder();
            } else {
                this.buffer.append('.');
            }
            this.buffer.append(path);
        }

        public @Nullable @UnknownKeyFor @Initialized String resolve() {
            if (this.buffer == null) {
                return this.matchedBase ? "" : null;
            }
            return this.buffer.toString();
        }
    }
}

