/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later.
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate;

/**
 * Thrown when the user passes a persistent instance to a {@link Session}
 * method that expects a transient instance.
 *
 * @author Gavin King
 */
public class PersistentObjectException extends HibernateException {
	/**
	 * Constructs a {@code PersistentObjectException} using the given message.
	 *
	 * @param message A message explaining the exception condition
	 */
	public PersistentObjectException(String message) {
		super( message );
	}
}
