/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.criteria.CompoundSelection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.BindableType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.AbstractCommonQueryContract;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.PrimitiveJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public abstract class AbstractSelectionQuery<R>
extends AbstractCommonQueryContract
implements SelectionQuery<R>,
DomainQueryExecutionContext {
    public static final String CRITERIA_HQL_STRING = "<criteria>";
    private Callback callback;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;

    public AbstractSelectionQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    protected TupleMetadata buildTupleMetadata(SqmStatement<?> statement, Class<R> resultType) {
        if (AbstractSelectionQuery.isInstantiableWithoutMetadata(resultType)) {
            return null;
        }
        SqmSelectStatement select = (SqmSelectStatement)statement;
        List<SqmSelection<?>> selections = ((SqmQueryPart)select.getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
        if (Tuple.class.equals(resultType) || selections.size() > 1) {
            return this.getTupleMetadata(selections);
        }
        return null;
    }

    private TupleMetadata getTupleMetadata(List<SqmSelection<?>> selections) {
        if (this.getQueryOptions().getTupleTransformer() == null) {
            return new TupleMetadata(AbstractSelectionQuery.buildTupleElementArray(selections), AbstractSelectionQuery.buildTupleAliasArray(selections));
        }
        throw new IllegalArgumentException("Illegal combination of Tuple resultType and (non-JpaTupleBuilder) TupleTransformer: " + this.getQueryOptions().getTupleTransformer());
    }

    private static TupleElement<?>[] buildTupleElementArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode<?> selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List<JpaSelection<?>> selectionItems = selectableNode.getSelectionItems();
                TupleElement[] elements = new TupleElement[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = selectionItems.get(i);
                }
                return elements;
            }
            return new TupleElement[]{selectableNode};
        }
        TupleElement[] elements = new TupleElement[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getSelectableNode();
        }
        return elements;
    }

    private static String[] buildTupleAliasArray(List<SqmSelection<?>> selections) {
        if (selections.size() == 1) {
            SqmSelectableNode<?> selectableNode = selections.get(0).getSelectableNode();
            if (selectableNode instanceof CompoundSelection) {
                List<JpaSelection<?>> selectionItems = selectableNode.getSelectionItems();
                String[] elements = new String[selectionItems.size()];
                for (int i = 0; i < selectionItems.size(); ++i) {
                    elements[i] = selectionItems.get(i).getAlias();
                }
                return elements;
            }
            return new String[]{selectableNode.getAlias()};
        }
        String[] elements = new String[selections.size()];
        for (int i = 0; i < selections.size(); ++i) {
            elements[i] = selections.get(i).getAlias();
        }
        return elements;
    }

    protected void applyOptions(NamedSqmQueryMemento memento) {
        this.applyOptions((NamedQueryMemento)memento);
        if (memento.getFirstResult() != null) {
            this.setFirstResult(memento.getFirstResult());
        }
        if (memento.getMaxResults() != null) {
            this.setMaxResults(memento.getMaxResults());
        }
        if (memento.getParameterTypes() != null) {
            BasicTypeRegistry basicTypeRegistry = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry();
            for (Map.Entry<String, String> entry : memento.getParameterTypes().entrySet()) {
                BasicType type = basicTypeRegistry.getRegisteredType(entry.getValue());
                this.getParameterMetadata().getQueryParameter(entry.getKey()).applyAnticipatedType(type);
            }
        }
    }

    protected void applyOptions(NamedQueryMemento memento) {
        if (memento.getHints() != null) {
            memento.getHints().forEach(this::applyHint);
        }
        if (memento.getCacheable() != null) {
            this.setCacheable(memento.getCacheable());
        }
        if (memento.getCacheRegion() != null) {
            this.setCacheRegion(memento.getCacheRegion());
        }
        if (memento.getCacheMode() != null) {
            this.setCacheMode(memento.getCacheMode());
        }
        if (memento.getFlushMode() != null) {
            this.setHibernateFlushMode(memento.getFlushMode());
        }
        if (memento.getReadOnly() != null) {
            this.setReadOnly(memento.getReadOnly());
        }
        if (memento.getTimeout() != null) {
            this.setTimeout(memento.getTimeout());
        }
        if (memento.getFetchSize() != null) {
            this.setFetchSize(memento.getFetchSize());
        }
        if (memento.getComment() != null) {
            this.setComment(memento.getComment());
        }
    }

    protected abstract String getQueryString();

    protected void visitQueryReturnType(SqmQueryPart<R> queryPart, Class<R> expectedResultType, SessionFactoryImplementor factory) {
        assert (this.getQueryString().equals(CRITERIA_HQL_STRING));
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec sqmQuerySpec = (SqmQuerySpec)queryPart;
            List<SqmSelection<?>> sqmSelections = sqmQuerySpec.getSelectClause().getSelections();
            if (sqmSelections == null || sqmSelections.isEmpty()) {
                List<SqmRoot<?>> sqmRoots = sqmQuerySpec.getFromClause().getRoots();
                if (sqmRoots == null || sqmRoots.isEmpty()) {
                    throw new IllegalArgumentException("Criteria did not define any query roots");
                }
                if (sqmRoots.size() == 1) {
                    sqmQuerySpec.getSelectClause().add(sqmRoots.get(0), (String)null);
                } else {
                    throw new IllegalArgumentException("Criteria has multiple query roots");
                }
            }
            if (expectedResultType != null) {
                AbstractSelectionQuery.checkQueryReturnType(sqmQuerySpec, expectedResultType, factory);
            }
        } else {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            for (SqmQueryPart sqmQueryPart : queryGroup.getQueryParts()) {
                this.visitQueryReturnType(sqmQueryPart, expectedResultType, factory);
            }
        }
    }

    protected static <T> void checkQueryReturnType(SqmQuerySpec<T> querySpec, Class<T> expectedResultClass, SessionFactoryImplementor sessionFactory) {
        List<SqmSelection<?>> selections;
        if (!AbstractSelectionQuery.isResultTypeAlwaysAllowed(expectedResultClass) && (selections = querySpec.getSelectClause().getSelections()).size() == 1) {
            SqmParameter sqmParameter;
            SqmExpressible nodeType;
            SqmSelection<?> sqmSelection = selections.get(0);
            SqmSelectableNode<?> selection = sqmSelection.getSelectableNode();
            if (selection instanceof SqmParameter && ((nodeType = (sqmParameter = (SqmParameter)selection).getNodeType()) == null || nodeType.getExpressibleJavaType() == null)) {
                return;
            }
            if (!sessionFactory.getSessionFactoryOptions().getJpaCompliance().isJpaQueryComplianceEnabled()) {
                AbstractSelectionQuery.verifyResultType(expectedResultClass, sqmSelection.getExpressible());
            }
        }
    }

    private static boolean isInstantiableWithoutMetadata(Class<?> resultType) {
        return resultType == null || resultType.isArray() || Object.class == resultType || List.class == resultType;
    }

    private static <T> boolean isResultTypeAlwaysAllowed(Class<T> expectedResultClass) {
        return expectedResultClass == null || expectedResultClass == Object.class || expectedResultClass == List.class || expectedResultClass == Tuple.class || expectedResultClass.isArray();
    }

    protected static <T> void verifyResultType(Class<T> resultClass, SqmExpressible<?> sqmExpressible) {
        assert (sqmExpressible != null);
        JavaType<?> expressibleJavaType = sqmExpressible.getExpressibleJavaType();
        assert (expressibleJavaType != null);
        Class<?> javaTypeClass = expressibleJavaType.getJavaTypeClass();
        if (!resultClass.isAssignableFrom(javaTypeClass)) {
            if (expressibleJavaType instanceof PrimitiveJavaType) {
                PrimitiveJavaType javaType = (PrimitiveJavaType)expressibleJavaType;
                if (javaType.getPrimitiveClass() != resultClass) {
                    AbstractSelectionQuery.throwQueryTypeMismatchException(resultClass, sqmExpressible);
                }
            } else if (!AbstractSelectionQuery.isMatchingDateType(javaTypeClass, resultClass, sqmExpressible)) {
                AbstractSelectionQuery.throwQueryTypeMismatchException(resultClass, sqmExpressible);
            }
        }
    }

    private static <T> boolean isMatchingDateType(Class<?> javaTypeClass, Class<T> resultClass, SqmExpressible<?> sqmExpressible) {
        return javaTypeClass == java.util.Date.class && AbstractSelectionQuery.isMatchingDateJdbcType(resultClass, AbstractSelectionQuery.getJdbcType(sqmExpressible));
    }

    private static JdbcType getJdbcType(SqmExpressible<?> sqmExpressible) {
        SqmPathSource pathSource;
        DomainType domainType;
        if (sqmExpressible instanceof BasicDomainType) {
            return ((BasicDomainType)sqmExpressible).getJdbcType();
        }
        if (sqmExpressible instanceof SqmPathSource && (domainType = (pathSource = (SqmPathSource)sqmExpressible).getSqmPathType()) instanceof BasicDomainType) {
            return ((BasicDomainType)domainType).getJdbcType();
        }
        return null;
    }

    private static <T> boolean isMatchingDateJdbcType(Class<T> resultClass, JdbcType jdbcType) {
        if (jdbcType != null) {
            switch (jdbcType.getDefaultSqlTypeCode()) {
                case 91: {
                    if (!resultClass.isAssignableFrom(Date.class)) break;
                    return true;
                }
                case 92: {
                    if (!resultClass.isAssignableFrom(Time.class)) break;
                    return true;
                }
                case 93: {
                    if (!resultClass.isAssignableFrom(Timestamp.class)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static <T> void throwQueryTypeMismatchException(Class<T> resultClass, SqmExpressible<?> sqmExpressible) {
        String errorMessage = String.format("Specified result type [%s] did not match Query selection type [%s] - multiple selections: use Tuple or array", resultClass.getName(), sqmExpressible.getTypeName());
        throw new QueryTypeMismatchException(errorMessage);
    }

    @Override
    public List<R> list() {
        HashSet<String> fetchProfiles = this.beforeQueryHandlingFetchProfiles();
        boolean success = false;
        try {
            List<R> result = this.doList();
            success = true;
            List<R> list = result;
            return list;
        }
        catch (IllegalQueryOperationException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException he) {
            throw this.getSession().getExceptionConverter().convert(he, this.getQueryOptions().getLockOptions());
        }
        finally {
            this.afterQueryHandlingFetchProfiles(success, fetchProfiles);
        }
    }

    protected HashSet<String> beforeQueryHandlingFetchProfiles() {
        this.beforeQuery();
        QueryOptions options = this.getQueryOptions();
        return this.getSession().getLoadQueryInfluencers().adjustFetchProfiles(options.getDisabledFetchProfiles(), options.getEnabledFetchProfiles());
    }

    protected void beforeQuery() {
        CacheMode effectiveCacheMode;
        this.getQueryParameterBindings().validate();
        SharedSessionContractImplementor session = this.getSession();
        QueryOptions options = this.getQueryOptions();
        session.prepareForQueryExecution(this.requiresTxn(options.getLockOptions().findGreatestLockMode()));
        this.prepareForExecution();
        assert (this.sessionFlushMode == null);
        assert (this.sessionCacheMode == null);
        FlushMode effectiveFlushMode = this.getHibernateFlushMode();
        if (effectiveFlushMode != null) {
            this.sessionFlushMode = session.getHibernateFlushMode();
            session.setHibernateFlushMode(effectiveFlushMode);
        }
        if ((effectiveCacheMode = this.getCacheMode()) != null) {
            this.sessionCacheMode = session.getCacheMode();
            session.setCacheMode(effectiveCacheMode);
        }
    }

    protected abstract void prepareForExecution();

    protected void afterQueryHandlingFetchProfiles(boolean success, HashSet<String> fetchProfiles) {
        this.resetFetchProfiles(fetchProfiles);
        this.afterQuery(success);
    }

    private void afterQueryHandlingFetchProfiles(HashSet<String> fetchProfiles) {
        this.resetFetchProfiles(fetchProfiles);
        this.afterQuery();
    }

    private void resetFetchProfiles(HashSet<String> fetchProfiles) {
        this.getSession().getLoadQueryInfluencers().setEnabledFetchProfileNames(fetchProfiles);
    }

    protected void afterQuery(boolean success) {
        this.afterQuery();
        SharedSessionContractImplementor session = this.getSession();
        if (!session.isTransactionInProgress()) {
            session.getJdbcCoordinator().getLogicalConnection().afterTransaction();
        }
        session.afterOperation(success);
    }

    protected void afterQuery() {
        if (this.sessionFlushMode != null) {
            this.getSession().setHibernateFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }

    protected boolean requiresTxn(LockMode lockMode) {
        return lockMode != null && lockMode.greaterThan(LockMode.READ);
    }

    protected abstract List<R> doList();

    @Override
    public ScrollableResultsImplementor<R> scroll() {
        return this.scroll(this.getSession().getFactory().getJdbcServices().getJdbcEnvironment().getDialect().defaultScrollMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResultsImplementor<R> scroll(ScrollMode scrollMode) {
        HashSet<String> fetchProfiles = this.beforeQueryHandlingFetchProfiles();
        try {
            ScrollableResultsImplementor<R> scrollableResultsImplementor = this.doScroll(scrollMode);
            return scrollableResultsImplementor;
        }
        finally {
            this.afterQueryHandlingFetchProfiles(fetchProfiles);
        }
    }

    protected abstract ScrollableResultsImplementor<R> doScroll(ScrollMode var1);

    @Override
    public Stream<R> getResultStream() {
        return this.stream();
    }

    @Override
    public Stream stream() {
        ScrollableResults scrollableResults = this.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(((ScrollableResultsImplementor)scrollableResults)::close);
    }

    @Override
    public R uniqueResult() {
        return AbstractSelectionQuery.uniqueElement(this.list());
    }

    @Override
    public R getSingleResult() {
        try {
            List<R> list = this.list();
            if (list.isEmpty()) {
                throw new NoResultException(String.format("No result found for query [%s]", this.getQueryString()));
            }
            return AbstractSelectionQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e, this.getQueryOptions().getLockOptions());
        }
    }

    protected static <T> T uniqueElement(List<T> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        T first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return Optional.ofNullable(this.uniqueResult());
    }

    @Override
    public R getSingleResultOrNull() {
        try {
            return AbstractSelectionQuery.uniqueElement(this.list());
        }
        catch (HibernateException e) {
            throw this.getSession().getExceptionConverter().convert(e, this.getLockOptions());
        }
    }

    protected static boolean hasLimit(SqmSelectStatement<?> sqm, MutableQueryOptions queryOptions) {
        return queryOptions.hasLimit() || sqm.getFetch() != null || sqm.getOffset() != null;
    }

    protected static boolean hasAppliedGraph(MutableQueryOptions queryOptions) {
        return queryOptions.getAppliedGraph() != null && queryOptions.getAppliedGraph().getSemantic() != null;
    }

    @Override
    public Callback getCallback() {
        if (this.callback == null) {
            this.callback = new CallbackImpl();
        }
        return this.callback;
    }

    @Override
    public boolean hasCallbackActions() {
        return this.callback != null && this.callback.hasAfterLoadActions();
    }

    protected void resetCallback() {
        this.callback = null;
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.getQueryOptions().getFlushMode().toJpaFlushMode();
    }

    @Override
    public SelectionQuery<R> setFlushMode(FlushModeType flushMode) {
        this.getQueryOptions().setFlushMode(FlushMode.fromJpaFlushMode(flushMode));
        return this;
    }

    @Override
    public SelectionQuery<R> setMaxResults(int maxResult) {
        super.applyMaxResults(maxResult);
        return this;
    }

    @Override
    public SelectionQuery<R> setFirstResult(int startPosition) {
        this.getSession().checkOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.getQueryOptions().getLimit().setFirstRow(startPosition);
        return this;
    }

    @Override
    public SelectionQuery<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public SelectionQuery<R> setEntityGraph(EntityGraph<R> graph, GraphSemantic semantic) {
        this.applyGraph((RootGraphImplementor)graph, semantic);
        return this;
    }

    @Override
    public SelectionQuery<R> enableFetchProfile(String profileName) {
        if (!this.getSession().getFactory().containsFetchProfileDefinition(profileName)) {
            throw new UnknownProfileException(profileName);
        }
        this.getQueryOptions().enableFetchProfile(profileName);
        return this;
    }

    @Override
    public SelectionQuery<R> disableFetchProfile(String profileName) {
        this.getQueryOptions().disableFetchProfile(profileName);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    @Override
    public LockModeType getLockMode() {
        return LockModeTypeHelper.getLockModeType(this.getHibernateLockMode());
    }

    @Override
    public SelectionQuery<R> setLockMode(LockModeType lockMode) {
        this.setHibernateLockMode(LockModeTypeHelper.getLockMode(lockMode));
        return this;
    }

    @Override
    public SelectionQuery<R> setLockMode(String alias, LockMode lockMode) {
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public LockMode getHibernateLockMode() {
        return this.getLockOptions().getLockMode();
    }

    @Override
    public SelectionQuery<R> setHibernateLockMode(LockMode lockMode) {
        this.getLockOptions().setLockMode(lockMode);
        return this;
    }

    @Override
    @Deprecated
    public SelectionQuery<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        this.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setFollowOnLocking(boolean enable) {
        this.getLockOptions().setFollowOnLocking(enable);
        return this;
    }

    @Override
    protected void collectHints(Map<String, Object> hints) {
        AppliedGraph appliedGraph;
        super.collectHints(hints);
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        this.putIfNotNull(hints, "org.hibernate.fetchSize", this.getFetchSize());
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
            this.putIfNotNull(hints, "org.hibernate.cacheMode", this.getCacheMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "jakarta.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
            this.putIfNotNull(hints, "javax.persistence.cache.retrieveMode", (Enum<?>)this.getQueryOptions().getCacheRetrieveMode());
            this.putIfNotNull(hints, "javax.persistence.cache.storeMode", (Enum<?>)this.getQueryOptions().getCacheStoreMode());
        }
        if ((appliedGraph = this.getQueryOptions().getAppliedGraph()) != null && appliedGraph.getSemantic() != null) {
            hints.put(appliedGraph.getSemantic().getJakartaHintName(), appliedGraph);
            hints.put(appliedGraph.getSemantic().getJpaHintName(), appliedGraph);
        }
        this.putIfNotNull(hints, "hibernate.query.followOnLocking", this.getQueryOptions().getLockOptions().getFollowOnLocking());
    }

    @Override
    public Integer getFetchSize() {
        return this.getQueryOptions().getFetchSize();
    }

    @Override
    public SelectionQuery<R> setFetchSize(int fetchSize) {
        this.getQueryOptions().setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public SelectionQuery<R> setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public CacheStoreMode getCacheStoreMode() {
        return this.getCacheMode().getJpaStoreMode();
    }

    @Override
    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.getCacheMode().getJpaRetrieveMode();
    }

    @Override
    public SelectionQuery<R> setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return this.setCacheMode(CacheMode.fromJpaModes(cacheRetrieveMode, this.getQueryOptions().getCacheMode().getJpaStoreMode()));
    }

    @Override
    public SelectionQuery<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return this.setCacheMode(CacheMode.fromJpaModes(this.getQueryOptions().getCacheMode().getJpaRetrieveMode(), cacheStoreMode));
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
    }

    @Override
    public SelectionQuery<R> setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public boolean isQueryPlanCacheable() {
        return this.getQueryOptions().getQueryPlanCachingEnabled() != Boolean.FALSE;
    }

    @Override
    public SelectionQuery<R> setQueryPlanCacheable(boolean queryPlanCacheable) {
        this.getQueryOptions().setQueryPlanCachingEnabled(queryPlanCacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public SelectionQuery<R> setCacheRegion(String regionName) {
        this.getQueryOptions().setResultCacheRegionName(regionName);
        return this;
    }

    @Override
    public SelectionQuery<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public SelectionQuery<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public SelectionQuery<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Object value) {
        super.setParameter(name, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(String name, P value, Class<P> javaType) {
        super.setParameter(name, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(String name, P value, BindableType<P> type) {
        super.setParameter(name, value, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Object value) {
        super.setParameter(position, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(int position, P value, Class<P> javaType) {
        super.setParameter(position, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(int position, P value, BindableType<P> type) {
        super.setParameter(position, value, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, Class<P> javaType) {
        super.setParameter(parameter, value, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(QueryParameter<P> parameter, P value, BindableType<P> type) {
        super.setParameter(parameter, value, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameter(Parameter<P> parameter, P value) {
        super.setParameter(parameter, value);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(Parameter<java.util.Date> param, java.util.Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(String name, java.util.Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameter(int position, java.util.Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, P[] values, Class<P> javaType) {
        super.setParameterList(name, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> SelectionQuery<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public SelectionQuery<R> setProperties(Map map) {
        super.setProperties(map);
        return this;
    }

    @Override
    public SelectionQuery<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.getSession().getFactory();
    }
}

