/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ComparisonRestriction;
import org.hibernate.sql.NullnessRestriction;
import org.hibernate.sql.Restriction;
import org.hibernate.sql.RestrictionRenderingContext;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

@Internal
public class Delete
implements RestrictionRenderingContext {
    protected String tableName;
    protected String comment;
    protected final List<Restriction> restrictions = new ArrayList<Restriction>();
    private final ParameterMarkerStrategy parameterMarkerStrategy;
    private int parameterCount;

    public Delete(SessionFactoryImplementor factory) {
        this(factory.getFastSessionServices().parameterMarkerStrategy);
    }

    public Delete(ParameterMarkerStrategy parameterMarkerStrategy) {
        this.parameterMarkerStrategy = parameterMarkerStrategy;
    }

    public Delete setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Delete setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Delete addColumnRestriction(String columnName) {
        this.restrictions.add(new ComparisonRestriction(columnName));
        return this;
    }

    public Delete addColumnRestriction(String ... columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i] == null) continue;
            this.addColumnRestriction(columnNames[i]);
        }
        return this;
    }

    public Delete addColumnIsNullRestriction(String columnName) {
        this.restrictions.add(new NullnessRestriction(columnName));
        return this;
    }

    public Delete addColumnIsNotNullRestriction(String columnName) {
        this.restrictions.add(new NullnessRestriction(columnName, false));
        return this;
    }

    public Delete setVersionColumnName(String versionColumnName) {
        if (versionColumnName != null) {
            this.addColumnRestriction(versionColumnName);
        }
        return this;
    }

    public String toStatementString() {
        StringBuilder buf = new StringBuilder(this.tableName.length() + 10);
        this.applyComment(buf);
        buf.append("delete from ").append(this.tableName);
        this.applyRestrictions(buf);
        return buf.toString();
    }

    private void applyComment(StringBuilder buf) {
        if (this.comment != null) {
            buf.append("/* ").append(Dialect.escapeComment(this.comment)).append(" */ ");
        }
    }

    private void applyRestrictions(StringBuilder buf) {
        if (this.restrictions.isEmpty()) {
            return;
        }
        buf.append(" where ");
        for (int i = 0; i < this.restrictions.size(); ++i) {
            if (i > 0) {
                buf.append(" and ");
            }
            this.restrictions.get(i).render(buf, this);
        }
    }

    @Override
    public String makeParameterMarker() {
        return this.parameterMarkerStrategy.createMarker(++this.parameterCount, null);
    }
}

