/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.GenericsHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.converter.internal.JpaAttributeConverterImpl;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

class FilterDefBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(FilterDefBinder.class);

    FilterDefBinder() {
    }

    public static void bindFilterDef(FilterDef filterDef, MetadataBuildingContext context) {
        Map<String, ManagedBean<? extends Supplier>> parameterResolvers;
        Map<String, JdbcMapping> explicitParamJaMappings;
        String name = filterDef.name();
        if (context.getMetadataCollector().getFilterDefinition(name) != null) {
            throw new AnnotationException("Multiple '@FilterDef' annotations define a filter named '" + name + "'");
        }
        if (filterDef.parameters().length == 0) {
            explicitParamJaMappings = Collections.emptyMap();
            parameterResolvers = Collections.emptyMap();
        } else {
            explicitParamJaMappings = new HashMap();
            parameterResolvers = new HashMap();
            for (ParamDef paramDef : filterDef.parameters()) {
                JdbcMapping jdbcMapping = FilterDefBinder.resolveFilterParamType(paramDef.type(), context);
                if (jdbcMapping == null) {
                    throw new MappingException(String.format(Locale.ROOT, "Unable to resolve type specified for parameter (%s) defined for @FilterDef (%s)", paramDef.name(), name));
                }
                explicitParamJaMappings.put(paramDef.name(), jdbcMapping);
                if (paramDef.resolver() == Supplier.class) continue;
                parameterResolvers.put(paramDef.name(), FilterDefBinder.resolveParamResolver(paramDef, context));
            }
        }
        FilterDefinition filterDefinition = new FilterDefinition(name, filterDef.defaultCondition(), explicitParamJaMappings, parameterResolvers, filterDef.autoEnabled());
        LOG.debugf("Binding filter definition: %s", filterDefinition.getFilterName());
        context.getMetadataCollector().addFilterDefinition(filterDefinition);
    }

    private static ManagedBean<? extends Supplier> resolveParamResolver(ParamDef paramDef, MetadataBuildingContext context) {
        Class<? extends Supplier> clazz = paramDef.resolver();
        assert (clazz != Supplier.class);
        ManagedBeanRegistry beanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        return beanRegistry.getBean(clazz, context.getBootstrapContext().getCustomTypeProducer());
    }

    private static JdbcMapping resolveFilterParamType(Class<?> type, MetadataBuildingContext context) {
        if (UserType.class.isAssignableFrom(type)) {
            return FilterDefBinder.resolveUserType(type, context);
        }
        if (AttributeConverter.class.isAssignableFrom(type)) {
            return FilterDefBinder.resolveAttributeConverter(type, context);
        }
        if (JavaType.class.isAssignableFrom(type)) {
            return FilterDefBinder.resolveJavaType(type, context);
        }
        return FilterDefBinder.resolveBasicType(type, context);
    }

    private static BasicType<Object> resolveBasicType(Class<?> type, final MetadataBuildingContext context) {
        final TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType jtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(type);
        if (jtd != null) {
            JdbcType jdbcType = jtd.getRecommendedJdbcType(new JdbcTypeIndicators(){

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return typeConfiguration;
                }

                @Override
                public int getPreferredSqlTypeCodeForBoolean() {
                    return context.getPreferredSqlTypeCodeForBoolean();
                }

                @Override
                public int getPreferredSqlTypeCodeForDuration() {
                    return context.getPreferredSqlTypeCodeForDuration();
                }

                @Override
                public int getPreferredSqlTypeCodeForUuid() {
                    return context.getPreferredSqlTypeCodeForUuid();
                }

                @Override
                public int getPreferredSqlTypeCodeForInstant() {
                    return context.getPreferredSqlTypeCodeForInstant();
                }

                @Override
                public int getPreferredSqlTypeCodeForArray() {
                    return context.getPreferredSqlTypeCodeForArray();
                }

                @Override
                public Dialect getDialect() {
                    return context.getMetadataCollector().getDatabase().getDialect();
                }
            });
            return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
        }
        return null;
    }

    private static JdbcMapping resolveUserType(Class<UserType<?>> userTypeClass, MetadataBuildingContext context) {
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        UserType<?> userType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(userTypeClass) : bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(userTypeClass).getBeanInstance();
        return new CustomType(userType, bootstrapContext.getTypeConfiguration());
    }

    private static JdbcMapping resolveAttributeConverter(Class<AttributeConverter<?, ?>> type, MetadataBuildingContext context) {
        BootstrapContext bootstrapContext = context.getBootstrapContext();
        ManagedBean<AttributeConverter<?, ?>> bean = bootstrapContext.getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(type);
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        JavaTypeRegistry jtdRegistry = typeConfiguration.getJavaTypeRegistry();
        ParameterizedType converterParameterizedType = GenericsHelper.extractParameterizedType(bean.getBeanClass());
        Class<?> domainJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[0]);
        Class<?> relationalJavaClass = GenericsHelper.extractClass(converterParameterizedType.getActualTypeArguments()[1]);
        JavaType domainJtd = jtdRegistry.resolveDescriptor(domainJavaClass);
        JavaType relationalJtd = jtdRegistry.resolveDescriptor(relationalJavaClass);
        JavaType converterJtd = jtdRegistry.resolveDescriptor(bean.getBeanClass());
        JpaAttributeConverterImpl valueConverter = new JpaAttributeConverterImpl(bean, converterJtd, domainJtd, relationalJtd);
        return new ConvertedBasicTypeImpl("converted::" + valueConverter.getConverterJavaType().getTypeName(), String.format("BasicType adapter for AttributeConverter<%s,%s>", domainJtd.getTypeName(), relationalJtd.getTypeName()), relationalJtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators()), valueConverter);
    }

    private static JdbcMapping resolveJavaType(Class<JavaType<?>> type, MetadataBuildingContext context) {
        TypeConfiguration typeConfiguration = context.getBootstrapContext().getTypeConfiguration();
        JavaType<?> jtd = FilterDefBinder.getJavaType(type, context, typeConfiguration);
        JdbcType jdbcType = jtd.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        return typeConfiguration.getBasicTypeRegistry().resolve(jtd, jdbcType);
    }

    private static JavaType<?> getJavaType(Class<JavaType<?>> javaTypeClass, MetadataBuildingContext context, TypeConfiguration typeConfiguration) {
        JavaType registeredJtd = typeConfiguration.getJavaTypeRegistry().findDescriptor(javaTypeClass);
        if (registeredJtd != null) {
            return registeredJtd;
        }
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
        }
        return context.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(javaTypeClass).getBeanInstance();
    }

    public static void bindFilterDefs(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        FilterDef filterDef = (FilterDef)annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs filterDefs = BinderHelper.getOverridableAnnotation(annotatedElement, FilterDefs.class, context);
        if (filterDef != null) {
            FilterDefBinder.bindFilterDef(filterDef, context);
        }
        if (filterDefs != null) {
            for (FilterDef def : filterDefs.value()) {
                FilterDefBinder.bindFilterDef(def, context);
            }
        }
    }
}

