/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.spi.ManagedBean;

public class FilterDefinition
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String filterName;
    private final @UnknownKeyFor @NonNull @Initialized String defaultFilterCondition;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings = new HashMap<String, JdbcMapping>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ManagedBean<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Supplier>> parameterResolverMap = new HashMap<String, ManagedBean<? extends Supplier>>();
    private final @UnknownKeyFor @NonNull @Initialized boolean autoEnabled;

    public FilterDefinition(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String defaultCondition, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings) {
        this(name, defaultCondition, explicitParamJaMappings, Collections.emptyMap(), false);
    }

    public FilterDefinition(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String defaultCondition, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ManagedBean<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Supplier>> parameterResolverMap, @UnknownKeyFor @NonNull @Initialized boolean autoEnabled) {
        this.filterName = name;
        this.defaultFilterCondition = defaultCondition;
        if (explicitParamJaMappings != null) {
            this.explicitParamJaMappings.putAll(explicitParamJaMappings);
        }
        if (parameterResolverMap != null) {
            this.parameterResolverMap.putAll(parameterResolverMap);
        }
        this.autoEnabled = autoEnabled;
    }

    public @UnknownKeyFor @NonNull @Initialized String getFilterName() {
        return this.filterName;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getParameterNames() {
        Set<String> keys = this.explicitParamJaMappings.keySet();
        return keys;
    }

    public @Nullable @UnknownKeyFor @Initialized JdbcMapping getParameterJdbcMapping(@UnknownKeyFor @NonNull @Initialized String parameterName) {
        return this.explicitParamJaMappings.get(parameterName);
    }

    public @Nullable @UnknownKeyFor @Initialized Supplier getParameterResolver(@UnknownKeyFor @NonNull @Initialized String parameterName) {
        ManagedBean<? extends Supplier> resolver = this.parameterResolverMap.get(parameterName);
        return resolver == null ? null : resolver.getBeanInstance();
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultFilterCondition() {
        return this.defaultFilterCondition;
    }

    public @UnknownKeyFor @NonNull @Initialized Object processArgument(@UnknownKeyFor @NonNull @Initialized Object value) {
        return value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAutoEnabled() {
        return this.autoEnabled;
    }
}

