/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.UnknownFilterException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.cfgxml.spi.CfgXmlAccessService;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.model.relational.internal.SqlStringGenerationContextImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.cfg.internal.DomainDataRegionConfigImpl;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.context.internal.JTASessionContext;
import org.hibernate.context.internal.ManagedSessionContext;
import org.hibernate.context.internal.ThreadLocalSessionContext;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.generator.Generator;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.internal.CoordinatingEntityNameResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.internal.FastSessionServices;
import org.hibernate.internal.FetchProfileHelper;
import org.hibernate.internal.QueryParameterBindingTypeResolverImpl;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryObserverChain;
import org.hibernate.internal.SessionFactoryRegistry;
import org.hibernate.internal.SessionImpl;
import org.hibernate.internal.SessionOwnerBehavior;
import org.hibernate.internal.StatelessSessionImpl;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.ExceptionMapperLegacyJpaImpl;
import org.hibernate.jpa.internal.PersistenceUnitUtilImpl;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.metamodel.internal.RuntimeMetamodelsImpl;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.internal.MappingMetamodelImpl;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.SessionFactoryBasedWrapperOptions;
import org.hibernate.procedure.spi.ProcedureCallImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.internal.QueryEngineImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.sql.spi.NativeQueryImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.relational.SchemaManager;
import org.hibernate.relational.internal.SchemaManagerImpl;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.ExceptionMapper;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistryFactory;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SessionFactoryImpl
extends QueryParameterBindingTypeResolverImpl
implements SessionFactoryImplementor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SessionFactoryImpl.class);
    private final String name;
    private final String uuid;
    private volatile transient Status status = Status.OPEN;
    private final transient SessionFactoryObserverChain observer = new SessionFactoryObserverChain();
    private final transient SessionFactoryOptions sessionFactoryOptions;
    private final transient Map<String, Object> settings;
    private final transient SessionFactoryServiceRegistry serviceRegistry;
    private final transient EventEngine eventEngine;
    private final transient JdbcServices jdbcServices;
    private final transient SqlStringGenerationContext sqlStringGenerationContext;
    private final transient RuntimeMetamodelsImplementor runtimeMetamodels;
    private final PersistenceUnitUtil jpaPersistenceUnitUtil;
    private final transient CacheImplementor cacheAccess;
    private final transient QueryEngine queryEngine;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient Map<String, Generator> identifierGenerators;
    private final transient Map<String, FilterDefinition> filters;
    private final transient Collection<FilterDefinition> autoEnabledFilters = new HashSet<FilterDefinition>();
    private final transient Map<String, FetchProfile> fetchProfiles;
    private final transient JavaType<Object> tenantIdentifierJavaType;
    private final transient FastSessionServices fastSessionServices;
    private final transient WrapperOptions wrapperOptions;
    private final transient SessionBuilderImpl defaultSessionOpenOptions;
    private final transient SessionBuilderImpl temporarySessionOpenOptions;
    private final transient StatelessSessionBuilder defaultStatelessOptions;
    private final transient EntityNameResolver entityNameResolver;
    private final transient SchemaManager schemaManager;
    private transient StatisticsImplementor statistics;

    @Deprecated(since="6.2", forRemoval=true)
    public SessionFactoryImpl(MetadataImplementor bootMetamodel, SessionFactoryOptions options) {
        this(bootMetamodel, options, bootMetamodel.getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext());
    }

    public SessionFactoryImpl(MetadataImplementor bootMetamodel, SessionFactoryOptions options, BootstrapContext bootstrapContext) {
        LOG.debug("Building session factory");
        TypeConfiguration typeConfiguration = bootstrapContext.getTypeConfiguration();
        this.sessionFactoryOptions = options;
        this.serviceRegistry = SessionFactoryImpl.getServiceRegistry(options, this);
        this.eventEngine = new EventEngine(bootMetamodel, this);
        bootMetamodel.initSessionFactory(this);
        this.name = SessionFactoryImpl.getSessionFactoryName(options, this.serviceRegistry);
        this.uuid = options.getUuid();
        this.jdbcServices = this.serviceRegistry.requireService(JdbcServices.class);
        this.settings = SessionFactoryImpl.getSettings(options, this.serviceRegistry);
        this.maskOutSensitiveInformation(this.settings);
        this.deprecationCheck(this.settings);
        LOG.debugf("Instantiating SessionFactory with settings: %s", this.settings);
        this.logIfEmptyCompositesEnabled(this.settings);
        this.sqlStringGenerationContext = SessionFactoryImpl.createSqlStringGenerationContext(bootMetamodel, options, this.jdbcServices);
        this.cacheAccess = this.serviceRegistry.getService(CacheImplementor.class);
        this.jpaPersistenceUnitUtil = new PersistenceUnitUtilImpl(this);
        for (SessionFactoryObserver sessionFactoryObserver : options.getSessionFactoryObservers()) {
            this.observer.addObserver(sessionFactoryObserver);
        }
        this.filters = new HashMap<String, FilterDefinition>(bootMetamodel.getFilterDefinitions());
        LOG.debugf("Session factory constructed with filter configurations : %s", this.filters);
        FilterDefinition tenantFilter = this.filters.get("_tenantId");
        if (tenantFilter == null) {
            this.tenantIdentifierJavaType = options.getDefaultTenantIdentifierJavaType();
        } else {
            JdbcMapping jdbcMapping = tenantFilter.getParameterJdbcMapping("tenantId");
            assert (jdbcMapping != null);
            this.tenantIdentifierJavaType = jdbcMapping.getJavaTypeDescriptor();
        }
        for (Map.Entry<String, FilterDefinition> filterEntry : this.filters.entrySet()) {
            if (!filterEntry.getValue().isAutoEnabled()) continue;
            this.autoEnabledFilters.add(filterEntry.getValue());
        }
        this.entityNameResolver = new CoordinatingEntityNameResolver(this, this.getInterceptor());
        this.schemaManager = new SchemaManagerImpl(this, bootMetamodel);
        IntegratorObserver integratorObserver = new IntegratorObserver();
        this.observer.addObserver(integratorObserver);
        try {
            this.integrate(bootMetamodel, bootstrapContext, integratorObserver);
            this.identifierGenerators = SessionFactoryImpl.createGenerators(this.jdbcServices, this.sqlStringGenerationContext, bootMetamodel, bootstrapContext);
            bootMetamodel.orderColumns(false);
            bootMetamodel.validate();
            this.primeSecondLevelCacheRegions(bootMetamodel);
            this.queryEngine = QueryEngineImpl.from(this, bootMetamodel);
            RuntimeMetamodelsImpl runtimeMetamodelsImpl = new RuntimeMetamodelsImpl();
            this.runtimeMetamodels = runtimeMetamodelsImpl;
            MappingMetamodelImpl mappingMetamodelImpl = new MappingMetamodelImpl(typeConfiguration, this.serviceRegistry);
            runtimeMetamodelsImpl.setMappingMetamodel(mappingMetamodelImpl);
            this.fastSessionServices = new FastSessionServices(this);
            this.initializeMappingModel(mappingMetamodelImpl, bootstrapContext, bootMetamodel, options);
            runtimeMetamodelsImpl.setJpaMetamodel(mappingMetamodelImpl.getJpaMetamodel());
            this.fetchProfiles = FetchProfileHelper.getFetchProfiles(bootMetamodel, this.runtimeMetamodels);
            this.defaultSessionOpenOptions = this.createDefaultSessionOpenOptionsIfPossible();
            this.temporarySessionOpenOptions = this.defaultSessionOpenOptions == null ? null : this.buildTemporarySessionOpenOptions();
            this.defaultStatelessOptions = this.defaultSessionOpenOptions == null ? null : this.withStatelessOptions();
            this.wrapperOptions = new SessionFactoryBasedWrapperOptions(this);
            this.currentSessionContext = this.buildCurrentSessionContext();
            typeConfiguration.scope(this);
            this.observer.sessionFactoryCreated(this);
            bootstrapContext.getReflectionManager().reset();
        }
        catch (Exception e) {
            this.disintegrate(e, integratorObserver);
            try {
                this.close();
            }
            catch (Exception closeException) {
                LOG.debugf("Eating error closing the SessionFactory after a failed attempt to start it", new Object[0]);
            }
            throw e;
        }
        LOG.debug("Instantiated SessionFactory");
    }

    private void deprecationCheck(Map<String, Object> settings) {
        Iterator<String> iterator = settings.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            switch (s = iterator.next()) {
                case "hibernate.hql.bulk_id_strategy.global_temporary.create_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.global_temporary.create_tables", "hibernate.query.mutation_strategy.global_temporary.create_tables");
                }
                case "hibernate.hql.bulk_id_strategy.global_temporary.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.global_temporary.drop_tables", "hibernate.query.mutation_strategy.global_temporary.drop_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.create_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.create_tables", "hibernate.query.mutation_strategy.persistent.create_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.drop_tables", "hibernate.query.mutation_strategy.persistent.drop_tables");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.schema": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.schema", "hibernate.query.mutation_strategy.persistent.schema");
                }
                case "hibernate.hql.bulk_id_strategy.persistent.catalog": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.persistent.catalog", "hibernate.query.mutation_strategy.persistent.catalog");
                }
                case "hibernate.hql.bulk_id_strategy.local_temporary.drop_tables": {
                    DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.hql.bulk_id_strategy.local_temporary.drop_tables", "hibernate.query.mutation_strategy.local_temporary.drop_tables");
                }
            }
        }
    }

    private void initializeMappingModel(MappingMetamodelImpl mappingMetamodelImpl, BootstrapContext bootstrapContext, MetadataImplementor bootMetamodel, SessionFactoryOptions options) {
        TypeConfiguration typeConfiguration = mappingMetamodelImpl.getTypeConfiguration();
        mappingMetamodelImpl.finishInitialization(this.runtimeModelCreationContext(bootstrapContext, bootMetamodel, mappingMetamodelImpl, typeConfiguration, options));
    }

    private RuntimeModelCreationContext runtimeModelCreationContext(final BootstrapContext bootstrapContext, final MetadataImplementor bootMetamodel, final MappingMetamodelImplementor mappingMetamodel, final TypeConfiguration typeConfiguration, final SessionFactoryOptions options) {
        return new RuntimeModelCreationContext(){

            @Override
            public BootstrapContext getBootstrapContext() {
                return bootstrapContext;
            }

            @Override
            public SessionFactoryImplementor getSessionFactory() {
                return SessionFactoryImpl.this;
            }

            @Override
            public MetadataImplementor getBootModel() {
                return bootMetamodel;
            }

            @Override
            public MappingMetamodelImplementor getDomainModel() {
                return mappingMetamodel;
            }

            @Override
            public CacheImplementor getCache() {
                return SessionFactoryImpl.this.cacheAccess;
            }

            @Override
            public Map<String, Object> getSettings() {
                return SessionFactoryImpl.this.settings;
            }

            @Override
            public Dialect getDialect() {
                return SessionFactoryImpl.this.jdbcServices.getDialect();
            }

            @Override
            public SqmFunctionRegistry getFunctionRegistry() {
                return SessionFactoryImpl.this.queryEngine.getSqmFunctionRegistry();
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public SessionFactoryOptions getSessionFactoryOptions() {
                return options;
            }

            @Override
            public JdbcServices getJdbcServices() {
                return SessionFactoryImpl.this.jdbcServices;
            }

            @Override
            public SqlStringGenerationContext getSqlStringGenerationContext() {
                return SessionFactoryImpl.this.sqlStringGenerationContext;
            }

            @Override
            public ServiceRegistry getServiceRegistry() {
                return SessionFactoryImpl.this.serviceRegistry;
            }
        };
    }

    private static Map<String, Generator> createGenerators(JdbcServices jdbcServices, SqlStringGenerationContext sqlStringGenerationContext, MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext) {
        HashMap<String, Generator> generators = new HashMap<String, Generator>();
        bootMetamodel.getEntityBindings().stream().filter(model -> !model.isInherited()).forEach(model -> {
            Generator generator = model.getIdentifier().createGenerator(bootstrapContext.getIdentifierGeneratorFactory(), jdbcServices.getJdbcEnvironment().getDialect(), (RootClass)model);
            if (generator instanceof IdentifierGenerator) {
                IdentifierGenerator identifierGenerator = (IdentifierGenerator)generator;
                identifierGenerator.initialize(sqlStringGenerationContext);
                if (identifierGenerator.allowAssignedIdentifiers()) {
                    ((SimpleValue)model.getIdentifier()).setNullValue("undefined");
                }
            }
            generators.put(model.getEntityName(), generator);
        });
        return generators;
    }

    private static SqlStringGenerationContext createSqlStringGenerationContext(MetadataImplementor bootMetamodel, SessionFactoryOptions options, JdbcServices jdbcServices) {
        return SqlStringGenerationContextImpl.fromExplicit(jdbcServices.getJdbcEnvironment(), bootMetamodel.getDatabase(), options.getDefaultCatalog(), options.getDefaultSchema());
    }

    private static SessionFactoryServiceRegistry getServiceRegistry(SessionFactoryOptions options, SessionFactoryImplementor self) {
        return options.getServiceRegistry().requireService(SessionFactoryServiceRegistryFactory.class).buildServiceRegistry(self, options);
    }

    private void integrate(MetadataImplementor bootMetamodel, BootstrapContext bootstrapContext, IntegratorObserver integratorObserver) {
        for (Integrator integrator : this.serviceRegistry.requireService(IntegratorService.class).getIntegrators()) {
            integrator.integrate((Metadata)bootMetamodel, bootstrapContext, this);
            integratorObserver.integrators.add(integrator);
        }
    }

    private void disintegrate(Exception startupException, IntegratorObserver integratorObserver) {
        for (Integrator integrator : integratorObserver.integrators) {
            try {
                integrator.disintegrate(this, this.serviceRegistry);
            }
            catch (Throwable ex) {
                startupException.addSuppressed(ex);
            }
        }
        integratorObserver.integrators.clear();
    }

    private static Map<String, Object> getSettings(SessionFactoryOptions options, SessionFactoryServiceRegistry serviceRegistry) {
        Object reference;
        Map<String, Object> settings = serviceRegistry.requireService(ConfigurationService.class).getSettings();
        HashMap<String, Object> result = new HashMap<String, Object>(settings);
        if (!settings.containsKey("javax.persistence.validation.factory") && !settings.containsKey("jakarta.persistence.validation.factory") && (reference = options.getValidatorFactoryReference()) != null) {
            result.put("javax.persistence.validation.factory", reference);
            result.put("jakarta.persistence.validation.factory", reference);
        }
        return result;
    }

    private static String getSessionFactoryName(SessionFactoryOptions options, SessionFactoryServiceRegistry serviceRegistry) {
        CfgXmlAccessService cfgXmlAccessService;
        String sessionFactoryName = options.getSessionFactoryName();
        if (sessionFactoryName == null && (cfgXmlAccessService = serviceRegistry.requireService(CfgXmlAccessService.class)).getAggregatedConfig() != null) {
            return cfgXmlAccessService.getAggregatedConfig().getSessionFactoryName();
        }
        return sessionFactoryName;
    }

    private SessionBuilderImpl createDefaultSessionOpenOptionsIfPossible() {
        CurrentTenantIdentifierResolver<Object> currentTenantIdentifierResolver = this.getCurrentTenantIdentifierResolver();
        if (currentTenantIdentifierResolver == null) {
            return this.withOptions();
        }
        return null;
    }

    private SessionBuilderImpl buildTemporarySessionOpenOptions() {
        return this.withOptions().autoClose(false).flushMode(FlushMode.MANUAL).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_STATEMENT);
    }

    private void primeSecondLevelCacheRegions(MetadataImplementor mappingMetadata) {
        Set<DomainDataRegionConfig> regionConfigs;
        AccessType accessType;
        ConcurrentHashMap<String, DomainDataRegionConfigImpl.Builder> regionConfigBuilders = new ConcurrentHashMap<String, DomainDataRegionConfigImpl.Builder>();
        for (PersistentClass bootEntityDescriptor : mappingMetadata.getEntityBindings()) {
            accessType = AccessType.fromExternalName(bootEntityDescriptor.getCacheConcurrencyStrategy());
            if (accessType == null) continue;
            if (bootEntityDescriptor.isCached()) {
                regionConfigBuilders.computeIfAbsent(bootEntityDescriptor.getRootClass().getCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addEntityConfig(bootEntityDescriptor, accessType);
            }
            if (!(bootEntityDescriptor instanceof RootClass) || !bootEntityDescriptor.hasNaturalId() || bootEntityDescriptor.getNaturalIdCacheRegionName() == null) continue;
            regionConfigBuilders.computeIfAbsent(bootEntityDescriptor.getNaturalIdCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addNaturalIdConfig((RootClass)bootEntityDescriptor, accessType);
        }
        for (org.hibernate.mapping.Collection collection : mappingMetadata.getCollectionBindings()) {
            accessType = AccessType.fromExternalName(collection.getCacheConcurrencyStrategy());
            if (accessType == null) continue;
            regionConfigBuilders.computeIfAbsent(collection.getCacheRegionName(), DomainDataRegionConfigImpl.Builder::new).addCollectionConfig(collection, accessType);
        }
        if (regionConfigBuilders.isEmpty()) {
            regionConfigs = Collections.emptySet();
        } else {
            regionConfigs = new HashSet();
            for (DomainDataRegionConfigImpl.Builder builder : regionConfigBuilders.values()) {
                regionConfigs.add(builder.build());
            }
        }
        this.getCache().prime(regionConfigs);
    }

    @Override
    public SessionImplementor openSession() throws HibernateException {
        if (this.defaultSessionOpenOptions != null) {
            return this.defaultSessionOpenOptions.openSession();
        }
        return this.withOptions().openSession();
    }

    @Override
    public SessionImpl openTemporarySession() throws HibernateException {
        if (this.temporarySessionOpenOptions != null) {
            return this.temporarySessionOpenOptions.openSession();
        }
        return this.buildTemporarySessionOpenOptions().openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public SessionBuilderImpl withOptions() {
        return new SessionBuilderImpl(this);
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return new StatelessSessionBuilderImpl(this);
    }

    @Override
    public StatelessSession openStatelessSession() {
        if (this.defaultStatelessOptions != null) {
            return this.defaultStatelessOptions.openStatelessSession();
        }
        return this.withStatelessOptions().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return this.withStatelessOptions().connection(connection).openStatelessSession();
    }

    @Override
    public void addObserver(SessionFactoryObserver observer) {
        this.observer.addObserver(observer);
    }

    public Map<String, Object> getProperties() {
        this.validateNotClosed();
        return this.settings;
    }

    protected void validateNotClosed() {
        if (this.status == Status.CLOSED) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.runtimeMetamodels.getMappingMetamodel().getTypeConfiguration();
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public EventEngine getEventEngine() {
        return this.eventEngine;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public SqlStringGenerationContext getSqlStringGenerationContext() {
        return this.sqlStringGenerationContext;
    }

    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    @Deprecated
    public SessionFactoryImplementor.DeserializationResolver<?> getDeserializationResolver() {
        return () -> SessionFactoryRegistry.INSTANCE.findSessionFactory(this.uuid, this.name);
    }

    @Override
    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.getJpaMetamodel().findEntityGraphsByJavaType(entityClass);
    }

    public Session createEntityManager() {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, null);
    }

    private <K, V> Session buildEntityManager(SynchronizationType synchronizationType, Map<K, V> map) {
        V tenantIdHint;
        assert (this.status != Status.CLOSED);
        SessionBuilderImplementor builder = this.withOptions();
        builder.autoJoinTransactions(synchronizationType == SynchronizationType.SYNCHRONIZED);
        if (map != null && (tenantIdHint = map.get("org.hibernate.tenantId")) != null) {
            builder = (SessionBuilderImplementor)builder.tenantIdentifier(tenantIdHint);
        }
        Session session = builder.openSession();
        if (map != null) {
            for (Map.Entry<K, V> o : map.entrySet()) {
                String sKey;
                K key = o.getKey();
                if (!(key instanceof String) || "org.hibernate.tenantId".equals(sKey = (String)key)) continue;
                session.setProperty(sKey, o.getValue());
            }
        }
        return session;
    }

    public Session createEntityManager(Map map) {
        this.validateNotClosed();
        return this.buildEntityManager(SynchronizationType.SYNCHRONIZED, map);
    }

    public Session createEntityManager(SynchronizationType synchronizationType) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, null);
    }

    private void errorIfResourceLocalDueToExplicitSynchronizationType() {
        if (!this.getServiceRegistry().requireService(TransactionCoordinatorBuilder.class).isJta()) {
            throw new IllegalStateException("Illegal attempt to specify a SynchronizationType when building an EntityManager from an EntityManagerFactory defined as RESOURCE_LOCAL (as opposed to JTA)");
        }
    }

    public Session createEntityManager(SynchronizationType synchronizationType, Map map) {
        this.validateNotClosed();
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.buildEntityManager(synchronizationType, map);
    }

    @Override
    public NodeBuilder getCriteriaBuilder() {
        this.validateNotClosed();
        return this.queryEngine.getCriteriaBuilder();
    }

    @Override
    public MetamodelImplementor getMetamodel() {
        this.validateNotClosed();
        return (MetamodelImplementor)((Object)this.runtimeMetamodels.getMappingMetamodel());
    }

    public boolean isOpen() {
        return this.status != Status.CLOSED;
    }

    @Override
    public RootGraphImplementor<?> findEntityGraphByName(String name) {
        return this.getJpaMetamodel().findEntityGraphByName(name);
    }

    @Override
    public String bestGuessEntityName(Object object) {
        LazyInitializer initializer = HibernateProxy.extractLazyInitializer(object);
        if (initializer != null) {
            if (initializer.isUninitialized()) {
                return initializer.getEntityName();
            }
            object = initializer.getImplementation();
        }
        return this.entityNameResolver.resolveEntityName(object);
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.sessionFactoryOptions;
    }

    public Interceptor getInterceptor() {
        return this.sessionFactoryOptions.getInterceptor();
    }

    @Override
    public Reference getReference() {
        LOG.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.getUuid()), SessionFactoryRegistry.ObjectFactoryImpl.class.getName(), null);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getIdentifierPropertyName();
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)((Object)this.runtimeMetamodels.getMappingMetamodel().getCollectionDescriptor(roleName));
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.runtimeMetamodels.getMappingMetamodel().getEntityDescriptor(className).getPropertyType(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HibernateException {
        SessionFactoryImpl sessionFactoryImpl = this;
        synchronized (sessionFactoryImpl) {
            if (this.status != Status.OPEN) {
                if (this.getSessionFactoryOptions().getJpaCompliance().isJpaClosedComplianceEnabled()) {
                    throw new IllegalStateException("EntityManagerFactory is already closed");
                }
                LOG.trace("Already closed");
                return;
            }
            this.status = Status.CLOSING;
        }
        try {
            LOG.closing();
            this.observer.sessionFactoryClosing(this);
            if (this.cacheAccess != null) {
                this.cacheAccess.close();
            }
            if (this.runtimeMetamodels != null && this.runtimeMetamodels.getMappingMetamodel() != null) {
                JdbcConnectionAccess jdbcConnectionAccess = this.jdbcServices.getBootstrapJdbcConnectionAccess();
                this.runtimeMetamodels.getMappingMetamodel().forEachEntityDescriptor(entityPersister -> {
                    if (entityPersister.getSqmMultiTableMutationStrategy() != null) {
                        entityPersister.getSqmMultiTableMutationStrategy().release(this, jdbcConnectionAccess);
                    }
                    if (entityPersister.getSqmMultiTableInsertStrategy() != null) {
                        entityPersister.getSqmMultiTableInsertStrategy().release(this, jdbcConnectionAccess);
                    }
                });
                ((MappingMetamodelImpl)this.runtimeMetamodels.getMappingMetamodel()).close();
            }
            if (this.queryEngine != null) {
                this.queryEngine.close();
            }
            if (this.eventEngine != null) {
                this.eventEngine.stop();
            }
        }
        finally {
            this.status = Status.CLOSED;
        }
        this.observer.sessionFactoryClosed(this);
        this.serviceRegistry.destroy();
    }

    @Override
    public CacheImplementor getCache() {
        this.validateNotClosed();
        return this.cacheAccess;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        this.validateNotClosed();
        return this.jpaPersistenceUnitUtil;
    }

    public void addNamedQuery(String name, Query query) {
        this.validateNotClosed();
        NamedObjectRepository namedObjectRepository = this.getQueryEngine().getNamedObjectRepository();
        try {
            ProcedureCallImplementor unwrapped = (ProcedureCallImplementor)query.unwrap(ProcedureCallImplementor.class);
            if (unwrapped != null) {
                namedObjectRepository.registerCallableQueryMemento(name, unwrapped.toMemento(name));
                return;
            }
        }
        catch (PersistenceException unwrapped) {
            // empty catch block
        }
        try {
            QueryImplementor hibernateQuery = (QueryImplementor)query.unwrap(QueryImplementor.class);
            if (hibernateQuery != null) {
                if (hibernateQuery instanceof NativeQueryImplementor) {
                    namedObjectRepository.registerNativeQueryMemento(name, ((NativeQueryImplementor)hibernateQuery).toMemento(name));
                } else {
                    NamedQueryMemento namedQueryMemento = ((SqmQueryImplementor)hibernateQuery).toMemento(name);
                    namedObjectRepository.registerSqmQueryMemento(name, (NamedSqmQueryMemento)namedQueryMemento);
                }
                return;
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        throw new PersistenceException(String.format("Unsure how to properly unwrap given Query [%s] as basis for named query", query));
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        if (type.isInstance(this.serviceRegistry)) {
            return type.cast(this.serviceRegistry);
        }
        if (type.isInstance(this.jdbcServices)) {
            return type.cast(this.jdbcServices);
        }
        if (type.isInstance(this.cacheAccess)) {
            return type.cast(this.cacheAccess);
        }
        if (type.isInstance(this.runtimeMetamodels)) {
            return type.cast(this.runtimeMetamodels);
        }
        if (type.isInstance(this.runtimeMetamodels.getJpaMetamodel())) {
            return type.cast(this.runtimeMetamodels.getJpaMetamodel());
        }
        if (type.isInstance(this.runtimeMetamodels.getMappingMetamodel())) {
            return type.cast(this.runtimeMetamodels.getMappingMetamodel());
        }
        if (type.isInstance(this.queryEngine)) {
            return type.cast(this.queryEngine);
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as '" + type.getName() + "'");
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getMappingMetamodel().addNamedEntityGraph(graphName, (RootGraphImplementor)entityGraph);
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public StatisticsImplementor getStatistics() {
        if (this.statistics == null) {
            this.statistics = this.serviceRegistry.requireService(StatisticsImplementor.class);
        }
        return this.statistics;
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = this.filters.get(filterName);
        if (def == null) {
            throw new UnknownFilterException(filterName);
        }
        return def;
    }

    @Override
    public Collection<FilterDefinition> getAutoEnabledFilters() {
        return this.autoEnabledFilters;
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return this.fetchProfiles.containsKey(name);
    }

    @Override
    public Set<String> getDefinedFilterNames() {
        return Collections.unmodifiableSet(this.filters.keySet());
    }

    @Override
    public Set<String> getDefinedFetchProfileNames() {
        return Collections.unmodifiableSet(this.fetchProfiles.keySet());
    }

    @Override
    @Deprecated
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return (IdentifierGenerator)this.getGenerator(rootEntityName);
    }

    @Override
    @Deprecated
    public Generator getGenerator(String rootEntityName) {
        return this.identifierGenerators.get(rootEntityName);
    }

    private boolean canAccessTransactionManager() {
        try {
            return this.serviceRegistry.requireService(JtaPlatform.class).retrieveTransactionManager() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String sessionContextType = (String)this.settings.get("hibernate.current_session_context_class");
        if (sessionContextType == null) {
            if (this.canAccessTransactionManager()) {
                return this.createSessionContext("jta");
            }
            return null;
        }
        return this.createSessionContext(sessionContextType);
    }

    private CurrentSessionContext createSessionContext(String sessionContextType) {
        switch (sessionContextType) {
            case "jta": {
                return new JTASessionContext(this);
            }
            case "thread": {
                return new ThreadLocalSessionContext(this);
            }
            case "managed": {
                return new ManagedSessionContext(this);
            }
        }
        try {
            return (CurrentSessionContext)this.serviceRegistry.requireService(ClassLoaderService.class).classForName(sessionContextType).getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            LOG.unableToConstructCurrentSessionContext(sessionContextType, t);
            return null;
        }
    }

    @Override
    public RuntimeMetamodelsImplementor getRuntimeMetamodels() {
        return this.runtimeMetamodels;
    }

    @Override
    public JpaMetamodelImplementor getJpaMetamodel() {
        return this.runtimeMetamodels.getJpaMetamodel();
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.getSessionFactoryOptions().getMaximumFetchDepth();
    }

    @Override
    public ServiceRegistryImplementor getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.sessionFactoryOptions.getEntityNotFoundDelegate();
    }

    @Override
    public FetchProfile getFetchProfile(String name) {
        return this.fetchProfiles.get(name);
    }

    @Deprecated
    public static Interceptor configuredInterceptor(Interceptor interceptor, SessionFactoryOptions options) {
        return SessionFactoryImpl.configuredInterceptor(interceptor, false, options);
    }

    public static Interceptor configuredInterceptor(Interceptor interceptor, boolean explicitNoInterceptor, SessionFactoryOptions options) {
        if (interceptor != null && interceptor != EmptyInterceptor.INSTANCE) {
            return interceptor;
        }
        Interceptor optionsInterceptor = options.getInterceptor();
        if (optionsInterceptor != null && optionsInterceptor != EmptyInterceptor.INSTANCE) {
            return optionsInterceptor;
        }
        if (explicitNoInterceptor) {
            return null;
        }
        Supplier<? extends Interceptor> statelessInterceptorImplementorSupplier = options.getStatelessInterceptorImplementorSupplier();
        if (statelessInterceptorImplementorSupplier != null) {
            return statelessInterceptorImplementorSupplier.get();
        }
        return null;
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.getSessionFactoryOptions().getCustomEntityDirtinessStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver<Object> getCurrentTenantIdentifierResolver() {
        return this.getSessionFactoryOptions().getCurrentTenantIdentifierResolver();
    }

    @Override
    public JavaType<Object> getTenantIdentifierJavaType() {
        return this.tenantIdentifierJavaType;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Serializing: %s", this.getUuid());
        }
        out.defaultWriteObject();
        LOG.trace("Serialized");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing");
        in.defaultReadObject();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Deserialized: %s", this.getUuid());
        }
    }

    private Object readResolve() throws InvalidObjectException {
        LOG.trace("Resolving serialized SessionFactory");
        return SessionFactoryImpl.locateSessionFactoryOnDeserialization(this.getUuid(), this.name);
    }

    private static SessionFactory locateSessionFactoryOnDeserialization(String uuid, String name) throws InvalidObjectException {
        SessionFactoryImplementor namedResult;
        SessionFactoryImplementor uuidResult = SessionFactoryRegistry.INSTANCE.getSessionFactory(uuid);
        if (uuidResult != null) {
            LOG.debugf("Resolved SessionFactory by UUID [%s]", uuid);
            return uuidResult;
        }
        if (name != null && (namedResult = SessionFactoryRegistry.INSTANCE.getNamedSessionFactory(name)) != null) {
            LOG.debugf("Resolved SessionFactory by name [%s]", name);
            return namedResult;
        }
        throw new InvalidObjectException("Could not find a SessionFactory [uuid=" + uuid + ",name=" + name + "]");
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.getUuid());
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException {
        LOG.trace("Deserializing SessionFactory from Session");
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = isNamed ? ois.readUTF() : null;
        return (SessionFactoryImpl)SessionFactoryImpl.locateSessionFactoryOnDeserialization(uuid, name);
    }

    private void maskOutSensitiveInformation(Map<String, Object> props) {
        this.maskOutIfSet(props, "javax.persistence.jdbc.user");
        this.maskOutIfSet(props, "javax.persistence.jdbc.password");
        this.maskOutIfSet(props, "jakarta.persistence.jdbc.user");
        this.maskOutIfSet(props, "jakarta.persistence.jdbc.password");
        this.maskOutIfSet(props, "hibernate.connection.username");
        this.maskOutIfSet(props, "hibernate.connection.password");
    }

    private void maskOutIfSet(Map<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    private void logIfEmptyCompositesEnabled(Map<String, Object> props) {
        boolean isEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", props);
        if (isEmptyCompositesEnabled) {
            LOG.emptyCompositesEnabled();
        }
    }

    @Override
    public FastSessionServices getFastSessionServices() {
        return this.fastSessionServices;
    }

    @Override
    public WrapperOptions getWrapperOptions() {
        return this.wrapperOptions;
    }

    @Override
    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    private static enum Status {
        OPEN,
        CLOSING,
        CLOSED;

    }

    public static class StatelessSessionBuilderImpl
    implements StatelessSessionBuilder,
    SessionCreationOptions {
        private final SessionFactoryImpl sessionFactory;
        private StatementInspector statementInspector;
        private Connection connection;
        private Object tenantIdentifier;

        public StatelessSessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            this.statementInspector = sessionFactory.getSessionFactoryOptions().getStatementInspector();
            CurrentTenantIdentifierResolver<Object> tenantIdentifierResolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (tenantIdentifierResolver != null) {
                this.tenantIdentifier = tenantIdentifierResolver.resolveCurrentTenantIdentifier();
            }
        }

        @Override
        public StatelessSession openStatelessSession() {
            return new StatelessSessionImpl(this.sessionFactory, this);
        }

        @Override
        public StatelessSessionBuilder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StatelessSessionBuilder tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public StatelessSessionBuilder tenantIdentifier(Object tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public StatelessSessionBuilder statementInspector(StatementInspector statementInspector) {
            this.statementInspector = statementInspector;
            return this;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return true;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return FlushMode.ALWAYS;
        }

        @Override
        public boolean isSubselectFetchEnabled() {
            return false;
        }

        @Override
        public int getDefaultBatchFetchSize() {
            return -1;
        }

        @Override
        public boolean shouldAutoClose() {
            return false;
        }

        @Override
        public boolean shouldAutoClear() {
            return false;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(EmptyInterceptor.INSTANCE, false, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.statementInspector;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.sessionFactory.getSessionFactoryOptions().getPhysicalConnectionHandlingMode();
        }

        @Override
        public String getTenantIdentifier() {
            if (this.tenantIdentifier == null) {
                return null;
            }
            return this.sessionFactory.getTenantIdentifierJavaType().toString(this.tenantIdentifier);
        }

        @Override
        public Object getTenantIdentifierValue() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }

        @Override
        public List<SessionEventListener> getCustomSessionEventListener() {
            return null;
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return null;
        }
    }

    public static class SessionBuilderImpl
    implements SessionBuilderImplementor,
    SessionCreationOptions {
        private static final Logger log = CoreLogging.logger(SessionBuilderImpl.class);
        private final SessionFactoryImpl sessionFactory;
        private Interceptor interceptor;
        private StatementInspector statementInspector;
        private Connection connection;
        private PhysicalConnectionHandlingMode connectionHandlingMode;
        private boolean autoJoinTransactions = true;
        private FlushMode flushMode;
        private boolean autoClose;
        private boolean autoClear;
        private Object tenantIdentifier;
        private TimeZone jdbcTimeZone;
        private boolean explicitNoInterceptor;
        private final int defaultBatchFetchSize;
        private final boolean subselectFetchEnabled;
        private List<SessionEventListener> listeners;
        private final SessionOwnerBehavior sessionOwnerBehavior = SessionOwnerBehavior.LEGACY_NATIVE;

        public SessionBuilderImpl(SessionFactoryImpl sessionFactory) {
            this.sessionFactory = sessionFactory;
            SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
            this.statementInspector = sessionFactoryOptions.getStatementInspector();
            this.connectionHandlingMode = sessionFactoryOptions.getPhysicalConnectionHandlingMode();
            this.autoClose = sessionFactoryOptions.isAutoCloseSessionEnabled();
            this.defaultBatchFetchSize = sessionFactoryOptions.getDefaultBatchFetchSize();
            this.subselectFetchEnabled = sessionFactoryOptions.isSubselectFetchEnabled();
            CurrentTenantIdentifierResolver<Object> currentTenantIdentifierResolver = sessionFactory.getCurrentTenantIdentifierResolver();
            if (currentTenantIdentifierResolver != null) {
                this.tenantIdentifier = currentTenantIdentifierResolver.resolveCurrentTenantIdentifier();
            }
            this.jdbcTimeZone = sessionFactoryOptions.getJdbcTimeZone();
        }

        @Override
        public ExceptionMapper getExceptionMapper() {
            return this.sessionOwnerBehavior == SessionOwnerBehavior.LEGACY_JPA ? ExceptionMapperLegacyJpaImpl.INSTANCE : null;
        }

        @Override
        public boolean shouldAutoJoinTransactions() {
            return this.autoJoinTransactions;
        }

        @Override
        public FlushMode getInitialSessionFlushMode() {
            return this.flushMode;
        }

        @Override
        public boolean isSubselectFetchEnabled() {
            return this.subselectFetchEnabled;
        }

        @Override
        public int getDefaultBatchFetchSize() {
            return this.defaultBatchFetchSize;
        }

        @Override
        public boolean shouldAutoClose() {
            return this.autoClose;
        }

        @Override
        public boolean shouldAutoClear() {
            return this.autoClear;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public Interceptor getInterceptor() {
            return SessionFactoryImpl.configuredInterceptor(this.interceptor, this.explicitNoInterceptor, this.sessionFactory.getSessionFactoryOptions());
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.statementInspector;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public String getTenantIdentifier() {
            if (this.tenantIdentifier == null) {
                return null;
            }
            return this.sessionFactory.getTenantIdentifierJavaType().toString(this.tenantIdentifier);
        }

        @Override
        public Object getTenantIdentifierValue() {
            return this.tenantIdentifier;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.jdbcTimeZone;
        }

        @Override
        public List<SessionEventListener> getCustomSessionEventListener() {
            return this.listeners;
        }

        @Override
        public SessionImpl openSession() {
            log.tracef("Opening Hibernate Session.  tenant=%s", this.tenantIdentifier);
            return new SessionImpl(this.sessionFactory, this);
        }

        @Override
        public SessionBuilderImpl interceptor(Interceptor interceptor) {
            this.interceptor = interceptor;
            this.explicitNoInterceptor = false;
            return this;
        }

        @Override
        public SessionBuilderImpl noInterceptor() {
            this.interceptor = EmptyInterceptor.INSTANCE;
            this.explicitNoInterceptor = true;
            return this;
        }

        @Override
        public SessionBuilderImpl statementInspector(StatementInspector statementInspector) {
            this.statementInspector = statementInspector;
            return this;
        }

        @Override
        public SessionBuilderImpl connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public SessionBuilderImpl connectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
            this.connectionHandlingMode = connectionHandlingMode;
            return this;
        }

        @Override
        public SessionBuilderImpl autoJoinTransactions(boolean autoJoinTransactions) {
            this.autoJoinTransactions = autoJoinTransactions;
            return this;
        }

        @Override
        public SessionBuilderImpl autoClose(boolean autoClose) {
            this.autoClose = autoClose;
            return this;
        }

        @Override
        public SessionBuilderImpl autoClear(boolean autoClear) {
            this.autoClear = autoClear;
            return this;
        }

        @Override
        public SessionBuilderImpl flushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
            return this;
        }

        @Override
        public SessionBuilderImpl tenantIdentifier(String tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public SessionBuilderImpl tenantIdentifier(Object tenantIdentifier) {
            this.tenantIdentifier = tenantIdentifier;
            return this;
        }

        @Override
        public SessionBuilderImpl eventListeners(SessionEventListener ... listeners) {
            if (this.listeners == null) {
                this.listeners = this.sessionFactory.getSessionFactoryOptions().getBaselineSessionEventsListenerBuilder().buildBaselineList();
            }
            Collections.addAll(this.listeners, listeners);
            return this;
        }

        @Override
        public SessionBuilderImpl clearEventListeners() {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SessionEventListener>(3);
            } else {
                this.listeners.clear();
            }
            return this;
        }

        @Override
        public SessionBuilderImpl jdbcTimeZone(TimeZone timeZone) {
            this.jdbcTimeZone = timeZone;
            return this;
        }
    }

    class IntegratorObserver
    implements SessionFactoryObserver {
        private final ArrayList<Integrator> integrators = new ArrayList();

        IntegratorObserver() {
        }

        @Override
        public void sessionFactoryClosed(SessionFactory factory) {
            for (Integrator integrator : this.integrators) {
                integrator.disintegrate(SessionFactoryImpl.this, SessionFactoryImpl.this.serviceRegistry);
            }
            this.integrators.clear();
        }
    }
}

