/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import jakarta.persistence.EntityGraph;
import jakarta.transaction.SystemException;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.SessionException;
import org.hibernate.StatelessSession;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.bytecode.spi.BytecodeEnhancementMetadata;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EffectiveEntityGraph;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.Generator;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionCreationOptions;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class StatelessSessionImpl
extends AbstractSharedSessionContract
implements StatelessSession {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(StatelessSessionImpl.class);
    private final LoadQueryInfluencers influencers;
    private final PersistenceContext temporaryPersistenceContext;
    private final boolean connectionProvided;

    public StatelessSessionImpl(SessionFactoryImpl factory, SessionCreationOptions options) {
        super(factory, options);
        this.connectionProvided = options.getConnection() != null;
        this.temporaryPersistenceContext = new StatefulPersistenceContext(this);
        this.influencers = new LoadQueryInfluencers(this.getFactory());
        this.setUpMultitenancy(factory, this.influencers);
    }

    @Override
    public boolean shouldAutoJoinTransaction() {
        return true;
    }

    @Override
    public Object insert(Object entity) {
        this.checkOpen();
        return this.insert(null, entity);
    }

    @Override
    public Object insert(String entityName, Object entity) {
        Object id;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object[] state = persister.getValues(entity);
        Generator generator = persister.getGenerator();
        if (!generator.generatedOnExecution(entity, this)) {
            id = ((BeforeExecutionGenerator)generator).generate(this, entity, null, EventType.INSERT);
            if (persister.isVersioned() && Versioning.seedVersion(entity, state, persister, (SharedSessionContractImplementor)this)) {
                persister.setValues(entity, state);
            }
            persister.getInsertCoordinator().insert(entity, id, state, this);
        } else {
            GeneratedValues generatedValues = persister.getInsertCoordinator().insert(entity, state, this);
            id = NullnessUtil.castNonNull(generatedValues).getGeneratedValue(persister.getIdentifierMapping());
        }
        persister.setIdentifier(entity, id, this);
        return id;
    }

    @Override
    public void delete(Object entity) {
        this.checkOpen();
        this.delete(null, entity);
    }

    @Override
    public void delete(String entityName, Object entity) {
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object version = persister.getVersion(entity);
        persister.getDeleteCoordinator().delete(entity, id, version, this);
    }

    @Override
    public void update(Object entity) {
        this.checkOpen();
        this.update(null, entity);
    }

    @Override
    public void upsert(Object entity) {
        this.checkOpen();
        this.upsert(null, entity);
    }

    @Override
    public void update(String entityName, Object entity) {
        Object oldVersion;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Object[] state = persister.getValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            Object newVersion = Versioning.incrementVersion(entity, oldVersion, persister, this);
            Versioning.setVersion(state, newVersion, persister);
            persister.setValues(entity, state);
        } else {
            oldVersion = null;
        }
        persister.getUpdateCoordinator().update(entity, id, null, state, oldVersion, null, null, false, this);
    }

    @Override
    public void upsert(String entityName, Object entity) {
        Object oldVersion;
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        Boolean knownTransient = persister.isTransient(entity, this);
        if (knownTransient != null && knownTransient.booleanValue()) {
            throw new TransientObjectException("Object passed to upsert() has a null identifier: " + persister.getEntityName());
        }
        Object[] state = persister.getValues(entity);
        if (persister.isVersioned()) {
            oldVersion = persister.getVersion(entity);
            if (oldVersion == null) {
                if (Versioning.seedVersion(entity, state, persister, (SharedSessionContractImplementor)this)) {
                    persister.setValues(entity, state);
                }
            } else {
                Object newVersion = Versioning.incrementVersion(entity, oldVersion, persister, this);
                Versioning.setVersion(state, newVersion, persister);
                persister.setValues(entity, state);
            }
        } else {
            oldVersion = null;
        }
        persister.getMergeCoordinator().update(entity, id, null, state, oldVersion, null, null, false, this);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id) {
        return (T)this.get(entityClass.getName(), id);
    }

    @Override
    public <T> T get(Class<T> entityClass, Object id, LockMode lockMode) {
        return (T)this.get(entityClass.getName(), id, lockMode);
    }

    @Override
    public Object get(String entityName, Object id) {
        return this.get(entityName, id, LockMode.NONE);
    }

    @Override
    public Object get(String entityName, Object id, LockMode lockMode) {
        this.checkOpen();
        Object result = this.getEntityPersister(entityName).load(id, null, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this);
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
        return result;
    }

    @Override
    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id) {
        return this.get(graph, graphSemantic, id, LockMode.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(EntityGraph<T> graph, GraphSemantic graphSemantic, Object id, LockMode lockMode) {
        RootGraphImplementor rootGraph = (RootGraphImplementor)graph;
        this.checkOpen();
        EffectiveEntityGraph effectiveEntityGraph = this.getLoadQueryInfluencers().getEffectiveEntityGraph();
        effectiveEntityGraph.applyGraph(rootGraph, graphSemantic);
        try {
            Object object = this.get(rootGraph.getGraphedType().getTypeName(), id, lockMode);
            return (T)object;
        }
        finally {
            effectiveEntityGraph.clear();
        }
    }

    private EntityPersister getEntityPersister(String entityName) {
        return this.getFactory().getMappingMetamodel().getEntityDescriptor(entityName);
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(this.bestGuessEntityName(entity), entity, LockMode.NONE);
    }

    @Override
    public void refresh(String entityName, Object entity) {
        this.refresh(entityName, entity, LockMode.NONE);
    }

    @Override
    public void refresh(Object entity, LockMode lockMode) {
        this.refresh(this.bestGuessEntityName(entity), entity, lockMode);
    }

    @Override
    public void refresh(String entityName, Object entity, LockMode lockMode) {
        EntityDataAccess cacheAccess;
        EntityPersister persister = this.getEntityPersister(entityName, entity);
        Object id = persister.getIdentifier(entity, this);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Refreshing transient {0}", MessageHelper.infoString(persister, id, this.getFactory()));
        }
        if (persister.canWriteToCache() && (cacheAccess = persister.getCacheAccessStrategy()) != null) {
            Object ck = cacheAccess.generateCacheKey(id, persister, this.getFactory(), this.getTenantIdentifier());
            cacheAccess.evict(ck);
        }
        Object result = this.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.REFRESH, () -> persister.load(id, entity, this.getNullSafeLockMode(lockMode), (SharedSessionContractImplementor)this));
        UnresolvableObjectException.throwIfNull(result, id, persister.getEntityName());
        if (this.temporaryPersistenceContext.isLoadFinished()) {
            this.temporaryPersistenceContext.clear();
        }
    }

    @Override
    public Object immediateLoad(String entityName, Object id) throws HibernateException {
        if (this.getPersistenceContextInternal().isLoadFinished()) {
            throw new SessionException("proxies cannot be fetched by a stateless session");
        }
        return this.get(entityName, id);
    }

    @Override
    public void initializeCollection(PersistentCollection<?> collection, boolean writing) throws HibernateException {
        throw new SessionException("collections cannot be fetched by a stateless session");
    }

    @Override
    public Object instantiate(String entityName, Object id) throws HibernateException {
        return this.instantiate(this.getEntityPersister(entityName), id);
    }

    @Override
    public Object instantiate(EntityPersister persister, Object id) throws HibernateException {
        this.checkOpen();
        return persister.instantiate(id, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object internalLoad(String entityName, Object id, boolean eager, boolean nullable) throws HibernateException {
        this.checkOpen();
        EntityPersister persister = this.getEntityPersister(entityName);
        EntityKey entityKey = this.generateEntityKey(id, persister);
        PersistenceContext persistenceContext = this.getPersistenceContext();
        EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
        if (holder != null && holder.getEntity() != null) {
            return holder.getEntity();
        }
        if (!eager) {
            EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
            BytecodeEnhancementMetadata enhancementMetadata = entityMetamodel.getBytecodeEnhancementMetadata();
            if (enhancementMetadata.isEnhancedForLazyLoading()) {
                if (persister.getRepresentationStrategy().getProxyFactory() != null) {
                    Object proxy;
                    Object object = proxy = holder == null ? null : holder.getProxy();
                    if (proxy != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Entity proxy found in session cache");
                        }
                        if (LOG.isDebugEnabled() && HibernateProxy.extractLazyInitializer(proxy).isUnwrap()) {
                            LOG.debug("Ignoring NO_PROXY to honor laziness");
                        }
                        return persistenceContext.narrowProxy(proxy, persister, entityKey, null);
                    }
                    if (entityMetamodel.hasSubclasses()) {
                        LOG.debug("Creating a HibernateProxy for to-one association with subclasses to honor laziness");
                        return this.createProxy(entityKey);
                    }
                    return enhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
                if (!entityMetamodel.hasSubclasses()) {
                    return enhancementMetadata.createEnhancedProxy(entityKey, false, this);
                }
            } else if (persister.hasProxy()) {
                Object existingProxy;
                Object object = existingProxy = holder == null ? null : holder.getProxy();
                if (existingProxy != null) {
                    return persistenceContext.narrowProxy(existingProxy, persister, entityKey, null);
                }
                return this.createProxy(entityKey);
            }
        }
        persistenceContext.beforeLoad();
        try {
            Object object = this.get(entityName, id);
            return object;
        }
        finally {
            persistenceContext.afterLoad();
        }
    }

    private Object createProxy(EntityKey entityKey) {
        Object proxy = entityKey.getPersister().createProxy(entityKey.getIdentifier(), this);
        this.getPersistenceContext().addProxy(entityKey, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(Object association) {
        PersistentCollection persistentCollection;
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        LazyInitializer initializer = HibernateProxy.extractLazyInitializer(association);
        if (initializer != null) {
            if (initializer.isUninitialized()) {
                String entityName = initializer.getEntityName();
                Object id = initializer.getIdentifier();
                initializer.setSession(this);
                persistenceContext.beforeLoad();
                try {
                    Object entity = initializer.getImplementation();
                    if (entity == null) {
                        this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(entityName, id);
                    }
                    initializer.setImplementation(entity);
                }
                finally {
                    initializer.unsetSession();
                    persistenceContext.afterLoad();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(association)) {
            PersistentAttributeInterceptable interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable(association);
            PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
            if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                proxyInterceptor.setSession(this);
                try {
                    proxyInterceptor.forceInitialize(association, null);
                }
                finally {
                    proxyInterceptor.unsetSession();
                    if (persistenceContext.isLoadFinished()) {
                        persistenceContext.clear();
                    }
                }
            }
        } else if (association instanceof PersistentCollection && !(persistentCollection = (PersistentCollection)association).wasInitialized()) {
            CollectionPersister collectionDescriptor = this.getFactory().getMappingMetamodel().getCollectionDescriptor(persistentCollection.getRole());
            Object key = persistentCollection.getKey();
            persistenceContext.addUninitializedCollection(collectionDescriptor, persistentCollection, key);
            persistentCollection.setCurrentSession(this);
            try {
                collectionDescriptor.initialize(key, this);
            }
            finally {
                persistentCollection.unsetSession(this);
                if (persistenceContext.isLoadFinished()) {
                    persistenceContext.clear();
                }
            }
        }
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.getFactory().getSessionFactoryOptions().isAutoCloseSessionEnabled();
    }

    @Override
    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    private boolean isFlushModeNever() {
        return false;
    }

    private void managedClose() {
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        this.close();
    }

    private void managedFlush() {
        this.checkOpen();
        this.getJdbcCoordinator().executeBatch();
    }

    @Override
    public String bestGuessEntityName(Object object) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(object);
        if (lazyInitializer != null) {
            object = lazyInitializer.getImplementation();
        }
        return this.guessEntityName(object);
    }

    @Override
    public CacheMode getCacheMode() {
        return CacheMode.IGNORE;
    }

    @Override
    public void setCacheMode(CacheMode cm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHibernateFlushMode(FlushMode flushMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getContextEntityIdentifier(Object object) {
        this.checkOpen();
        return null;
    }

    @Override
    public String guessEntityName(Object entity) throws HibernateException {
        this.checkOpen();
        return entity.getClass().getName();
    }

    @Override
    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        this.checkOpen();
        return entityName == null ? this.getEntityPersister(this.guessEntityName(object)) : this.getEntityPersister(entityName).getSubclassEntityPersister(object, this.getFactory());
    }

    @Override
    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        this.checkOpen();
        PersistenceContext persistenceContext = this.getPersistenceContext();
        Object result = persistenceContext.getEntity(key);
        if (result != null) {
            return result;
        }
        Object newObject = this.getInterceptor().getEntity(key.getEntityName(), key.getIdentifier());
        if (newObject != null) {
            persistenceContext.addEntity(key, newObject);
            return newObject;
        }
        return null;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public void setAutoClear(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object load(String entityName, Object identifier) {
        return null;
    }

    @Override
    public boolean isDefaultReadOnly() {
        return false;
    }

    public void setDefaultReadOnly(boolean readOnly) throws HibernateException {
        if (readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void afterOperation(boolean success) {
        this.temporaryPersistenceContext.clear();
        if (!this.isTransactionInProgress()) {
            this.getJdbcCoordinator().afterTransaction();
        }
    }

    @Override
    public void afterScrollOperation() {
        this.temporaryPersistenceContext.clear();
    }

    @Override
    public void flush() {
    }

    @Override
    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.influencers;
    }

    @Override
    public PersistenceContext getPersistenceContextInternal() {
        return this.temporaryPersistenceContext;
    }

    @Override
    public boolean autoFlushIfRequired(Set<String> querySpaces) throws HibernateException {
        return false;
    }

    @Override
    public void afterTransactionBegin() {
    }

    @Override
    public void beforeTransactionCompletion() {
        this.flushBeforeTransactionCompletion();
    }

    @Override
    public void afterTransactionCompletion(boolean successful, boolean delayed) {
        if (this.shouldAutoClose() && !this.isClosed()) {
            this.managedClose();
        }
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.connectionProvided || super.isTransactionInProgress();
    }

    @Override
    public void flushBeforeTransactionCompletion() {
        boolean flush;
        try {
            flush = !this.isClosed() && !this.isFlushModeNever() && !JtaStatusHelper.isRollback(this.getJtaPlatform().getCurrentStatus());
        }
        catch (SystemException se) {
            throw new HibernateException("could not determine transaction status in beforeCompletion()", se);
        }
        if (flush) {
            this.managedFlush();
        }
    }

    private JtaPlatform getJtaPlatform() {
        return this.getFactory().getServiceRegistry().requireService(JtaPlatform.class);
    }

    private LockMode getNullSafeLockMode(LockMode lockMode) {
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    @Override
    public StatelessSession asStatelessSession() {
        return this;
    }

    @Override
    public boolean isStatelessSession() {
        return true;
    }
}

