/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.KeyedPage;
import org.hibernate.query.KeyedResultList;
import org.hibernate.query.Order;
import org.hibernate.query.Page;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.criteria.ValueHandlingMode;
import org.hibernate.query.hql.internal.QuerySplitter;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.internal.AggregatedSelectQueryPlanImpl;
import org.hibernate.query.sqm.internal.ConcreteSqmSelectQueryPlan;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.KeyBasedPagination;
import org.hibernate.query.sqm.internal.KeyedResult;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.results.internal.TupleMetadata;

abstract class AbstractSqmSelectionQuery<R>
extends AbstractSelectionQuery<R> {
    AbstractSqmSelectionQuery(SharedSessionContractImplementor session) {
        super(session);
    }

    protected int max(boolean hasLimit, SqmSelectStatement<?> sqmStatement, List<R> list) {
        return !hasLimit || this.getQueryOptions().getLimit().getMaxRows() == null ? this.getMaxRows(sqmStatement, list.size()) : this.getQueryOptions().getLimit().getMaxRows().intValue();
    }

    protected int first(boolean hasLimit, SqmSelectStatement<?> sqmStatement) {
        return !hasLimit || this.getQueryOptions().getLimit().getFirstRow() == null ? this.getIntegerLiteral(sqmStatement.getOffset(), 0) : this.getQueryOptions().getLimit().getFirstRow().intValue();
    }

    protected static boolean hasLimit(SqmSelectStatement<?> sqm, MutableQueryOptions queryOptions) {
        return queryOptions.hasLimit() || sqm.getFetch() != null || sqm.getOffset() != null;
    }

    protected boolean needsDistinct(boolean containsCollectionFetches, boolean hasLimit, SqmSelectStatement<?> sqmStatement) {
        return containsCollectionFetches && (hasLimit || sqmStatement.usesDistinct() || AbstractSqmSelectionQuery.hasAppliedGraph((MutableQueryOptions)this.getQueryOptions()));
    }

    protected static boolean hasAppliedGraph(MutableQueryOptions queryOptions) {
        AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
        return appliedGraph != null && appliedGraph.getSemantic() != null;
    }

    protected void errorOrLogForPaginationWithCollectionFetch() {
        if (this.getSessionFactory().getSessionFactoryOptions().isFailOnPaginationOverCollectionFetchEnabled()) {
            throw new HibernateException("setFirstResult() or setMaxResults() specified with collection fetch join (in-memory pagination was about to be applied, but 'hibernate.query.fail_on_pagination_over_collection_fetch' is enabled)");
        }
        QueryLogging.QUERY_MESSAGE_LOGGER.firstOrMaxResultsSpecifiedWithCollectionFetch();
    }

    public abstract SqmStatement<R> getSqmStatement();

    protected abstract void setSqmStatement(SqmSelectStatement<R> var1);

    public abstract DomainParameterXref getDomainParameterXref();

    public abstract TupleMetadata getTupleMetadata();

    private SqmSelectStatement<R> getSqmSelectStatement() {
        SqmStatement<R> sqmStatement = this.getSqmStatement();
        if (sqmStatement instanceof SqmSelectStatement) {
            return (SqmSelectStatement)sqmStatement;
        }
        throw new IllegalSelectQueryException("Not a select query");
    }

    @Override
    public SelectionQuery<R> setOrder(List<Order<? super R>> orderList) {
        SqmSelectQuery<Object> sqm = this.getSqmSelectStatement();
        SqmSelectQuery<Object> select = sqm = ((SqmSelectStatement)sqm).copy(SqmCopyContext.noParamCopyContext());
        ((SqmSelectStatement)sqm).orderBy(orderList.stream().map(order -> SqmUtil.sortSpecification(select, order)).collect(Collectors.toList()));
        this.getQueryOptions().setQueryPlanCachingEnabled(false);
        this.setSqmStatement((SqmSelectStatement<R>)sqm);
        return this;
    }

    @Override
    public SelectionQuery<R> setOrder(Order<? super R> order) {
        SqmSelectQuery<Object> sqm = this.getSqmSelectStatement();
        sqm = ((SqmSelectStatement)sqm).copy(SqmCopyContext.noParamCopyContext());
        ((SqmSelectStatement)sqm).orderBy(new jakarta.persistence.criteria.Order[]{SqmUtil.sortSpecification(sqm, order)});
        this.getQueryOptions().setQueryPlanCachingEnabled(false);
        this.setSqmStatement((SqmSelectStatement<R>)sqm);
        return this;
    }

    @Override
    public SelectionQuery<R> setPage(Page page) {
        this.setMaxResults(page.getMaxResults());
        this.setFirstResult(page.getFirstResult());
        return this;
    }

    private SqmSelectStatement<KeyedResult<R>> paginateQuery(List<Order<? super R>> keyDefinition, List<Comparable<?>> keyValues) {
        SqmSelectQuery sqm = this.getSqmSelectStatement().copy(SqmCopyContext.noParamCopyContext());
        NodeBuilder builder = ((AbstractSqmNode)((Object)sqm)).nodeBuilder();
        builder.setCriteriaValueHandlingMode(ValueHandlingMode.INLINE);
        return KeyBasedPagination.paginate(keyDefinition, keyValues, sqm, builder);
    }

    @Override
    public KeyedResultList<R> getKeyedResultList(KeyedPage<R> keyedPage) {
        if (keyedPage == null) {
            throw new IllegalArgumentException("KeyedPage was null");
        }
        Page page = keyedPage.getPage();
        List<Comparable<?>> key = keyedPage.getKey();
        List<Order<? super R>> keyDefinition = keyedPage.getKeyDefinition();
        List<Order<? super R>> appliedKeyDefinition = keyedPage.getKeyInterpretation() == KeyedPage.KeyInterpretation.KEY_OF_FIRST_ON_NEXT_PAGE ? Order.reverse(keyDefinition) : keyDefinition;
        this.setMaxResults(page.getMaxResults() + 1);
        if (key == null) {
            this.setFirstResult(page.getFirstResult());
        }
        List results = this.buildConcreteQueryPlan(this.paginateQuery(appliedKeyDefinition, key), this.getQueryOptions()).performList(this);
        return new KeyedResultList(KeyedResult.collectResults(results, page.getSize()), KeyedResult.collectKeys(results, page.getSize()), keyedPage, AbstractSqmSelectionQuery.nextPage(keyedPage, results), AbstractSqmSelectionQuery.previousPage(keyedPage, results));
    }

    private static <R> KeyedPage<R> nextPage(KeyedPage<R> keyedPage, List<KeyedResult<R>> results) {
        int pageSize = keyedPage.getPage().getSize();
        return results.size() == pageSize + 1 ? keyedPage.nextPage(results.get(pageSize - 1).getKey()) : null;
    }

    private static <R> KeyedPage<R> previousPage(KeyedPage<R> keyedPage, List<KeyedResult<R>> results) {
        return !results.isEmpty() ? keyedPage.previousPage(results.get(0).getKey()) : null;
    }

    public abstract Class<R> getExpectedResultType();

    protected SelectQueryPlan<R> buildSelectQueryPlan() {
        SqmSelectStatement statement = (SqmSelectStatement)this.getSqmStatement();
        SqmSelectStatement<R>[] concreteSqmStatements = QuerySplitter.split(statement);
        return concreteSqmStatements.length > 1 ? this.buildAggregatedQueryPlan(concreteSqmStatements) : this.buildConcreteQueryPlan(concreteSqmStatements[0]);
    }

    private SelectQueryPlan<R> buildAggregatedQueryPlan(SqmSelectStatement<R>[] concreteSqmStatements) {
        SelectQueryPlan[] aggregatedQueryPlans = new SelectQueryPlan[concreteSqmStatements.length];
        int length = concreteSqmStatements.length;
        for (int i = 0; i < length; ++i) {
            aggregatedQueryPlans[i] = this.buildConcreteQueryPlan(concreteSqmStatements[i]);
        }
        return new AggregatedSelectQueryPlanImpl(aggregatedQueryPlans);
    }

    protected SelectQueryPlan<R> buildConcreteQueryPlan(SqmSelectStatement<R> concreteSqmStatement) {
        return this.buildConcreteQueryPlan(concreteSqmStatement, this.getExpectedResultType(), this.getTupleMetadata(), this.getQueryOptions());
    }

    protected <T> ConcreteSqmSelectQueryPlan<T> buildConcreteQueryPlan(SqmSelectStatement<T> concreteSqmStatement, Class<T> expectedResultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        return new ConcreteSqmSelectQueryPlan<T>(concreteSqmStatement, this.getQueryString(), this.getDomainParameterXref(), expectedResultType, tupleMetadata, queryOptions);
    }

    private <T> SelectQueryPlan<T> buildConcreteQueryPlan(SqmSelectStatement<T> sqmStatement, QueryOptions options) {
        return this.buildConcreteQueryPlan(sqmStatement, null, null, options);
    }
}

