/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.FetchNotFoundException;
import org.hibernate.Hibernate;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityLoadingLogging;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntitySelectFetchInitializer
implements EntityInitializer {
    private static final String CONCRETE_NAME = EntitySelectFetchInitializer.class.getSimpleName();
    protected final FetchParentAccess parentAccess;
    private final NavigablePath navigablePath;
    private final FetchParentAccess owningParent;
    private final EntityMappingType ownedModelPartDeclaringType;
    private final boolean isPartOfKey;
    private final boolean isEnhancedForLazyLoading;
    protected final EntityPersister concreteDescriptor;
    protected final DomainResultAssembler<?> keyAssembler;
    private final ToOneAttributeMapping toOneMapping;
    protected boolean parentShallowCached;
    protected State state = State.UNINITIALIZED;
    protected Object entityIdentifier;
    protected Object entityInstance;

    public EntitySelectFetchInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping toOneMapping, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler<?> keyAssembler) {
        this.parentAccess = parentAccess;
        this.toOneMapping = toOneMapping;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parentAccess);
        this.owningParent = FetchParentAccess.determineOwningParent(parentAccess);
        this.ownedModelPartDeclaringType = FetchParentAccess.determineOwnedModelPartDeclaringType(toOneMapping, parentAccess, this.owningParent);
        this.concreteDescriptor = concreteDescriptor;
        this.keyAssembler = keyAssembler;
        this.isEnhancedForLazyLoading = concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.toOneMapping;
    }

    @Override
    public FetchParentAccess getFetchParentAccess() {
        return this.parentAccess;
    }

    @Override
    public @Nullable FetchParentAccess getOwningParent() {
        return this.owningParent;
    }

    @Override
    public @Nullable EntityMappingType getOwnedModelPartDeclaringType() {
        return this.ownedModelPartDeclaringType;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.state != State.UNINITIALIZED) {
            return;
        }
        this.state = State.RESOLVED;
        if (this.parentShallowCached || this.shouldSkipInitializer(rowProcessingState)) {
            this.state = State.INITIALIZED;
            return;
        }
        this.entityIdentifier = this.keyAssembler.assemble(rowProcessingState);
        if (this.entityIdentifier == null) {
            this.state = State.INITIALIZED;
            return;
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isTraceEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.tracef("(%s) Beginning Initializer#resolveInstance process for entity (%s) : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)this.getNavigablePath(), this.entityIdentifier);
        }
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        EntityKey entityKey = new EntityKey(this.entityIdentifier, this.concreteDescriptor);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
        if (holder != null) {
            if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Found existing loading entry [%s] - using loading instance", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.entityIdentifier));
            }
            this.entityInstance = holder.getEntity();
            if (holder.getEntityInitializer() == null) {
                if (this.entityInstance != null && Hibernate.isInitialized(this.entityInstance)) {
                    this.state = State.INITIALIZED;
                    return;
                }
            } else {
                if (holder.getEntityInitializer() != this) {
                    if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
                        EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] being loaded by another initializer [%s] - skipping processing", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.entityIdentifier), (Object)holder.getEntityInitializer());
                    }
                    this.state = State.INITIALIZED;
                    return;
                }
                if (this.entityInstance == null) {
                    this.state = State.INITIALIZED;
                    return;
                }
            }
        }
        for (NavigablePath np = this.navigablePath.getParent(); np != null; np = np.getParent()) {
            if (!(np instanceof EntityIdentifierNavigablePath) && !"{fk}".equals(np.getLocalName()) && !"{fk-target}".equals(np.getLocalName())) continue;
            this.initializeInstance(rowProcessingState);
            return;
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (this.state != State.RESOLVED) {
            return;
        }
        this.state = State.INITIALIZED;
        SharedSessionContractImplementor session = rowProcessingState.getSession();
        String entityName = this.concreteDescriptor.getEntityName();
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Invoking session#internalLoad for entity (%s) : %s", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.entityIdentifier), this.entityIdentifier);
        }
        this.entityInstance = session.internalLoad(entityName, this.entityIdentifier, true, this.toOneMapping.isInternalLoadNullable());
        if (this.entityInstance == null) {
            if (this.toOneMapping.getNotFoundAction() == NotFoundAction.EXCEPTION) {
                throw new FetchNotFoundException(entityName, this.entityIdentifier);
            }
            rowProcessingState.getSession().getPersistenceContextInternal().claimEntityHolderIfPossible(new EntityKey(this.entityIdentifier, this.concreteDescriptor), this.entityInstance, rowProcessingState.getJdbcValuesSourceProcessingState(), this);
        }
        if (EntityLoadingLogging.ENTITY_LOADING_LOGGER.isDebugEnabled()) {
            EntityLoadingLogging.ENTITY_LOADING_LOGGER.debugf("(%s) Entity [%s] : %s has being loaded by session.internalLoad.", (Object)CONCRETE_NAME, (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.entityIdentifier), this.entityIdentifier);
        }
        boolean unwrapProxy = this.toOneMapping.isUnwrapProxy() && this.isEnhancedForLazyLoading;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(this.entityInstance);
        if (lazyInitializer != null) {
            lazyInitializer.setUnwrap(unwrapProxy);
        }
    }

    @Override
    public void initializeInstanceFromParent(Object parentInstance, RowProcessingState rowProcessingState) {
        AttributeMapping attributeMapping = this.getInitializedPart().asAttributeMapping();
        Object instance = attributeMapping != null ? attributeMapping.getValue(parentInstance) : parentInstance;
        Hibernate.initialize(instance);
        this.entityInstance = instance;
        this.state = State.INITIALIZED;
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.state = State.UNINITIALIZED;
    }

    @Override
    public void markShallowCached() {
        this.parentShallowCached = true;
    }

    @Override
    public void endLoading(ExecutionContext executionContext) {
        this.parentShallowCached = false;
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public boolean isEntityInitialized() {
        return this.state == State.INITIALIZED;
    }

    @Override
    public EntityPersister getConcreteDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    public String toString() {
        return "EntitySelectFetchInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    @Override
    public EntityKey getEntityKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public Object getParentKey() {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        throw new UnsupportedOperationException("This should never happen, because this initializer has not child initializers");
    }

    protected static enum State {
        UNINITIALIZED,
        RESOLVED,
        INITIALIZED;

    }
}

