/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.List;
import java.util.Locale;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.JdbcType;

class ColumnDefinitions {
    ColumnDefinitions() {
    }

    static boolean hasMatchingType(Column column, ColumnInformation columnInformation, Metadata metadata, Dialect dialect) {
        boolean typesMatch;
        boolean bl = typesMatch = dialect.equivalentTypes(column.getSqlTypeCode(metadata), columnInformation.getTypeCode()) || ColumnDefinitions.normalize(ColumnDefinitions.stripArgs(column.getSqlType(metadata))).equals(ColumnDefinitions.normalize(columnInformation.getTypeName()));
        if (typesMatch) {
            return true;
        }
        JdbcType jdbcType = dialect.resolveSqlTypeDescriptor(columnInformation.getTypeName(), columnInformation.getTypeCode(), columnInformation.getColumnSize(), columnInformation.getDecimalDigits(), metadata.getDatabase().getTypeConfiguration().getJdbcTypeRegistry());
        return dialect.equivalentTypes(column.getSqlTypeCode(metadata), jdbcType.getDefaultSqlTypeCode());
    }

    static boolean hasMatchingLength(Column column, ColumnInformation columnInformation, Metadata metadata, Dialect dialect) {
        int sqlType = columnInformation.getTypeCode();
        if (SqlTypes.isStringType(sqlType)) {
            int actualLength = columnInformation.getColumnSize();
            Size size = column.getColumnSize(dialect, metadata);
            Long requiredLength = size.getLength();
            return requiredLength == null || requiredLength == (long)actualLength;
        }
        if (SqlTypes.isNumericOrDecimal(sqlType)) {
            int actualPrecision = columnInformation.getColumnSize();
            int actualScale = columnInformation.getDecimalDigits();
            Size size = column.getColumnSize(dialect, metadata);
            Integer requiredPrecision = size.getPrecision();
            Integer requiredScale = size.getScale();
            return requiredPrecision == null || requiredScale == null || requiredScale == actualScale && requiredPrecision == actualPrecision;
        }
        return true;
    }

    static String getFullColumnDeclaration(Column column, Table table, Metadata metadata, Dialect dialect, SqlStringGenerationContext context) {
        StringBuilder definition = new StringBuilder();
        ColumnDefinitions.appendColumn(definition, column, table, metadata, dialect, context);
        return definition.toString();
    }

    static String getColumnDefinition(Column column, Table table, Metadata metadata, Dialect dialect) {
        StringBuilder definition = new StringBuilder();
        ColumnDefinitions.appendColumnDefinition(definition, column, table, metadata, dialect);
        ColumnDefinitions.appendComment(definition, column, dialect);
        return definition.toString();
    }

    static void appendColumn(StringBuilder statement, Column column, Table table, Metadata metadata, Dialect dialect, SqlStringGenerationContext context) {
        statement.append(column.getQuotedName(dialect));
        ColumnDefinitions.appendColumnDefinition(statement, column, table, metadata, dialect);
        ColumnDefinitions.appendComment(statement, column, dialect);
        ColumnDefinitions.appendConstraints(statement, column, table, dialect, context);
    }

    private static void appendConstraints(StringBuilder definition, Column column, Table table, Dialect dialect, SqlStringGenerationContext context) {
        block9: {
            if (column.isUnique() && !table.isPrimaryKey(column)) {
                String uniqueKeyName = column.getUniqueKeyName();
                String keyName = uniqueKeyName == null ? Constraint.generateName("UK_", table, column) : uniqueKeyName;
                UniqueKey uniqueKey = table.getOrCreateUniqueKey(keyName);
                uniqueKey.addColumn(column);
                definition.append(dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(column, context));
            }
            if (!dialect.supportsColumnCheck()) break block9;
            List<CheckConstraint> checkConstraints = column.getCheckConstraints();
            long anonConstraints = checkConstraints.stream().filter(CheckConstraint::isAnonymous).count();
            if (anonConstraints == 1L) {
                for (CheckConstraint constraint : checkConstraints) {
                    definition.append(constraint.constraintString());
                }
            } else {
                boolean first = true;
                for (CheckConstraint constraint : checkConstraints) {
                    if (!constraint.isAnonymous()) continue;
                    if (first) {
                        definition.append(" check (");
                        first = false;
                    } else {
                        definition.append(" and ");
                    }
                    definition.append(constraint.getConstraintInParens());
                }
                if (!first) {
                    definition.append(")");
                }
                for (CheckConstraint constraint : checkConstraints) {
                    if (!constraint.isNamed()) continue;
                    definition.append(constraint.constraintString());
                }
            }
        }
    }

    private static void appendComment(StringBuilder definition, Column column, Dialect dialect) {
        String columnComment = column.getComment();
        if (columnComment != null) {
            definition.append(dialect.getColumnComment(columnComment));
        }
    }

    private static void appendColumnDefinition(StringBuilder definition, Column column, Table table, Metadata metadata, Dialect dialect) {
        if (ColumnDefinitions.isIdentityColumn(column, table, metadata, dialect)) {
            if (dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                definition.append(' ').append(column.getSqlType(metadata));
            }
            String identityColumnString = dialect.getIdentityColumnSupport().getIdentityColumnString(column.getSqlTypeCode(metadata));
            definition.append(' ').append(identityColumnString);
        } else {
            String generatedAs;
            String defaultValue;
            String collation;
            String columnType = column.getSqlType(metadata);
            if (column.getGeneratedAs() == null || dialect.hasDataTypeBeforeGeneratedAs()) {
                definition.append(' ').append(columnType);
            }
            if ((collation = column.getCollation()) != null) {
                definition.append(" collate ").append(dialect.quoteCollation(collation));
            }
            if ((defaultValue = column.getDefaultValue()) != null) {
                definition.append(" default ").append(defaultValue);
            }
            if ((generatedAs = column.getGeneratedAs()) != null) {
                definition.append(dialect.generatedAs(generatedAs));
            }
            if (column.isNullable()) {
                definition.append(dialect.getNullColumnString(columnType));
            } else {
                definition.append(" not null");
            }
        }
    }

    private static boolean isIdentityColumn(Column column, Table table, Metadata metadata, Dialect dialect) {
        return ColumnDefinitions.isPrimaryKeyIdentity(table, metadata, dialect) && column.getQuotedName(dialect).equals(ColumnDefinitions.getPrimaryKeyColumnName(table, dialect));
    }

    private static String getPrimaryKeyColumnName(Table table, Dialect dialect) {
        return table.hasPrimaryKey() ? table.getPrimaryKey().getColumns().get(0).getQuotedName(dialect) : null;
    }

    private static boolean isPrimaryKeyIdentity(Table table, Metadata metadata, Dialect dialect) {
        MetadataImplementor metadataImplementor = (MetadataImplementor)metadata;
        return table.hasPrimaryKey() && table.getIdentifierValue() != null && table.getIdentifierValue().isIdentityColumn(metadataImplementor.getMetadataBuildingOptions().getIdentifierGeneratorFactory(), dialect);
    }

    private static String normalize(String typeName) {
        String lowerCaseTypName;
        if (typeName == null) {
            return null;
        }
        switch (lowerCaseTypName = typeName.toLowerCase(Locale.ROOT)) {
            case "character": {
                return "char";
            }
            case "character varying": {
                return "varchar";
            }
            case "binary varying": {
                return "varbinary";
            }
            case "interval second": {
                return "interval";
            }
        }
        return lowerCaseTypName;
    }

    private static String stripArgs(String typeExpression) {
        if (typeExpression == null) {
            return null;
        }
        int i = typeExpression.indexOf(40);
        return i > 0 ? typeExpression.substring(0, i).trim() : typeExpression;
    }
}

