/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.InstantiationException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.AppliedGraphs;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.internal.RowTransformerCheckingImpl;
import org.hibernate.sql.results.internal.RowTransformerConstructorImpl;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerListImpl;
import org.hibernate.sql.results.internal.RowTransformerMapImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement<?> sqm;
    private final DomainParameterXref domainParameterXref;
    private final RowTransformer<R> rowTransformer;
    private final SqmInterpreter<Object, ResultsConsumer<?, R>> executeQueryInterpreter;
    private final SqmInterpreter<List<R>, Void> listInterpreter;
    private final SqmInterpreter<ScrollableResultsImplementor<R>, ScrollMode> scrollInterpreter;
    private volatile CacheableSqmInterpretation cacheableSqmInterpretation;
    private static final Map<Class<?>, Class<?>> WRAPPERS = Map.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class);

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement<?> sqm, String hql, DomainParameterXref domainParameterXref, Class<R> resultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        this.rowTransformer = ConcreteSqmSelectQueryPlan.determineRowTransformer(sqm, resultType, tupleMetadata, queryOptions);
        ListResultsConsumer.UniqueSemantic uniqueSemantic = sqm.producesUniqueResults() && !AppliedGraphs.containsCollectionFetches(queryOptions) ? ListResultsConsumer.UniqueSemantic.NONE : ListResultsConsumer.UniqueSemantic.ALLOW;
        this.executeQueryInterpreter = (resultsConsumer, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = sqmInterpretation.getJdbcSelect();
            try {
                SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqmInterpretation.selectStatement, JdbcParametersList.empty(), jdbcParameterBindings);
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                Object t = session.getFactory().getJdbcServices().getJdbcSelectExecutor().executeQuery(jdbcSelect, jdbcParameterBindings, ConcreteSqmSelectQueryPlan.listInterpreterExecutionContext(hql, executionContext, jdbcSelect, subSelectFetchKeyHandler), this.rowTransformer, null, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, false, null), resultsConsumer);
                return t;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.listInterpreter = (unused, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = sqmInterpretation.getJdbcSelect();
            try {
                SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), sqmInterpretation.selectStatement, JdbcParametersList.empty(), jdbcParameterBindings);
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                List<R> list = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, ConcreteSqmSelectQueryPlan.listInterpreterExecutionContext(hql, executionContext, jdbcSelect, subSelectFetchKeyHandler), this.rowTransformer, uniqueSemantic);
                return list;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.scrollInterpreter = (scrollMode, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = sqmInterpretation.getJdbcSelect();
            try {
                JdbcSelectExecutor jdbcSelectExecutor = session.getFactory().getJdbcServices().getJdbcSelectExecutor();
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                ScrollableResultsImplementor<R> scrollableResultsImplementor = jdbcSelectExecutor.scroll(jdbcSelect, (ScrollMode)((Object)scrollMode), jdbcParameterBindings, new SqmJdbcExecutionContextAdapter(executionContext, jdbcSelect), this.rowTransformer);
                return scrollableResultsImplementor;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
    }

    protected static SqmJdbcExecutionContextAdapter listInterpreterExecutionContext(String hql, DomainQueryExecutionContext executionContext, JdbcOperationQuerySelect jdbcSelect, SubselectFetch.RegistrationHandler subSelectFetchKeyHandler) {
        return new MySqmJdbcExecutionContextAdapter(executionContext, jdbcSelect, subSelectFetchKeyHandler, hql);
    }

    private static SqmSelection<?> singleSelection(SqmSelectStatement<?> sqm) {
        List<SqmSelection<?>> selections = ((SqmQueryPart)sqm.getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
        return selections.size() == 1 ? selections.get(0) : null;
    }

    protected static <T> RowTransformer<T> determineRowTransformer(SqmSelectStatement<?> sqm, Class<T> resultClass, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        if (queryOptions.getTupleTransformer() != null) {
            return ConcreteSqmSelectQueryPlan.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (resultClass == null || resultClass == Object.class) {
            return RowTransformerStandardImpl.instance();
        }
        Class<T> resultType = WRAPPERS.getOrDefault(resultClass, resultClass);
        SqmSelection<?> selection = ConcreteSqmSelectQueryPlan.singleSelection(sqm);
        if (SqmUtil.isSelectionAssignableToResultType(selection, resultType)) {
            return RowTransformerSingularReturnImpl.instance();
        }
        if (resultType.isArray()) {
            return RowTransformerArrayImpl.instance();
        }
        if (List.class.equals(resultType)) {
            return RowTransformerListImpl.instance();
        }
        if (Tuple.class.equals(resultType)) {
            return new RowTransformerJpaTupleImpl(tupleMetadata);
        }
        if (Map.class.equals(resultType)) {
            return new RowTransformerMapImpl(tupleMetadata);
        }
        if (ReflectHelper.isClass(resultType)) {
            try {
                return new RowTransformerConstructorImpl<T>(resultType, tupleMetadata);
            }
            catch (InstantiationException ie) {
                return new RowTransformerCheckingImpl<T>(resultType);
            }
        }
        return new RowTransformerCheckingImpl<T>(resultType);
    }

    private static <T> RowTransformer<T> makeRowTransformerTupleTransformerAdapter(SqmSelectStatement<?> sqm, QueryOptions queryOptions) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SqmSelection<?> sqmSelection : ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections()) {
            if (sqmSelection.getSelectableNode() instanceof SqmDynamicInstantiation) {
                aliases.add(sqmSelection.getAlias());
                continue;
            }
            sqmSelection.getSelectableNode().visitSubSelectableNodes(subSelection -> aliases.add(subSelection.getAlias()));
        }
        TupleTransformer<?> tupleTransformer = queryOptions.getTupleTransformer();
        return new RowTransformerTupleTransformerAdapter(ArrayHelper.toStringArray(aliases), tupleTransformer);
    }

    @Override
    public <T> T executeQuery(DomainQueryExecutionContext executionContext, ResultsConsumer<T, R> resultsConsumer) {
        return (T)this.withCacheableSqmInterpretation(executionContext, resultsConsumer, this.executeQueryInterpreter);
    }

    @Override
    public List<R> performList(DomainQueryExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return Collections.emptyList();
        }
        return this.withCacheableSqmInterpretation(executionContext, null, this.listInterpreter);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        if (executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0) {
            return EmptyScrollableResults.INSTANCE;
        }
        return this.withCacheableSqmInterpretation(executionContext, scrollMode, this.scrollInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> T withCacheableSqmInterpretation(DomainQueryExecutionContext executionContext, X context, SqmInterpreter<T, X> interpreter) {
        CacheableSqmInterpretation localCopy = this.cacheableSqmInterpretation;
        JdbcParameterBindings jdbcParameterBindings = null;
        executionContext.getSession().autoPreFlush();
        if (localCopy == null) {
            ConcreteSqmSelectQueryPlan concreteSqmSelectQueryPlan = this;
            synchronized (concreteSqmSelectQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                    jdbcParameterBindings = localCopy.firstParameterBindings;
                    localCopy.firstParameterBindings = null;
                    this.cacheableSqmInterpretation = localCopy;
                } else {
                    if (localCopy.jdbcSelect.dependsOnParameterBindings()) {
                        jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
                    }
                    if (!localCopy.jdbcSelect.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                        localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                        jdbcParameterBindings = localCopy.firstParameterBindings;
                        localCopy.firstParameterBindings = null;
                        this.cacheableSqmInterpretation = localCopy;
                    }
                }
            }
        } else {
            if (localCopy.jdbcSelect.dependsOnParameterBindings()) {
                jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
            }
            if (!localCopy.jdbcSelect.isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                localCopy = ConcreteSqmSelectQueryPlan.buildCacheableSqmInterpretation(this.sqm, this.domainParameterXref, executionContext);
                jdbcParameterBindings = localCopy.firstParameterBindings;
                localCopy.firstParameterBindings = null;
                this.cacheableSqmInterpretation = localCopy;
            }
        }
        if (jdbcParameterBindings == null) {
            jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
        }
        return interpreter.interpret(context, executionContext, localCopy, jdbcParameterBindings);
    }

    private JdbcParameterBindings createJdbcParameterBindings(final CacheableSqmInterpretation sqmInterpretation, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        return SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.getJdbcParamsXref(), session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), sqmInterpretation.getTableGroupAccess()::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypes().get(parameter);
            }
        }, session);
    }

    private static CacheableSqmInterpretation buildCacheableSqmInterpretation(SqmSelectStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        final SqmTranslation<SelectStatement> sqmInterpretation = sessionFactory.getQueryEngine().getSqmTranslatorFactory().createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), sessionFactory, true).translate();
        FromClauseAccess tableGroupAccess = sqmInterpretation.getFromClauseAccess();
        SqlAstTranslator<JdbcOperationQuerySelect> selectTranslator = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, sqmInterpretation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, session.getFactory().getRuntimeMetamodels().getMappingMetamodel(), tableGroupAccess::findTableGroup, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, session);
        return new CacheableSqmInterpretation(sqmInterpretation.getSqlAst(), selectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions()), tableGroupAccess, jdbcParamsXref, sqmInterpretation.getSqmParameterMappingModelTypeResolutions(), jdbcParameterBindings);
    }

    private static class MySqmJdbcExecutionContextAdapter
    extends SqmJdbcExecutionContextAdapter {
        private final SubselectFetch.RegistrationHandler subSelectFetchKeyHandler;
        private final String hql;

        public MySqmJdbcExecutionContextAdapter(DomainQueryExecutionContext executionContext, JdbcOperationQuerySelect jdbcSelect, SubselectFetch.RegistrationHandler subSelectFetchKeyHandler, String hql) {
            super(executionContext, jdbcSelect);
            this.subSelectFetchKeyHandler = subSelectFetchKeyHandler;
            this.hql = hql;
        }

        @Override
        public void registerLoadingEntityHolder(EntityHolder holder) {
            this.subSelectFetchKeyHandler.addKey(holder);
        }

        @Override
        public String getQueryIdentifier(String sql) {
            if ("<criteria>".equals(this.hql)) {
                return "[CRITERIA] " + sql;
            }
            return this.hql;
        }
    }

    private static class CacheableSqmInterpretation {
        private final SelectStatement selectStatement;
        private final JdbcOperationQuerySelect jdbcSelect;
        private final FromClauseAccess tableGroupAccess;
        private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
        private final Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes;
        private transient JdbcParameterBindings firstParameterBindings;

        CacheableSqmInterpretation(SelectStatement selectStatement, JdbcOperationQuerySelect jdbcSelect, FromClauseAccess tableGroupAccess, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref, Map<SqmParameter<?>, MappingModelExpressible<?>> sqmParameterMappingModelTypes, JdbcParameterBindings firstParameterBindings) {
            this.selectStatement = selectStatement;
            this.jdbcSelect = jdbcSelect;
            this.tableGroupAccess = tableGroupAccess;
            this.jdbcParamsXref = jdbcParamsXref;
            this.sqmParameterMappingModelTypes = sqmParameterMappingModelTypes;
            this.firstParameterBindings = firstParameterBindings;
        }

        SelectStatement getSelectStatement() {
            return this.selectStatement;
        }

        JdbcOperationQuerySelect getJdbcSelect() {
            return this.jdbcSelect;
        }

        FromClauseAccess getTableGroupAccess() {
            return this.tableGroupAccess;
        }

        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> getJdbcParamsXref() {
            return this.jdbcParamsXref;
        }

        public Map<SqmParameter<?>, MappingModelExpressible<?>> getSqmParameterMappingModelTypes() {
            return this.sqmParameterMappingModelTypes;
        }

        JdbcParameterBindings getFirstParameterBindings() {
            return this.firstParameterBindings;
        }

        void setFirstParameterBindings(JdbcParameterBindings firstParameterBindings) {
            this.firstParameterBindings = firstParameterBindings;
        }
    }

    private static interface SqmInterpreter<T, X> {
        public T interpret(X var1, DomainQueryExecutionContext var2, CacheableSqmInterpretation var3, JdbcParameterBindings var4);
    }
}

