/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.generator.values;

import java.util.function.BiFunction;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class GeneratedValueBasicResultBuilder
implements ResultBuilder {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart modelPart;
    private final Integer valuesArrayPosition;
    private final TableGroup tableGroup;

    public GeneratedValueBasicResultBuilder(NavigablePath navigablePath, BasicValuedModelPart modelPart, TableGroup tableGroup, Integer valuesArrayPosition) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.valuesArrayPosition = valuesArrayPosition;
        this.tableGroup = tableGroup;
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getExpressibleJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().resolveTableGroup(this.navigablePath.getParent(), path -> this.tableGroup);
        TableReference tableReference = tableGroup.resolveTableReference(this.navigablePath, this.modelPart, "t");
        int position = this.valuesArrayPosition == null ? GeneratedValueBasicResultBuilder.columnIndex(jdbcResultsMetadata, this.modelPart) : this.valuesArrayPosition;
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(ResultsHelper.resolveSqlExpression(creationStateImpl, tableReference, this.modelPart, position), this.modelPart.getJdbcMapping().getJdbcJavaType(), null, creationStateImpl.getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.modelPart.getJdbcMapping());
    }

    public BasicValuedModelPart getModelPart() {
        return this.modelPart;
    }

    private static int columnIndex(JdbcValuesMetadata jdbcResultsMetadata, BasicValuedModelPart modelPart) {
        try {
            return ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcResultsMetadata.resolveColumnPosition(GeneratedValuesHelper.getActualGeneratedModelPart(modelPart).getSelectionExpression()));
        }
        catch (Exception e) {
            if (modelPart.isEntityIdentifierMapping()) {
                return 0;
            }
            throw e;
        }
    }
}

