/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.util.Set;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDeleteOrUpdateStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

public class QuerySplitter {
    public static <R> SqmSelectStatement<R>[] split(SqmSelectStatement<R> statement) {
        SqmRoot<?> unmappedPolymorphicReference = QuerySplitter.findUnmappedPolymorphicReference(statement.getQueryPart());
        if (unmappedPolymorphicReference == null) {
            SqmSelectStatement[] sqmSelectStatement = new SqmSelectStatement[]{statement};
            return sqmSelectStatement;
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedPathSource();
        Set<EntityDomainType<?>> implementors = unmappedPolymorphicDescriptor.getImplementors();
        SqmSelectStatement[] expanded = new SqmSelectStatement[implementors.size()];
        int i = 0;
        for (EntityDomainType<?> mappedDescriptor : implementors) {
            expanded[i++] = QuerySplitter.copyStatement(statement, unmappedPolymorphicReference, mappedDescriptor);
        }
        return expanded;
    }

    private static SqmRoot<?> findUnmappedPolymorphicReference(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            return ((SqmQuerySpec)queryPart).getRoots().stream().filter(sqmRoot -> sqmRoot.getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor).findFirst().orElse(null);
        }
        SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
        SqmRoot<?> root = QuerySplitter.findUnmappedPolymorphicReference(queryGroup.getQueryParts().get(0));
        if (root != null) {
            throw new UnsupportedOperationException("Polymorphic query group is unsupported");
        }
        return null;
    }

    private static <S extends SqmStatement<?>> S copyStatement(S statement, SqmRoot unmappedPolymorphicReference, EntityDomainType<?> mappedDescriptor) {
        SqmCopyContext context = SqmCopyContext.noParamCopyContext();
        SqmRoot<?> path = context.registerCopy(unmappedPolymorphicReference, new SqmRoot(mappedDescriptor, unmappedPolymorphicReference.getExplicitAlias(), unmappedPolymorphicReference.isAllowJoins(), (NodeBuilder)unmappedPolymorphicReference.nodeBuilder()));
        unmappedPolymorphicReference.copyTo(path, context);
        return (S)statement.copy(context);
    }

    public static <R> SqmDeleteStatement<R>[] split(SqmDeleteStatement<R> statement) {
        SqmRoot<?> unmappedPolymorphicReference = QuerySplitter.findUnmappedPolymorphicReference(statement);
        if (unmappedPolymorphicReference == null) {
            SqmDeleteStatement[] sqmDeleteStatement = new SqmDeleteStatement[]{statement};
            return sqmDeleteStatement;
        }
        SqmPolymorphicRootDescriptor unmappedPolymorphicDescriptor = (SqmPolymorphicRootDescriptor)unmappedPolymorphicReference.getReferencedPathSource();
        Set<EntityDomainType<?>> implementors = unmappedPolymorphicDescriptor.getImplementors();
        SqmDeleteStatement[] expanded = new SqmDeleteStatement[implementors.size()];
        int i = 0;
        for (EntityDomainType<?> mappedDescriptor : implementors) {
            expanded[i++] = QuerySplitter.copyStatement(statement, unmappedPolymorphicReference, mappedDescriptor);
        }
        return expanded;
    }

    private static SqmRoot<?> findUnmappedPolymorphicReference(SqmDeleteOrUpdateStatement<?> queryPart) {
        if (((AbstractSqmPath)((Object)queryPart.getTarget())).getReferencedPathSource() instanceof SqmPolymorphicRootDescriptor) {
            return queryPart.getTarget();
        }
        return null;
    }
}

