
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for LazyWithExtraEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="LazyWithExtraEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="extra"/>
 *     <enumeration value="false"/>
 *     <enumeration value="true"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "LazyWithExtraEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmLazyWithExtraEnum {

    @XmlEnumValue("extra")
    EXTRA("extra"),
    @XmlEnumValue("false")
    FALSE("false"),
    @XmlEnumValue("true")
    TRUE("true");
    private final String value;

    JaxbHbmLazyWithExtraEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmLazyWithExtraEnum fromValue(String v) {
        for (JaxbHbmLazyWithExtraEnum c: JaxbHbmLazyWithExtraEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
