
package org.hibernate.boot.jaxb.hbm.spi;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for LazyEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="LazyEnum">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="false"/>
 *     <enumeration value="proxy"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "LazyEnum", namespace = "http://www.hibernate.org/xsd/orm/hbm")
@XmlEnum
public enum JaxbHbmLazyEnum {

    @XmlEnumValue("false")
    FALSE("false"),
    @XmlEnumValue("proxy")
    PROXY("proxy");
    private final String value;

    JaxbHbmLazyEnum(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static JaxbHbmLazyEnum fromValue(String v) {
        for (JaxbHbmLazyEnum c: JaxbHbmLazyEnum.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
