/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.HANAServerConfiguration;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;

public class HANADialect
extends AbstractHANADialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(1, 0, 120);

    public HANADialect(DialectResolutionInfo info) {
        this(HANAServerConfiguration.fromDialectResolutionInfo(info), true);
        this.registerKeywords(info);
    }

    public HANADialect() {
        this(MINIMUM_VERSION);
    }

    public HANADialect(DatabaseVersion version) {
        this(new HANAServerConfiguration(version), true);
    }

    public HANADialect(DatabaseVersion version, boolean defaultTableTypeColumn) {
        this(new HANAServerConfiguration(version), defaultTableTypeColumn);
    }

    public HANADialect(HANAServerConfiguration configuration, boolean defaultTableTypeColumn) {
        super(configuration, defaultTableTypeColumn);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }
}

