/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.IllegalSelectQueryException;
import org.hibernate.query.Order;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ConvertedBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmUtil {
    private SqmUtil() {
    }

    public static boolean isSelect(SqmStatement<?> sqm) {
        return sqm instanceof SqmSelectStatement;
    }

    public static boolean isMutation(SqmStatement<?> sqm) {
        return sqm instanceof SqmDmlStatement;
    }

    public static void verifyIsSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isSelect(sqm)) {
            throw new IllegalSelectQueryException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()), hqlString);
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement<?> sqm, String hqlString) {
        if (!SqmUtil.isMutation(sqm)) {
            throw SqmUtil.expectingNonSelect(sqm, hqlString);
        }
    }

    public static IllegalQueryOperationException expectingNonSelect(SqmStatement<?> sqm, String hqlString) {
        return new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()), hqlString, null);
    }

    public static boolean needsTargetTableMapping(SqmPath<?> sqmPath, ModelPartContainer modelPartContainer) {
        return modelPartContainer.getPartMappingType() != modelPartContainer && sqmPath.getLhs() instanceof SqmFrom && modelPartContainer.getPartMappingType() instanceof ManagedMappingType;
    }

    public static boolean isFkOptimizationAllowed(SqmPath<?> sqmPath) {
        if (sqmPath instanceof SqmJoin) {
            SqmJoin sqmJoin = (SqmJoin)sqmPath;
            switch (sqmJoin.getSqmJoinType()) {
                case INNER: 
                case LEFT: {
                    return !(sqmJoin instanceof SqmQualifiedJoin) || ((SqmQualifiedJoin)sqmJoin).getJoinPredicate() == null;
                }
            }
            return false;
        }
        return false;
    }

    public static <T, A> SqmAttributeJoin<T, A> findCompatibleFetchJoin(SqmFrom<?, T> sqmFrom, SqmPathSource<A> pathSource, SqmJoinType requestedJoinType) {
        for (SqmJoin<T, ?> join : sqmFrom.getSqmJoins()) {
            SqmAttributeJoin attributeJoin;
            if (join.getReferencedPathSource() != pathSource || !(attributeJoin = (SqmAttributeJoin)join).isFetched()) continue;
            SqmJoinType joinType = join.getSqmJoinType();
            if (joinType != requestedJoinType) {
                throw new IllegalStateException(String.format("Requested join fetch with association [%s] with '%s' join type, but found existing join fetch with '%s' join type.", new Object[]{pathSource.getPathName(), requestedJoinType, joinType}));
            }
            return attributeJoin;
        }
        return null;
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        int queryParameterCount = domainParameterXref.getQueryParameterCount();
        IdentityHashMap result = new IdentityHashMap(queryParameterCount);
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getQueryParameters().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter<?> sqmParam : sqmParams) {
                List<List<JdbcParameter>> lists = jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam);
                sqmParamMap.put(sqmParam, SqmUtil.convert(lists));
                List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter<?> expansion : expansions) {
                    List<List<JdbcParameter>> innerList = jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion);
                    sqmParamMap.put(expansion, SqmUtil.convert(innerList));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }

    private static List<JdbcParametersList> convert(List<List<JdbcParameter>> lists) {
        if (lists == null) {
            return null;
        }
        ArrayList<JdbcParametersList> output = new ArrayList<JdbcParametersList>(lists.size());
        for (List<JdbcParameter> element : lists) {
            output.add(JdbcParametersList.fromList(element));
        }
        return output;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamXref, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter<?>>> entry : domainParameterXref.getQueryParameters().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter<?>> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            Map<SqmParameter<?>, List<JdbcParametersList>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter<?> sqmParameter : sqmParameters) {
                BasicValueConverter valueConverter;
                MappingModelExpressible<?> resolvedMappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameter);
                if (resolvedMappingModelType != null) {
                    domainParamBinding.setType(resolvedMappingModelType);
                }
                Bindable parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, sqmParameters, mappingModelResolutionAccess, session.getFactory());
                List<JdbcParametersList> jdbcParamsBinds = jdbcParamMap.get(sqmParameter);
                if (jdbcParamsBinds == null) continue;
                if (!domainParamBinding.isBound()) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        parameterType.forEachJdbcType((position, jdbcMapping) -> jdbcParameterBindings.addBinding(jdbcParams.get(position), new JdbcParameterBindingImpl((JdbcMapping)jdbcMapping, null)));
                    }
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    Object firstValue = valueItr.next();
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, firstValue, tableGroupLocator, session);
                    }
                    List<SqmParameter<?>> expansions = domainParameterXref.getExpansions(sqmParameter);
                    int expansionCount = bindValues.size() - 1;
                    int parameterUseCount = jdbcParamsBinds.size();
                    assert (expansions.size() == expansionCount * parameterUseCount);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        Object expandedValue = valueItr.next();
                        for (int j = 0; j < parameterUseCount; ++j) {
                            SqmParameter<?> expansionSqmParam = expansions.get(expansionPosition + j * expansionCount);
                            List<JdbcParametersList> jdbcParamBinds = jdbcParamMap.get(expansionSqmParam);
                            for (int i = 0; i < jdbcParamBinds.size(); ++i) {
                                JdbcParametersList expansionJdbcParams = jdbcParamBinds.get(i);
                                SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, expansionJdbcParams, expandedValue, tableGroupLocator, session);
                            }
                        }
                        ++expansionPosition;
                    }
                    continue;
                }
                JdbcMapping jdbcMapping2 = domainParamBinding.getType() instanceof JdbcMapping ? (JdbcMapping)((Object)domainParamBinding.getType()) : (domainParamBinding.getBindType() instanceof BasicValuedMapping ? ((BasicValuedMapping)domainParamBinding.getType()).getJdbcMapping() : null);
                BasicValueConverter basicValueConverter = valueConverter = jdbcMapping2 == null ? null : jdbcMapping2.getValueConverter();
                if (valueConverter != null) {
                    Object convertedValue = valueConverter.toRelationalValue(domainParamBinding.getBindValue());
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        assert (jdbcParams.size() == 1);
                        JdbcParameter jdbcParameter = jdbcParams.get(0);
                        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, convertedValue));
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                if (bindValue == null) {
                    for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                        JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                        for (int j = 0; j < jdbcParams.size(); ++j) {
                            JdbcParameter jdbcParameter = jdbcParams.get(j);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping2, bindValue));
                        }
                    }
                    continue;
                }
                for (int i = 0; i < jdbcParamsBinds.size(); ++i) {
                    JdbcParametersList jdbcParams = jdbcParamsBinds.get(i);
                    SqmUtil.createValueBindings(jdbcParameterBindings, queryParam, domainParamBinding, parameterType, jdbcParams, bindValue, tableGroupLocator, session);
                }
            }
        }
        return jdbcParameterBindings;
    }

    private static void createValueBindings(JdbcParameterBindings jdbcParameterBindings, QueryParameterImplementor<?> domainParam, QueryParameterBinding<?> domainParamBinding, Bindable parameterType, JdbcParametersList jdbcParams, Object bindValue, Function<NavigablePath, TableGroup> tableGroupLocator, SharedSessionContractImplementor session) {
        EntityIdentifierMapping identifierMapping;
        if (parameterType == null) {
            throw new SqlTreeCreationException("Unable to interpret mapping-model type for Query parameter : " + domainParam);
        }
        if (parameterType instanceof PluralAttributeMapping) {
            parameterType = ((PluralAttributeMapping)parameterType).getElementDescriptor();
        }
        if (parameterType instanceof EntityIdentifierMapping) {
            identifierMapping = parameterType;
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityMappingType) {
            identifierMapping = ((EntityMappingType)((Object)parameterType)).getIdentifierMapping();
            EntityMappingType entityMapping = identifierMapping.findContainingEntityMapping();
            parameterType = identifierMapping;
            if (entityMapping.getRepresentationStrategy().getInstantiator().isInstance(bindValue, session.getFactory())) {
                bindValue = identifierMapping.getIdentifierIfNotUnsaved(bindValue, session);
            }
        } else if (parameterType instanceof EntityAssociationMapping) {
            EntityAssociationMapping association = (EntityAssociationMapping)((Object)parameterType);
            if (association.getSideNature() == ForeignKeyDescriptor.Nature.TARGET) {
                bindValue = association.getAssociatedEntityMappingType().getIdentifierMapping().getIdentifier(bindValue);
                parameterType = association.getAssociatedEntityMappingType().getIdentifierMapping();
            } else {
                bindValue = association.getForeignKeyDescriptor().getAssociationKeyFromSide(bindValue, association.getSideNature().inverse(), session);
                parameterType = association.getForeignKeyDescriptor();
            }
        } else if (parameterType instanceof JavaObjectType) {
            parameterType = domainParamBinding.getType();
        }
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(bindValue, parameterType, jdbcParams, session);
        assert (offset == jdbcParams.size());
    }

    public static Bindable determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, List<SqmParameter<?>> sqmParameters, SqmParameterMappingModelResolutionAccess mappingModelResolutionAccess, SessionFactoryImplementor sessionFactory) {
        Bindable tryOne = SqmUtil.asBindable(binding.getBindType());
        if (tryOne != null) {
            return tryOne;
        }
        Bindable tryTwo = SqmUtil.asBindable(parameter.getHibernateType());
        if (tryTwo != null) {
            return tryTwo;
        }
        if (binding.getType() != null) {
            return binding.getType();
        }
        for (int i = 0; i < sqmParameters.size(); ++i) {
            MappingModelExpressible<?> mappingModelType = mappingModelResolutionAccess.getResolvedMappingModelType(sqmParameters.get(i));
            if (mappingModelType == null) continue;
            return mappingModelType;
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        return typeConfiguration.standardBasicTypeForJavaType(parameter.getParameterType());
    }

    private static Bindable asBindable(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BasicTypeImpl) {
            return (BasicTypeImpl)o;
        }
        if (o instanceof ConvertedBasicTypeImpl) {
            return (ConvertedBasicTypeImpl)o;
        }
        if (o instanceof Bindable) {
            return (Bindable)o;
        }
        return null;
    }

    public static SqmStatement.ParameterResolutions resolveParameters(final SqmStatement<?> statement) {
        if (statement.getQuerySource() == SqmQuerySource.CRITERIA) {
            CriteriaParameterCollector parameterCollector = new CriteriaParameterCollector();
            ParameterCollector.collectParameters(statement, parameterCollector::process);
            return parameterCollector.makeResolution();
        }
        return new SqmStatement.ParameterResolutions(){

            @Override
            public Set<SqmParameter<?>> getSqmParameters() {
                return statement.getSqmParameters();
            }

            @Override
            public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
                return Collections.emptyMap();
            }
        };
    }

    static JpaOrder sortSpecification(SqmSelectStatement<?> sqm, Order<?> order) {
        List<SqmSelectableNode<?>> items = ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelectionItems();
        int element = order.getElement();
        if (element < 1) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (the first select item is element 1)");
        }
        if (element > items.size()) {
            throw new IllegalQueryOperationException("Cannot order by element " + element + " (there are only " + items.size() + " select items)");
        }
        SqmSelectableNode<?> selected = items.get(element - 1);
        NodeBuilder builder = sqm.nodeBuilder();
        if (order.getEntityClass() == null) {
            return new SqmSortSpecification(new SqmAliasedNodeRef(element, builder.getIntegerType(), builder), order.getDirection());
        }
        if (items.size() == 1) {
            if (selected instanceof SqmRoot) {
                SqmFrom root = (SqmFrom)selected;
                if (!order.getEntityClass().isAssignableFrom(root.getJavaType())) {
                    throw new IllegalQueryOperationException("Select item was of wrong entity type");
                }
                StringTokenizer tokens = new StringTokenizer(order.getAttributeName(), ".");
                JpaPath path = root;
                while (tokens.hasMoreTokens()) {
                    path = path.get(tokens.nextToken());
                }
                return builder.sort((JpaExpression)path, order.getDirection(), order.getNullPrecedence(), order.isCaseInsensitive());
            }
            throw new IllegalQueryOperationException("Select item was not an entity type");
        }
        throw new IllegalQueryOperationException("Query has multiple items in the select list");
    }

    public static boolean isSelectionAssignableToResultType(SqmSelection<?> selection, Class<?> expectedResultType) {
        if (expectedResultType == null || selection != null && selection.getSelectableNode() instanceof SqmParameter) {
            return true;
        }
        if (selection == null || !SqmUtil.isHqlTuple(selection) && selection.getSelectableNode().isCompoundSelection()) {
            return false;
        }
        JavaType nodeJavaType = selection.getNodeJavaType();
        return nodeJavaType != null && expectedResultType.isAssignableFrom(nodeJavaType.getJavaTypeClass());
    }

    public static boolean isHqlTuple(SqmSelection<?> selection) {
        return selection != null && selection.getSelectableNode() instanceof SqmTuple;
    }

    private static class ParameterResolutionsImpl
    implements SqmStatement.ParameterResolutions {
        private final Set<SqmParameter<?>> sqmParameters;
        private final Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> jpaCriteriaParamResolutions;

        public ParameterResolutionsImpl(Set<SqmParameter<?>> sqmParameters, Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions) {
            this.sqmParameters = sqmParameters;
            if (jpaCriteriaParamResolutions == null || jpaCriteriaParamResolutions.isEmpty()) {
                this.jpaCriteriaParamResolutions = Collections.emptyMap();
            } else {
                this.jpaCriteriaParamResolutions = new IdentityHashMap(CollectionHelper.determineProperSizing(jpaCriteriaParamResolutions));
                for (Map.Entry<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> entry : jpaCriteriaParamResolutions.entrySet()) {
                    Iterator<SqmJpaCriteriaParameterWrapper<?>> itr = entry.getValue().iterator();
                    if (!itr.hasNext()) {
                        throw new IllegalStateException("SqmJpaCriteriaParameterWrapper references for JpaCriteriaParameter [" + entry.getKey() + "] already exhausted");
                    }
                    this.jpaCriteriaParamResolutions.put(entry.getKey(), itr.next());
                }
            }
        }

        @Override
        public Set<SqmParameter<?>> getSqmParameters() {
            return this.sqmParameters;
        }

        @Override
        public Map<JpaCriteriaParameter<?>, SqmJpaCriteriaParameterWrapper<?>> getJpaCriteriaParamResolutions() {
            return this.jpaCriteriaParamResolutions;
        }
    }

    private static class CriteriaParameterCollector {
        private Set<SqmParameter<?>> sqmParameters;
        private Map<JpaCriteriaParameter<?>, List<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;

        private CriteriaParameterCollector() {
        }

        public void process(SqmParameter<?> parameter) {
            if (this.sqmParameters == null) {
                this.sqmParameters = new LinkedHashSet();
            }
            if (parameter instanceof SqmJpaCriteriaParameterWrapper) {
                if (this.jpaCriteriaParamResolutions == null) {
                    this.jpaCriteriaParamResolutions = new IdentityHashMap();
                }
                SqmJpaCriteriaParameterWrapper wrapper = (SqmJpaCriteriaParameterWrapper)parameter;
                JpaCriteriaParameter criteriaParameter = wrapper.getJpaCriteriaParameter();
                List sqmParametersForCriteriaParameter = this.jpaCriteriaParamResolutions.computeIfAbsent(criteriaParameter, jcp -> new ArrayList());
                sqmParametersForCriteriaParameter.add(wrapper);
                this.sqmParameters.add(wrapper);
            } else {
                if (parameter instanceof JpaCriteriaParameter) {
                    throw new UnsupportedOperationException();
                }
                this.sqmParameters.add(parameter);
            }
        }

        private SqmStatement.ParameterResolutions makeResolution() {
            return new ParameterResolutionsImpl(this.sqmParameters == null ? Collections.emptySet() : this.sqmParameters, this.jpaCriteriaParamResolutions == null ? Collections.emptyMap() : this.jpaCriteriaParamResolutions);
        }
    }
}

