/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.DeleteOrUpsertOperation;
import org.hibernate.sql.model.jdbc.UpsertOperation;

public class SqlAstTranslatorWithUpsert<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    protected SqlAstTranslatorWithUpsert(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public MutationOperation createMergeOperation(OptionalTableUpdate optionalTableUpdate) {
        this.renderUpsertStatement(optionalTableUpdate);
        UpsertOperation upsertOperation = new UpsertOperation(optionalTableUpdate.getMutatingTable().getTableMapping(), optionalTableUpdate.getMutationTarget(), this.getSql(), this.getParameterBinders());
        return new DeleteOrUpsertOperation(optionalTableUpdate.getMutationTarget(), (EntityTableMapping)optionalTableUpdate.getMutatingTable().getTableMapping(), upsertOperation, optionalTableUpdate);
    }

    protected void renderUpsertStatement(OptionalTableUpdate optionalTableUpdate) {
        this.renderMergeInto(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeUsing(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeOn(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeInsert(optionalTableUpdate);
        this.appendSql(" ");
        this.renderMergeUpdate(optionalTableUpdate);
    }

    protected void renderMergeInto(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("merge into ");
        this.renderMergeTarget(optionalTableUpdate);
    }

    private void renderMergeTarget(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql(optionalTableUpdate.getMutatingTable().getTableName());
        this.renderMergeTargetAlias();
    }

    protected void renderMergeTargetAlias() {
        this.appendSql(" as t");
    }

    protected void renderMergeUsing(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("using ");
        this.renderMergeSource(optionalTableUpdate);
    }

    protected boolean wrapMergeSourceExpression() {
        return true;
    }

    protected void renderMergeSource(OptionalTableUpdate optionalTableUpdate) {
        int i;
        if (this.wrapMergeSourceExpression()) {
            this.appendSql(" (");
        }
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        StringBuilder columnList = new StringBuilder();
        this.appendSql(" values (");
        for (i = 0; i < keyBindings.size(); ++i) {
            ColumnValueBinding keyBinding = keyBindings.get(i);
            if (i > 0) {
                this.appendSql(", ");
                columnList.append(", ");
            }
            columnList.append(keyBinding.getColumnReference().getColumnExpression());
            this.renderCasted(keyBinding.getValueExpression());
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            columnList.append(", ");
            ColumnValueBinding valueBinding = valueBindings.get(i);
            columnList.append(valueBinding.getColumnReference().getColumnExpression());
            this.renderCasted(valueBinding.getValueExpression());
        }
        this.appendSql(") ");
        if (this.wrapMergeSourceExpression()) {
            this.appendSql(") ");
        }
        this.renderMergeSourceAlias();
        this.appendSql("(");
        this.appendSql(columnList.toString());
        this.appendSql(")");
    }

    protected void renderMergeSourceAlias() {
        this.appendSql(" as s");
    }

    protected void renderMergeOn(OptionalTableUpdate optionalTableUpdate) {
        this.appendSql("on (");
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        for (int i = 0; i < keyBindings.size(); ++i) {
            ColumnValueBinding keyBinding = keyBindings.get(i);
            if (i > 0) {
                this.appendSql(" and ");
            }
            keyBinding.getColumnReference().appendReadExpression(this, "t");
            this.appendSql("=");
            keyBinding.getColumnReference().appendReadExpression(this, "s");
        }
        this.appendSql(")");
    }

    protected void renderMergeInsert(OptionalTableUpdate optionalTableUpdate) {
        int i;
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> keyBindings = optionalTableUpdate.getKeyBindings();
        StringBuilder valuesList = new StringBuilder();
        this.appendSql("when not matched then insert (");
        for (i = 0; i < keyBindings.size(); ++i) {
            if (i > 0) {
                this.appendSql(", ");
                valuesList.append(", ");
            }
            ColumnValueBinding keyBinding = keyBindings.get(i);
            this.appendSql(keyBinding.getColumnReference().getColumnExpression());
            keyBinding.getColumnReference().appendReadExpression("s", valuesList::append);
        }
        for (i = 0; i < valueBindings.size(); ++i) {
            this.appendSql(", ");
            valuesList.append(", ");
            ColumnValueBinding valueBinding = valueBindings.get(i);
            this.appendSql(valueBinding.getColumnReference().getColumnExpression());
            valueBinding.getColumnReference().appendReadExpression("s", valuesList::append);
        }
        this.appendSql(") values (");
        this.appendSql(valuesList.toString());
        this.appendSql(")");
    }

    protected void renderMergeUpdate(OptionalTableUpdate optionalTableUpdate) {
        List<ColumnValueBinding> valueBindings = optionalTableUpdate.getValueBindings();
        List<ColumnValueBinding> optimisticLockBindings = optionalTableUpdate.getOptimisticLockBindings();
        this.appendSql(" when matched then update set ");
        for (int i = 0; i < valueBindings.size(); ++i) {
            ColumnValueBinding binding = valueBindings.get(i);
            if (i > 0) {
                this.appendSql(", ");
            }
            binding.getColumnReference().appendColumnForWrite(this, "t");
            this.appendSql("=");
            binding.getColumnReference().appendColumnForWrite(this, "s");
        }
        this.renderMatchedWhere(optimisticLockBindings);
    }

    private void renderMatchedWhere(List<ColumnValueBinding> optimisticLockBindings) {
        if (!optimisticLockBindings.isEmpty()) {
            this.appendSql(" where ");
            for (int i = 0; i < optimisticLockBindings.size(); ++i) {
                ColumnValueBinding binding = optimisticLockBindings.get(i);
                if (i > 0) {
                    this.appendSql(" and ");
                }
                binding.getColumnReference().appendColumnForWrite(this, "t");
                this.appendSql("<=");
                binding.getValueExpression().accept(this);
            }
        }
    }
}

