/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.internal.JdbcServicesImpl;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.EmptyEventManager;
import org.hibernate.event.spi.EventManager;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jpa.internal.MutableJpaComplianceImpl;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.JdbcSessionOwner;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class JdbcEnvironmentInitiator
implements StandardServiceInitiator<JdbcEnvironment> {
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JdbcEnvironmentInitiator.class.getName());
    public static final JdbcEnvironmentInitiator INSTANCE = new JdbcEnvironmentInitiator();
    @Deprecated(since="6", forRemoval=true)
    private static final String USE_JDBC_METADATA_DEFAULTS = "hibernate.temp.use_jdbc_metadata_defaults";

    @Override
    public Class<JdbcEnvironment> getServiceInitiated() {
        return JdbcEnvironment.class;
    }

    @Override
    public JdbcEnvironment initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        DialectFactory dialectFactory = registry.requireService(DialectFactory.class);
        String explicitDatabaseName = JdbcEnvironmentInitiator.getExplicitDatabaseName(configurationValues);
        Integer explicitDatabaseMajorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMajorVersion(configurationValues);
        Integer explicitDatabaseMinorVersion = JdbcEnvironmentInitiator.getExplicitDatabaseMinorVersion(configurationValues);
        String explicitDatabaseVersion = JdbcEnvironmentInitiator.getExplicitDatabaseVersion(configurationValues, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion);
        if (explicitDatabaseMajorVersion == null && explicitDatabaseMinorVersion == null && explicitDatabaseVersion != null) {
            String[] parts = explicitDatabaseVersion.split("\\.");
            try {
                int potentialMajor = Integer.parseInt(parts[0]);
                if (parts.length > 1) {
                    explicitDatabaseMinorVersion = Integer.parseInt(parts[1]);
                }
                explicitDatabaseMajorVersion = potentialMajor;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (JdbcEnvironmentInitiator.allowJdbcMetadataAccess(configurationValues)) {
            return this.getJdbcEnvironmentUsingJdbcMetadata(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        if (JdbcEnvironmentInitiator.explicitDialectConfiguration(explicitDatabaseName, configurationValues)) {
            return JdbcEnvironmentInitiator.getJdbcEnvironmentWithExplicitConfiguration(configurationValues, registry, dialectFactory, explicitDatabaseName, explicitDatabaseMajorVersion, explicitDatabaseMinorVersion, explicitDatabaseVersion);
        }
        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithDefaults(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory) {
        Dialect dialect = dialectFactory.buildDialect(configurationValues, null);
        return new JdbcEnvironmentImpl(registry, dialect);
    }

    private static JdbcEnvironmentImpl getJdbcEnvironmentWithExplicitConfiguration(Map<String, Object> configurationValues, ServiceRegistryImplementor registry, DialectFactory dialectFactory, String explicitDatabaseName, Integer explicitDatabaseMajorVersion, Integer explicitDatabaseMinorVersion, String explicitDatabaseVersion) {
        DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(null, explicitDatabaseName, explicitDatabaseVersion, explicitDatabaseMajorVersion != null ? explicitDatabaseMajorVersion : -9999, explicitDatabaseMinorVersion != null ? explicitDatabaseMinorVersion : -9999, -9999, null, -9999, -9999, null, configurationValues);
        Dialect dialect = dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo);
        return new JdbcEnvironmentImpl(registry, dialect);
    }

    private static boolean allowJdbcMetadataAccess(Map<String, Object> configurationValues) {
        Boolean allow = ConfigurationHelper.getBooleanWrapper("hibernate.boot.allow_jdbc_metadata_access", configurationValues, null);
        if (allow != null) {
            return allow;
        }
        Boolean use = ConfigurationHelper.getBooleanWrapper(USE_JDBC_METADATA_DEFAULTS, configurationValues, null);
        if (use != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting(USE_JDBC_METADATA_DEFAULTS, "hibernate.boot.allow_jdbc_metadata_access");
            return use;
        }
        return true;
    }

    private static String getExplicitDatabaseVersion(Map<String, Object> configurationValues, Integer configuredDatabaseMajorVersion, Integer configuredDatabaseMinorVersion) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-version"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-version");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-version", "jakarta.persistence.database-product-version");
            }
            return (String)value;
        }, () -> {
            if (configuredDatabaseMajorVersion != null) {
                return configuredDatabaseMinorVersion == null ? configuredDatabaseMajorVersion.toString() : configuredDatabaseMajorVersion + "." + configuredDatabaseMinorVersion;
            }
            return null;
        });
    }

    private static Integer getExplicitDatabaseMinorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-minor-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-minor-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-minor-version", "jakarta.persistence.database-minor-version");
            }
            return value;
        });
    }

    private static Integer getExplicitDatabaseMajorVersion(Map<String, Object> configurationValues) {
        return (Integer)NullnessHelper.coalesceSuppliedValues(() -> ConfigurationHelper.getInteger("jakarta.persistence.database-major-version", configurationValues), () -> {
            Integer value = ConfigurationHelper.getInteger("javax.persistence.database-major-version", configurationValues);
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-major-version", "jakarta.persistence.database-major-version");
            }
            return value;
        });
    }

    private static String getExplicitDatabaseName(Map<String, Object> configurationValues) {
        return (String)NullnessHelper.coalesceSuppliedValues(() -> (String)configurationValues.get("jakarta.persistence.database-product-name"), () -> {
            Object value = configurationValues.get("javax.persistence.database-product-name");
            if (value != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.database-product-name", "jakarta.persistence.database-product-name");
            }
            return (String)value;
        });
    }

    private JdbcEnvironmentImpl getJdbcEnvironmentUsingJdbcMetadata(final Map<String, Object> configurationValues, final ServiceRegistryImplementor registry, final DialectFactory dialectFactory, final String explicitDatabaseName, final Integer explicitDatabaseMajorVersion, final Integer explicitDatabaseMinorVersion, final String explicitDatabaseVersion) {
        final JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(registry);
        JdbcServicesImpl jdbcServices = new JdbcServicesImpl(registry);
        TemporaryJdbcSessionOwner temporaryJdbcSessionOwner = new TemporaryJdbcSessionOwner(jdbcConnectionAccess, jdbcServices, registry);
        temporaryJdbcSessionOwner.transactionCoordinator = registry.requireService(TransactionCoordinatorBuilder.class).buildTransactionCoordinator(new JdbcCoordinatorImpl(null, temporaryJdbcSessionOwner, jdbcServices), () -> false);
        try {
            return temporaryJdbcSessionOwner.transactionCoordinator.createIsolationDelegate().delegateWork(new AbstractReturningWork<JdbcEnvironmentImpl>(){

                @Override
                public JdbcEnvironmentImpl execute(Connection connection) {
                    try {
                        DatabaseMetaData metadata = connection.getMetaData();
                        JdbcEnvironmentInitiator.logDatabaseAndDriver(metadata);
                        DialectResolutionInfoImpl dialectResolutionInfo = new DialectResolutionInfoImpl(metadata, explicitDatabaseName == null ? metadata.getDatabaseProductName() : explicitDatabaseName, explicitDatabaseVersion == null ? metadata.getDatabaseProductVersion() : explicitDatabaseVersion, explicitDatabaseMajorVersion == null ? metadata.getDatabaseMajorVersion() : explicitDatabaseMajorVersion.intValue(), explicitDatabaseMinorVersion == null ? metadata.getDatabaseMinorVersion() : explicitDatabaseMinorVersion.intValue(), explicitDatabaseMinorVersion == null ? this.databaseMicroVersion(metadata) : 0, metadata.getDriverName(), metadata.getDriverMajorVersion(), metadata.getDriverMinorVersion(), metadata.getSQLKeywords(), configurationValues);
                        return new JdbcEnvironmentImpl(registry, dialectFactory.buildDialect(configurationValues, () -> dialectResolutionInfo), metadata, jdbcConnectionAccess);
                    }
                    catch (SQLException e) {
                        log.unableToObtainConnectionMetadata(e);
                        return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
                    }
                }

                private int databaseMicroVersion(DatabaseMetaData metadata) throws SQLException {
                    String prefix;
                    String version = metadata.getDatabaseProductVersion();
                    if (version.startsWith(prefix = metadata.getDatabaseMajorVersion() + "." + metadata.getDatabaseMinorVersion() + ".")) {
                        try {
                            String substring = version.substring(prefix.length());
                            String micro = new StringTokenizer(substring, " .,-:;/()[]").nextToken();
                            return Integer.parseInt(micro);
                        }
                        catch (NumberFormatException nfe) {
                            return 0;
                        }
                    }
                    return 0;
                }
            }, false);
        }
        catch (Exception e) {
            log.unableToObtainConnectionToQueryMetadata(e);
            return JdbcEnvironmentInitiator.getJdbcEnvironmentWithDefaults(configurationValues, registry, dialectFactory);
        }
    }

    private static void logDatabaseAndDriver(DatabaseMetaData dbmd) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debugf("Database ->\n\t   name : %s\n\tversion : %s\n\t  major : %s\n\t  minor : %s", new Object[]{dbmd.getDatabaseProductName(), dbmd.getDatabaseProductVersion(), dbmd.getDatabaseMajorVersion(), dbmd.getDatabaseMinorVersion()});
            log.debugf("Driver ->\n\t   name : %s\n\tversion : %s\n\t  major : %s\n\t  minor : %s", new Object[]{dbmd.getDriverName(), dbmd.getDriverVersion(), dbmd.getDriverMajorVersion(), dbmd.getDriverMinorVersion()});
            log.debugf("JDBC version : %s.%s", dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion());
        }
    }

    private static boolean explicitDialectConfiguration(String explicitDatabaseName, Map<String, Object> configurationValues) {
        return StringHelper.isNotEmpty(explicitDatabaseName) || JdbcEnvironmentInitiator.isNotNullAndNotEmpty(configurationValues.get("hibernate.dialect"));
    }

    private static boolean isNotNullAndNotEmpty(Object o) {
        return o != null && (!(o instanceof String) || !((String)o).isEmpty());
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            return new ConnectionProviderJdbcConnectionAccess(registry.requireService(ConnectionProvider.class));
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    public static JdbcConnectionAccess buildBootstrapJdbcConnectionAccess(ServiceRegistryImplementor registry) {
        if (!JdbcEnvironmentImpl.isMultiTenancyEnabled(registry)) {
            return new ConnectionProviderJdbcConnectionAccess(registry.requireService(ConnectionProvider.class));
        }
        MultiTenantConnectionProvider multiTenantConnectionProvider = registry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    private static class TemporaryJdbcSessionOwner
    implements JdbcSessionOwner,
    JdbcSessionContext {
        private final JdbcConnectionAccess jdbcConnectionAccess;
        private final JdbcServices jdbcServices;
        private final ServiceRegistryImplementor serviceRegistry;
        private final boolean jtaTrackByThread;
        private final boolean preferUserTransaction;
        private final boolean connectionProviderDisablesAutoCommit;
        private final PhysicalConnectionHandlingMode connectionHandlingMode;
        private final JpaCompliance jpaCompliance;
        private static final EmptyJdbcObserver EMPTY_JDBC_OBSERVER = EmptyJdbcObserver.INSTANCE;
        TransactionCoordinator transactionCoordinator;
        private final EmptyEventManager eventManager;

        public TemporaryJdbcSessionOwner(JdbcConnectionAccess jdbcConnectionAccess, JdbcServices jdbcServices, ServiceRegistryImplementor serviceRegistry) {
            this.jdbcConnectionAccess = jdbcConnectionAccess;
            this.jdbcServices = jdbcServices;
            this.serviceRegistry = serviceRegistry;
            ConfigurationService configuration = serviceRegistry.requireService(ConfigurationService.class);
            this.jtaTrackByThread = configuration.getSetting("hibernate.jta.track_by_thread", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.preferUserTransaction = ConfigurationHelper.getBoolean("hibernate.jta.prefer_user_transaction", configuration.getSettings());
            this.connectionProviderDisablesAutoCommit = ConfigurationHelper.getBoolean("hibernate.connection.provider_disables_autocommit", configuration.getSettings());
            PhysicalConnectionHandlingMode specifiedHandlingMode = PhysicalConnectionHandlingMode.interpret(configuration.getSettings().get("hibernate.connection.handling_mode"));
            this.connectionHandlingMode = specifiedHandlingMode != null ? specifiedHandlingMode : serviceRegistry.requireService(TransactionCoordinatorBuilder.class).getDefaultConnectionHandlingMode();
            this.jpaCompliance = new MutableJpaComplianceImpl(Collections.emptyMap(), false);
            this.eventManager = new EmptyEventManager();
        }

        @Override
        public JdbcSessionContext getJdbcSessionContext() {
            return this;
        }

        @Override
        public JdbcConnectionAccess getJdbcConnectionAccess() {
            return this.jdbcConnectionAccess;
        }

        @Override
        public TransactionCoordinator getTransactionCoordinator() {
            return this.transactionCoordinator;
        }

        @Override
        public void startTransactionBoundary() {
        }

        @Override
        public void afterTransactionBegin() {
        }

        @Override
        public void beforeTransactionCompletion() {
        }

        @Override
        public void afterTransactionCompletion(boolean successful, boolean delayed) {
        }

        @Override
        public void flushBeforeTransactionCompletion() {
        }

        @Override
        public Integer getJdbcBatchSize() {
            return null;
        }

        @Override
        public EventManager getEventManager() {
            return this.eventManager;
        }

        @Override
        public boolean isScrollableResultSetsEnabled() {
            return false;
        }

        @Override
        public boolean isGetGeneratedKeysEnabled() {
            return false;
        }

        @Override
        public Integer getFetchSizeOrNull() {
            return null;
        }

        @Override
        @Deprecated
        public int getFetchSize() {
            return 0;
        }

        @Override
        public boolean doesConnectionProviderDisableAutoCommit() {
            return this.connectionProviderDisablesAutoCommit;
        }

        @Override
        public boolean isPreferUserTransaction() {
            return this.preferUserTransaction;
        }

        @Override
        public boolean isJtaTrackByThread() {
            return this.jtaTrackByThread;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public StatementInspector getStatementInspector() {
            return null;
        }

        @Override
        public JpaCompliance getJpaCompliance() {
            return this.jpaCompliance;
        }

        @Override
        public StatisticsImplementor getStatistics() {
            return null;
        }

        @Override
        @Deprecated
        public JdbcObserver getObserver() {
            return EMPTY_JDBC_OBSERVER;
        }

        @Override
        public SessionFactoryImplementor getSessionFactory() {
            return null;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public JdbcServices getJdbcServices() {
            return this.jdbcServices;
        }

        @Override
        public BatchBuilder getBatchBuilder() {
            return null;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        private static class EmptyJdbcObserver
        implements JdbcObserver {
            public static final EmptyJdbcObserver INSTANCE = new EmptyJdbcObserver();

            private EmptyJdbcObserver() {
            }

            @Override
            public void jdbcConnectionAcquisitionStart() {
            }

            @Override
            public void jdbcConnectionAcquisitionEnd(Connection connection) {
            }

            @Override
            public void jdbcConnectionReleaseStart() {
            }

            @Override
            public void jdbcConnectionReleaseEnd() {
            }

            @Override
            public void jdbcPrepareStatementStart() {
            }

            @Override
            public void jdbcPrepareStatementEnd() {
            }

            @Override
            public void jdbcExecuteStatementStart() {
            }

            @Override
            public void jdbcExecuteStatementEnd() {
            }

            @Override
            public void jdbcExecuteBatchStart() {
            }

            @Override
            public void jdbcExecuteBatchEnd() {
            }
        }
    }

    private static class DialectResolutionInfoImpl
    implements DialectResolutionInfo {
        private final DatabaseMetaData databaseMetadata;
        private final String databaseName;
        private final String databaseVersion;
        private final int databaseMajorVersion;
        private final int databaseMinorVersion;
        private final int databaseMicroVersion;
        private final String driverName;
        private final int driverMajorVersion;
        private final int driverMinorVersion;
        private final String sqlKeywords;
        private final Map<String, Object> configurationValues;

        public DialectResolutionInfoImpl(DatabaseMetaData databaseMetadata, String databaseName, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, int databaseMicroVersion, String driverName, int driverMajorVersion, int driverMinorVersion, String sqlKeywords, Map<String, Object> configurationValues) {
            this.databaseMetadata = databaseMetadata;
            this.databaseName = databaseName;
            this.databaseVersion = databaseVersion;
            this.databaseMajorVersion = databaseMajorVersion;
            this.databaseMinorVersion = databaseMinorVersion;
            this.databaseMicroVersion = databaseMicroVersion;
            this.driverName = driverName;
            this.driverMajorVersion = driverMajorVersion;
            this.driverMinorVersion = driverMinorVersion;
            this.sqlKeywords = sqlKeywords;
            this.configurationValues = configurationValues;
        }

        @Override
        public String getSQLKeywords() {
            return this.sqlKeywords;
        }

        @Override
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public String getDatabaseVersion() {
            return this.databaseVersion;
        }

        @Override
        public int getDatabaseMajorVersion() {
            return this.databaseMajorVersion;
        }

        @Override
        public int getDatabaseMinorVersion() {
            return this.databaseMinorVersion;
        }

        @Override
        public int getDatabaseMicroVersion() {
            return this.databaseMicroVersion;
        }

        @Override
        public String getDriverName() {
            return this.driverName;
        }

        @Override
        public int getDriverMajorVersion() {
            return this.driverMajorVersion;
        }

        @Override
        public int getDriverMinorVersion() {
            return this.driverMinorVersion;
        }

        @Override
        public DatabaseMetaData getDatabaseMetadata() {
            return this.databaseMetadata;
        }

        public String toString() {
            return this.getMajor() + "." + this.getMinor();
        }

        @Override
        public Map<String, Object> getConfigurationValues() {
            return this.configurationValues;
        }
    }

    public static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider<?> connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider<?> connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public MultiTenantConnectionProvider<?> getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    public static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public ConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }

        @Override
        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

